/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.oasis;

import ai.decart.oasis.Utils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001cB3\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u0010\u001a\u00020\u000f\"\u0006\b\u0001\u0010\u0001\u0018\u00012\u0006\u0010\u000e\u001a\u00028\u0001H\u0086\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lai/decart/oasis/JsonWebSocket;", "T", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lkotlinx/serialization/KSerializer;", "incomingSerializer", "Ljava/net/URI;", "uri", "Ljava/time/Duration;", "connectTimeout", "Lai/decart/oasis/JsonWebSocket$Listener;", "listener", "<init>", "(Lkotlinx/serialization/KSerializer;Ljava/net/URI;Ljava/time/Duration;Lai/decart/oasis/JsonWebSocket$Listener;)V", "message", "", "sendMessage", "(Ljava/lang/Object;)V", "close", "()V", "Lkotlinx/serialization/KSerializer;", "Ljava/net/http/WebSocket;", "innerWebSocket", "Ljava/net/http/WebSocket;", "getInnerWebSocket", "()Ljava/net/http/WebSocket;", "setInnerWebSocket", "(Ljava/net/http/WebSocket;)V", "Listener", "mirage-minecraft-mod_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nJsonWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonWebSocket.kt\nai/decart/oasis/JsonWebSocket\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,105:1\n205#2:106\n*S KotlinDebug\n*F\n+ 1 JsonWebSocket.kt\nai/decart/oasis/JsonWebSocket\n*L\n92#1:106\n*E\n"})
public final class JsonWebSocket<T>
implements AutoCloseable {
    @NotNull
    private final KSerializer<T> incomingSerializer;
    @Nullable
    private WebSocket innerWebSocket;

    public JsonWebSocket(@NotNull KSerializer<T> incomingSerializer, @NotNull URI uri, @NotNull Duration connectTimeout, @NotNull Listener<T> listener) {
        Intrinsics.checkNotNullParameter(incomingSerializer, (String)"incomingSerializer");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)connectTimeout, (String)"connectTimeout");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.incomingSerializer = incomingSerializer;
        WebSocket.Listener innerListener2 = new WebSocket.Listener(this, listener){
            private StringBuilder message;
            final /* synthetic */ JsonWebSocket<T> this$0;
            final /* synthetic */ Listener<T> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
                this.message = new StringBuilder();
            }

            public final StringBuilder getMessage() {
                return this.message;
            }

            public final void setMessage(StringBuilder stringBuilder) {
                Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
                this.message = stringBuilder;
            }

            public void onOpen(WebSocket webSocket) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Utils.INSTANCE.log("WebSocket opened");
                this.this$0.setInnerWebSocket(webSocket);
                webSocket.request(1L);
                this.$listener.onOpen();
            }

            public CompletionStage<Void> onClose(WebSocket webSocket, int status, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Utils.INSTANCE.log("WebSocket closed for reason: " + reason);
                this.this$0.setInnerWebSocket(webSocket);
                this.this$0.close();
                this.$listener.onClose(status, reason);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }

            public void onError(WebSocket webSocket, Throwable error) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Utils.INSTANCE.exception("WebSocket error", error);
                this.this$0.setInnerWebSocket(webSocket);
                this.this$0.close();
                this.$listener.onError(error);
            }

            public CompletionStage<Void> onText(WebSocket webSocket, CharSequence message, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.message.append(message);
                if (last) {
                    Object object;
                    String string = this.message.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String rawMessage = string;
                    Utils.INSTANCE.log("Received WebSocket message: " + rawMessage.length() + " | " + rawMessage);
                    try {
                        object = Json.Default.decodeFromString((DeserializationStrategy)JsonWebSocket.access$getIncomingSerializer$p(this.this$0), rawMessage);
                    }
                    catch (Exception error) {
                        Utils.INSTANCE.exception("Error decoding WebSocket message", error);
                        this.this$0.setInnerWebSocket(webSocket);
                        this.this$0.close();
                        this.$listener.onError(error);
                        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                        return completableFuture;
                    }
                    Object message2 = object;
                    this.message = new StringBuilder();
                    this.$listener.onMessage(message2);
                } else {
                    Utils.INSTANCE.log("Received WebSocket partial message: " + message.length() + " | " + message);
                }
                webSocket.request(1L);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
        };
        HttpClient.newHttpClient().newWebSocketBuilder().connectTimeout(connectTimeout).buildAsync(uri, innerListener2).whenComplete((arg_0, arg_1) -> JsonWebSocket._init_$lambda$1((arg_0, arg_1) -> JsonWebSocket._init_$lambda$0(this, listener, arg_0, arg_1), arg_0, arg_1));
    }

    @Nullable
    public final WebSocket getInnerWebSocket() {
        return this.innerWebSocket;
    }

    public final void setInnerWebSocket(@Nullable WebSocket webSocket) {
        this.innerWebSocket = webSocket;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> void sendMessage(T message) {
        block0: {
            void this_$iv;
            boolean $i$f$sendMessage = false;
            Json json = (Json)Json.Default;
            T value$iv = message;
            boolean $i$f$encodeToString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            String rawMessage = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), value$iv);
            Utils.INSTANCE.log("Sending WebSocket message: " + rawMessage);
            WebSocket webSocket = this.getInnerWebSocket();
            if (webSocket == null) break block0;
            webSocket.sendText(rawMessage, true);
        }
    }

    @Override
    public void close() {
        Utils.INSTANCE.log("Closing WebSocket");
        WebSocket webSocket = this.innerWebSocket;
        if (webSocket != null) {
            webSocket.sendClose(1000, "Normal Closure");
        }
        this.innerWebSocket = null;
    }

    private static final Unit _init_$lambda$0(JsonWebSocket this$0, Listener $listener, WebSocket webSocket, Throwable error) {
        if (error != null) {
            Utils.INSTANCE.log("WebSocket connection failed");
            this$0.innerWebSocket = webSocket;
            this$0.close();
            $listener.onError(error);
        } else if (!Intrinsics.areEqual((Object)webSocket, (Object)this$0.innerWebSocket)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ KSerializer access$getIncomingSerializer$p(JsonWebSocket $this) {
        return $this.incomingSerializer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0007\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u000f\u0010\u0004\u001a\u00020\u0003H&\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH&\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00028\u0001H&\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013\u00c0\u0006\u0003"}, d2={"Lai/decart/oasis/JsonWebSocket$Listener;", "T", "", "", "onOpen", "()V", "", "status", "", "reason", "onClose", "(ILjava/lang/String;)V", "", "error", "onError", "(Ljava/lang/Throwable;)V", "message", "onMessage", "(Ljava/lang/Object;)V", "mirage-minecraft-mod_client"})
    @Environment(value=EnvType.CLIENT)
    public static interface Listener<T> {
        public void onOpen();

        public void onClose(int var1, @NotNull String var2);

        public void onError(@NotNull Throwable var1);

        public void onMessage(T var1);
    }
}

