/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.oasis;

import ai.decart.oasis.CreateSessionError;
import ai.decart.oasis.CreateSessionResponse;
import ai.decart.oasis.Graphics;
import ai.decart.oasis.Http;
import ai.decart.oasis.IceCandidate;
import ai.decart.oasis.JsonWebSocket;
import ai.decart.oasis.MirageIncomingAnswerMessage;
import ai.decart.oasis.MirageIncomingErrorMessage;
import ai.decart.oasis.MirageIncomingGenerationStartedMessage;
import ai.decart.oasis.MirageIncomingIceCandidateMessage;
import ai.decart.oasis.MirageIncomingMessage;
import ai.decart.oasis.MirageIncomingPromptAckMessage;
import ai.decart.oasis.MirageIncomingSessionIdMessage;
import ai.decart.oasis.MirageOutgoingIceCandidateMessage;
import ai.decart.oasis.MirageOutgoingMessage;
import ai.decart.oasis.MirageOutgoingOfferMessage;
import ai.decart.oasis.MirageOutgoingPromptMessage;
import ai.decart.oasis.OasisClient;
import ai.decart.oasis.SessionConfig;
import ai.decart.oasis.Utils;
import ai.decart.oasis.WebRTC;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.onvoid.webrtc.CreateSessionDescriptionObserver;
import dev.onvoid.webrtc.PeerConnectionObserver;
import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCOfferOptions;
import dev.onvoid.webrtc.RTCPeerConnection;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpEncodingParameters;
import dev.onvoid.webrtc.RTCRtpSendParameters;
import dev.onvoid.webrtc.RTCRtpSender;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCRtpTransceiverInit;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.RTCStats;
import dev.onvoid.webrtc.RTCStatsReport;
import dev.onvoid.webrtc.RTCStatsType;
import dev.onvoid.webrtc.SetSessionDescriptionObserver;
import dev.onvoid.webrtc.media.FourCC;
import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.video.CustomVideoSource;
import dev.onvoid.webrtc.media.video.I420Buffer;
import dev.onvoid.webrtc.media.video.NativeI420Buffer;
import dev.onvoid.webrtc.media.video.VideoBufferConverter;
import dev.onvoid.webrtc.media.video.VideoFrame;
import dev.onvoid.webrtc.media.video.VideoFrameBuffer;
import dev.onvoid.webrtc.media.video.VideoTrack;
import dev.onvoid.webrtc.media.video.VideoTrackSource;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7417;
import net.minecraft.class_7471;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0003J#\u0010\u001c\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u0015\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010\u0003J\r\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\u0003J\u0019\u0010$\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010\u0003R\u0014\u0010(\u001a\u00020'8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010)R\"\u0010*\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b*\u0010\u0016\"\u0004\b,\u0010-R\"\u0010.\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010+\u001a\u0004\b.\u0010\u0016\"\u0004\b/\u0010-R\"\u00100\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010+\u001a\u0004\b1\u0010\u0016\"\u0004\b2\u0010-R\"\u00103\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010+\u001a\u0004\b4\u0010\u0016\"\u0004\b5\u0010-R\"\u00106\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010+\u001a\u0004\b7\u0010\u0016\"\u0004\b8\u0010-R$\u0010:\u001a\u0004\u0018\u0001098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R4\u0010B\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0A0@8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR*\u0010I\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR$\u0010P\u001a\u0004\u0018\u00010O8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bP\u0010Q\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR$\u0010W\u001a\u0004\u0018\u00010V8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R$\u0010^\u001a\u0004\u0018\u00010]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b^\u0010_\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR$\u0010e\u001a\u0004\u0018\u00010d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\"\u0010l\u001a\u00020k8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bl\u0010m\u001a\u0004\bn\u0010o\"\u0004\bp\u0010qR\"\u0010r\u001a\u00020k8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\br\u0010m\u001a\u0004\bs\u0010o\"\u0004\bt\u0010qR*\u0010w\u001a\n v*\u0004\u0018\u00010u0u8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010x\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R$\u0010}\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0004\b}\u0010)\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R'\u0010\u0082\u0001\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0005\b\u0082\u0001\u0010)\u001a\u0005\b\u0083\u0001\u0010\u007f\"\u0006\b\u0084\u0001\u0010\u0081\u0001R'\u0010\u0085\u0001\u001a\u00020'8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0005\b\u0085\u0001\u0010)\u001a\u0005\b\u0086\u0001\u0010\u007f\"\u0006\b\u0087\u0001\u0010\u0081\u0001R*\u0010\u0089\u0001\u001a\u00030\u0088\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0089\u0001\u0010\u008a\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001\"\u0006\b\u008d\u0001\u0010\u008e\u0001R*\u0010\u008f\u0001\u001a\u00030\u0088\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u008f\u0001\u0010\u008a\u0001\u001a\u0006\b\u0090\u0001\u0010\u008c\u0001\"\u0006\b\u0091\u0001\u0010\u008e\u0001R&\u0010\u0092\u0001\u001a\u00020k8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0092\u0001\u0010m\u001a\u0005\b\u0093\u0001\u0010o\"\u0005\b\u0094\u0001\u0010qR(\u0010\u0095\u0001\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0017\n\u0006\b\u0095\u0001\u0010\u0096\u0001\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001\"\u0005\b\u0099\u0001\u0010%\u00a8\u0006\u009a\u0001"}, d2={"Lai/decart/oasis/OasisClient;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lnet/minecraft/class_2561;", "message", "onReceivedChatMessage", "(Lnet/minecraft/class_2561;)V", "", "prompt", "", "enhance", "sendPrompt", "(Ljava/lang/String;Z)V", "afterRenderWorld", "Lnet/minecraft/class_332;", "drawContext", "beforeInGameHudRender", "(Lnet/minecraft/class_332;)V", "shouldRenderClouds", "()Z", "sendInputFrame", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "context", "apiKey", "onStartCommand", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)V", "connectToWebSocketServer", "Lai/decart/oasis/MirageIncomingMessage;", "handleMessage", "(Lai/decart/oasis/MirageIncomingMessage;)V", "sendOffer", "setupPeerConnection", "onUnexpectedError", "(Ljava/lang/String;)V", "stop", "", "INITIAL_CONNECT_TIMEOUT_MS", "J", "isRunning", "Z", "setRunning", "(Z)V", "isConnected", "setConnected", "hasReceivedFrameBack", "getHasReceivedFrameBack", "setHasReceivedFrameBack", "modelIsPrimaryView", "getModelIsPrimaryView", "setModelIsPrimaryView", "showModelOutput", "getShowModelOutput", "setShowModelOutput", "Lai/decart/oasis/SessionConfig;", "currentConfig", "Lai/decart/oasis/SessionConfig;", "getCurrentConfig", "()Lai/decart/oasis/SessionConfig;", "setCurrentConfig", "(Lai/decart/oasis/SessionConfig;)V", "", "", "currentRecommendedPrompts", "Ljava/util/List;", "getCurrentRecommendedPrompts", "()Ljava/util/List;", "setCurrentRecommendedPrompts", "(Ljava/util/List;)V", "Lai/decart/oasis/JsonWebSocket;", "webSocket", "Lai/decart/oasis/JsonWebSocket;", "getWebSocket", "()Lai/decart/oasis/JsonWebSocket;", "setWebSocket", "(Lai/decart/oasis/JsonWebSocket;)V", "Ldev/onvoid/webrtc/RTCPeerConnection;", "peerConnection", "Ldev/onvoid/webrtc/RTCPeerConnection;", "getPeerConnection", "()Ldev/onvoid/webrtc/RTCPeerConnection;", "setPeerConnection", "(Ldev/onvoid/webrtc/RTCPeerConnection;)V", "Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "videoSource", "Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "getVideoSource", "()Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "setVideoSource", "(Ldev/onvoid/webrtc/media/video/CustomVideoSource;)V", "Lai/decart/oasis/Graphics$WindowDownloader;", "windowDownloader", "Lai/decart/oasis/Graphics$WindowDownloader;", "getWindowDownloader", "()Lai/decart/oasis/Graphics$WindowDownloader;", "setWindowDownloader", "(Lai/decart/oasis/Graphics$WindowDownloader;)V", "Lai/decart/oasis/Graphics$WindowUploader;", "windowUploader", "Lai/decart/oasis/Graphics$WindowUploader;", "getWindowUploader", "()Lai/decart/oasis/Graphics$WindowUploader;", "setWindowUploader", "(Lai/decart/oasis/Graphics$WindowUploader;)V", "", "currentOutputWidth", "I", "getCurrentOutputWidth", "()I", "setCurrentOutputWidth", "(I)V", "currentOutputHeight", "getCurrentOutputHeight", "setCurrentOutputHeight", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "currentOutputFrameRGBA", "Ljava/nio/ByteBuffer;", "getCurrentOutputFrameRGBA", "()Ljava/nio/ByteBuffer;", "setCurrentOutputFrameRGBA", "(Ljava/nio/ByteBuffer;)V", "connectionTimeoutTimeMs", "getConnectionTimeoutTimeMs", "()J", "setConnectionTimeoutTimeMs", "(J)V", "lastFrameTimeMs", "getLastFrameTimeMs", "setLastFrameTimeMs", "lastStatsTimeMs", "getLastStatsTimeMs", "setLastStatsTimeMs", "", "currentSendFPS", "D", "getCurrentSendFPS", "()D", "setCurrentSendFPS", "(D)V", "currentReceiveFPS", "getCurrentReceiveFPS", "setCurrentReceiveFPS", "currentPromptIndex", "getCurrentPromptIndex", "setCurrentPromptIndex", "currentPrompt", "Ljava/lang/String;", "getCurrentPrompt", "()Ljava/lang/String;", "setCurrentPrompt", "mirage-minecraft-mod_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nOasisClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OasisClient.kt\nai/decart/oasis/OasisClient\n+ 2 JsonWebSocket.kt\nai/decart/oasis/JsonWebSocket\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 JsonWebSocket.kt\nai/decart/oasis/JsonWebSocketKt\n*L\n1#1,640:1\n92#2:641\n93#2,3:643\n205#3:642\n104#4:646\n*S KotlinDebug\n*F\n+ 1 OasisClient.kt\nai/decart/oasis/OasisClient\n*L\n272#1:641\n272#1:643,3\n272#1:642\n439#1:646\n*E\n"})
public final class OasisClient
implements ClientModInitializer {
    @NotNull
    public static final OasisClient INSTANCE = new OasisClient();
    public static final long INITIAL_CONNECT_TIMEOUT_MS = 10000L;
    private static boolean isRunning;
    private static boolean isConnected;
    private static boolean hasReceivedFrameBack;
    private static boolean modelIsPrimaryView;
    private static boolean showModelOutput;
    @Nullable
    private static SessionConfig currentConfig;
    @NotNull
    private static List<? extends Map.Entry<String, String>> currentRecommendedPrompts;
    @Nullable
    private static JsonWebSocket<MirageIncomingMessage> webSocket;
    @Nullable
    private static RTCPeerConnection peerConnection;
    @Nullable
    private static CustomVideoSource videoSource;
    @Nullable
    private static Graphics.WindowDownloader windowDownloader;
    @Nullable
    private static Graphics.WindowUploader windowUploader;
    private static int currentOutputWidth;
    private static int currentOutputHeight;
    private static ByteBuffer currentOutputFrameRGBA;
    private static long connectionTimeoutTimeMs;
    private static long lastFrameTimeMs;
    private static long lastStatsTimeMs;
    private static double currentSendFPS;
    private static double currentReceiveFPS;
    private static int currentPromptIndex;
    @NotNull
    private static String currentPrompt;

    private OasisClient() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    public final boolean isConnected() {
        return isConnected;
    }

    public final void setConnected(boolean bl) {
        isConnected = bl;
    }

    public final boolean getHasReceivedFrameBack() {
        return hasReceivedFrameBack;
    }

    public final void setHasReceivedFrameBack(boolean bl) {
        hasReceivedFrameBack = bl;
    }

    public final boolean getModelIsPrimaryView() {
        return modelIsPrimaryView;
    }

    public final void setModelIsPrimaryView(boolean bl) {
        modelIsPrimaryView = bl;
    }

    public final boolean getShowModelOutput() {
        return showModelOutput;
    }

    public final void setShowModelOutput(boolean bl) {
        showModelOutput = bl;
    }

    @Nullable
    public final SessionConfig getCurrentConfig() {
        return currentConfig;
    }

    public final void setCurrentConfig(@Nullable SessionConfig sessionConfig) {
        currentConfig = sessionConfig;
    }

    @NotNull
    public final List<Map.Entry<String, String>> getCurrentRecommendedPrompts() {
        return currentRecommendedPrompts;
    }

    public final void setCurrentRecommendedPrompts(@NotNull List<? extends Map.Entry<String, String>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        currentRecommendedPrompts = list;
    }

    @Nullable
    public final JsonWebSocket<MirageIncomingMessage> getWebSocket() {
        return webSocket;
    }

    public final void setWebSocket(@Nullable JsonWebSocket<MirageIncomingMessage> jsonWebSocket) {
        webSocket = jsonWebSocket;
    }

    @Nullable
    public final RTCPeerConnection getPeerConnection() {
        return peerConnection;
    }

    public final void setPeerConnection(@Nullable RTCPeerConnection rTCPeerConnection) {
        peerConnection = rTCPeerConnection;
    }

    @Nullable
    public final CustomVideoSource getVideoSource() {
        return videoSource;
    }

    public final void setVideoSource(@Nullable CustomVideoSource customVideoSource) {
        videoSource = customVideoSource;
    }

    @Nullable
    public final Graphics.WindowDownloader getWindowDownloader() {
        return windowDownloader;
    }

    public final void setWindowDownloader(@Nullable Graphics.WindowDownloader windowDownloader) {
        OasisClient.windowDownloader = windowDownloader;
    }

    @Nullable
    public final Graphics.WindowUploader getWindowUploader() {
        return windowUploader;
    }

    public final void setWindowUploader(@Nullable Graphics.WindowUploader windowUploader) {
        OasisClient.windowUploader = windowUploader;
    }

    public final int getCurrentOutputWidth() {
        return currentOutputWidth;
    }

    public final void setCurrentOutputWidth(int n) {
        currentOutputWidth = n;
    }

    public final int getCurrentOutputHeight() {
        return currentOutputHeight;
    }

    public final void setCurrentOutputHeight(int n) {
        currentOutputHeight = n;
    }

    public final ByteBuffer getCurrentOutputFrameRGBA() {
        return currentOutputFrameRGBA;
    }

    public final void setCurrentOutputFrameRGBA(ByteBuffer byteBuffer) {
        currentOutputFrameRGBA = byteBuffer;
    }

    public final long getConnectionTimeoutTimeMs() {
        return connectionTimeoutTimeMs;
    }

    public final void setConnectionTimeoutTimeMs(long l) {
        connectionTimeoutTimeMs = l;
    }

    public final long getLastFrameTimeMs() {
        return lastFrameTimeMs;
    }

    public final void setLastFrameTimeMs(long l) {
        lastFrameTimeMs = l;
    }

    public final long getLastStatsTimeMs() {
        return lastStatsTimeMs;
    }

    public final void setLastStatsTimeMs(long l) {
        lastStatsTimeMs = l;
    }

    public final double getCurrentSendFPS() {
        return currentSendFPS;
    }

    public final void setCurrentSendFPS(double d) {
        currentSendFPS = d;
    }

    public final double getCurrentReceiveFPS() {
        return currentReceiveFPS;
    }

    public final void setCurrentReceiveFPS(double d) {
        currentReceiveFPS = d;
    }

    public final int getCurrentPromptIndex() {
        return currentPromptIndex;
    }

    public final void setCurrentPromptIndex(int n) {
        currentPromptIndex = n;
    }

    @NotNull
    public final String getCurrentPrompt() {
        return currentPrompt;
    }

    public final void setCurrentPrompt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        currentPrompt = string;
    }

    public void onInitializeClient() {
        Utils.INSTANCE.log("onInitializeClient");
        ClientLifecycleEvents.CLIENT_STARTED.register(OasisClient::onInitializeClient$lambda$0);
        ClientLifecycleEvents.CLIENT_STOPPING.register(OasisClient::onInitializeClient$lambda$1);
        ServerLifecycleEvents.SERVER_STOPPING.register(OasisClient::onInitializeClient$lambda$2);
        ClientReceiveMessageEvents.CHAT.register(OasisClient::onInitializeClient$lambda$3);
        class_304 keyNextPrompt = Utils.INSTANCE.registerKeyBinding("Switch to the next prompt", 93);
        class_304 keyPreviousPrompt = Utils.INSTANCE.registerKeyBinding("Switch to the previous prompt", 91);
        class_304 keyToggleModel = Utils.INSTANCE.registerKeyBinding("Toggle AI/normal view", 86);
        class_304 keyPeekModel = Utils.INSTANCE.registerKeyBinding("Peek AI/normal view", 82);
        ClientTickEvents.END_CLIENT_TICK.register(arg_0 -> OasisClient.onInitializeClient$lambda$4(keyNextPrompt, keyPreviousPrompt, keyToggleModel, keyPeekModel, arg_0));
        LiteralArgumentBuilder oasisCommand = ClientCommandManager.literal((String)"oasis");
        ClientCommandRegistrationCallback.EVENT.register((arg_0, arg_1) -> OasisClient.onInitializeClient$lambda$5(oasisCommand, arg_0, arg_1));
        LiteralArgumentBuilder oasisStatusCommand = ClientCommandManager.literal((String)"status");
        oasisStatusCommand.executes(OasisClient::onInitializeClient$lambda$6);
        oasisCommand.then((ArgumentBuilder)oasisStatusCommand);
        LiteralArgumentBuilder oasisStartCommand = ClientCommandManager.literal((String)"start");
        LiteralArgumentBuilder cfr_ignored_0 = (LiteralArgumentBuilder)oasisStartCommand.executes(OasisClient::onInitializeClient$lambda$7);
        oasisCommand.then((ArgumentBuilder)oasisStartCommand);
        LiteralArgumentBuilder oasisStopCommand = ClientCommandManager.literal((String)"stop");
        oasisStopCommand.executes(OasisClient::onInitializeClient$lambda$9);
        oasisCommand.then((ArgumentBuilder)oasisStopCommand);
        LiteralArgumentBuilder oasisSwitchPromptCommand = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"prompt").then(ClientCommandManager.argument((String)"prompt", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(OasisClient::onInitializeClient$lambda$10));
        oasisCommand.then((ArgumentBuilder)oasisSwitchPromptCommand);
        LiteralArgumentBuilder oasisHelpCommand = ClientCommandManager.literal((String)"help");
        oasisHelpCommand.executes(OasisClient::onInitializeClient$lambda$11);
        oasisCommand.then((ArgumentBuilder)oasisHelpCommand);
    }

    public final void onReceivedChatMessage(@NotNull class_2561 message) {
        String commandPrefix;
        String chatMessage;
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        class_7417 content = message.method_10851();
        if (!(content instanceof class_2588) || !Intrinsics.areEqual((Object)((class_2588)content).method_11022(), (Object)"chat.type.announcement")) {
            return;
        }
        Object[] objectArray = ((class_2588)content).method_11023();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getArgs(...)");
        Object object = ArraysKt.getOrNull((Object[])objectArray, (int)1);
        Object object2 = object instanceof class_2561 ? (class_2561)object : null;
        if ((object2 != null && (object2 = object2.getString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString() : (string = null)) == null) {
            string = "";
        }
        if (!StringsKt.startsWith$default((String)(chatMessage = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)string, (String)" ", null, (int)2, null))).toString()), (String)(commandPrefix = "Oasis$"), (boolean)false, (int)2, null)) {
            return;
        }
        String string2 = chatMessage.substring(commandPrefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String chatCommand = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!isConnected) {
            class_5250 class_52502 = class_2561.method_43470((String)"Not connected yet! Use \"/oasis start\" first.");
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
            Utils.INSTANCE.sendChatMessage((class_2561)class_52502);
            return;
        }
        if (StringsKt.equals((String)chatCommand, (String)"show", (boolean)true)) {
            modelIsPrimaryView = true;
        } else if (StringsKt.equals((String)chatCommand, (String)"hide", (boolean)true)) {
            modelIsPrimaryView = false;
        } else if (StringsKt.equals((String)chatCommand, (String)"toggle", (boolean)true)) {
            modelIsPrimaryView = !modelIsPrimaryView;
        } else if (StringsKt.startsWith$default((String)chatCommand, (String)"prompt", (boolean)false, (int)2, null)) {
            String prompt = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)chatCommand, (CharSequence)"prompt"))).toString();
            if (((CharSequence)prompt).length() == 0) {
                class_5250 class_52503 = class_2561.method_43470((String)"Usage: /say Oasis$prompt <your prompt>");
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
                Utils.INSTANCE.sendChatMessage((class_2561)class_52503);
                return;
            }
            this.sendPrompt(prompt, true);
            currentPrompt = prompt;
        } else {
            class_5250 class_52504 = class_2561.method_43470((String)("Unknown " + Utils.INSTANCE.getModMetadata().getName() + " command. Try one of: show, hide, toggle, prompt."));
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
            Utils.INSTANCE.sendChatMessage((class_2561)class_52504);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendPrompt(@NotNull String prompt, boolean enhance) {
        block2: {
            void this_$iv;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
            if (!isConnected) {
                return;
            }
            JsonWebSocket<MirageIncomingMessage> jsonWebSocket = webSocket;
            if (jsonWebSocket == null) break block2;
            JsonWebSocket<MirageIncomingMessage> jsonWebSocket2 = jsonWebSocket;
            MirageOutgoingPromptMessage message$iv = new MirageOutgoingPromptMessage(prompt, enhance);
            boolean $i$f$sendMessage = false;
            Json json = (Json)Json.Default;
            MirageOutgoingPromptMessage value$iv$iv = message$iv;
            boolean $i$f$encodeToString = false;
            this_$iv$iv.getSerializersModule();
            String rawMessage$iv = this_$iv$iv.encodeToString((SerializationStrategy)MirageOutgoingMessage.Companion.serializer(), (Object)value$iv$iv);
            Utils.INSTANCE.log("Sending WebSocket message: " + rawMessage$iv);
            WebSocket webSocket = this_$iv.getInnerWebSocket();
            if (webSocket != null) {
                webSocket.sendText(rawMessage$iv, true);
            }
        }
    }

    public final void afterRenderWorld() {
        block6: {
            long frameTimeMs = class_156.method_658();
            if (isRunning && !hasReceivedFrameBack && connectionTimeoutTimeMs <= frameTimeMs) {
                class_5250 class_52502 = class_2561.method_43470((String)"Our servers may be at capacity at the moment or something went wrong. Please try again later.").method_27692(class_124.field_1054);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
                Utils.INSTANCE.sendChatMessage((class_2561)class_52502);
                this.stop();
                return;
            }
            if (!isConnected) {
                return;
            }
            SessionConfig sessionConfig = currentConfig;
            Intrinsics.checkNotNull((Object)sessionConfig);
            int n = 1000 * sessionConfig.getFpsDenominator();
            SessionConfig sessionConfig2 = currentConfig;
            Intrinsics.checkNotNull((Object)sessionConfig2);
            int msPerFrame = n / sessionConfig2.getFpsNumerator();
            if (frameTimeMs / (long)msPerFrame != lastFrameTimeMs / (long)msPerFrame) {
                lastFrameTimeMs = frameTimeMs;
                this.sendInputFrame();
            }
            if (frameTimeMs / (long)1000 != lastStatsTimeMs / (long)1000) {
                lastStatsTimeMs = frameTimeMs;
                RTCPeerConnection rTCPeerConnection = peerConnection;
                if (rTCPeerConnection != null) {
                    rTCPeerConnection.getStats(OasisClient::afterRenderWorld$lambda$0);
                }
            }
            if (!hasReceivedFrameBack || !showModelOutput) break block6;
            Graphics.WindowUploader windowUploader = OasisClient.windowUploader;
            if (windowUploader != null) {
                ByteBuffer byteBuffer = currentOutputFrameRGBA;
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"currentOutputFrameRGBA");
                windowUploader.drawImageToWindow(byteBuffer, currentOutputWidth, currentOutputHeight);
            }
        }
    }

    public final void beforeInGameHudRender(@NotNull class_332 drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (!isRunning) {
            return;
        }
        boolean showFps = false;
        double loadingEllipsisHz = 4.0;
        int textXOffset = 5;
        int textYOffset = 8;
        int textYGap = 3;
        int textColor = -1;
        List textLines = new ArrayList();
        String string = Utils.INSTANCE.getModMetadata().getName();
        Collection collection = Utils.INSTANCE.getModMetadata().getAuthors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAuthors(...)");
        class_5250 class_52502 = class_2561.method_43470((String)(string + " by " + ((Person)CollectionsKt.first((Iterable)collection)).getName()));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        textLines.add(class_52502);
        if (isConnected && isRunning && hasReceivedFrameBack) {
            if (showModelOutput) {
                class_5250 class_52503 = class_2561.method_43470((String)("Prompt: \"" + Utils.INSTANCE.shortString(currentPrompt, 50) + "\""));
                Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
                textLines.add(class_52503);
            } else if (!modelIsPrimaryView) {
                class_5250 class_52504 = class_2561.method_43470((String)"Model output hidden, press V to toggle it back on");
                Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
                textLines.add(class_52504);
            }
        } else {
            int seconds = (int)((double)class_156.method_658() * loadingEllipsisHz / (double)1000);
            class_5250 class_52505 = class_2561.method_43470((String)("In queue" + StringsKt.repeat((CharSequence)".", (int)(seconds % 3 + 1))));
            Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
            textLines.add(class_52505);
        }
        Utils.INSTANCE.drawMultilineText(drawContext, textLines, textXOffset, textYOffset, textYGap, textColor);
    }

    public final boolean shouldRenderClouds() {
        return !isRunning || !isConnected || !hasReceivedFrameBack || !showModelOutput;
    }

    public final void sendInputFrame() {
        block0: {
            Graphics.WindowDownloader windowDownloader = OasisClient.windowDownloader;
            if (windowDownloader == null) break block0;
            SessionConfig sessionConfig = currentConfig;
            Intrinsics.checkNotNull((Object)sessionConfig);
            int n = sessionConfig.getInputVideoWidth();
            SessionConfig sessionConfig2 = currentConfig;
            Intrinsics.checkNotNull((Object)sessionConfig2);
            windowDownloader.captureWindow(n, sessionConfig2.getInputVideoHeight(), (Function1<? super ByteBuffer, Unit>)((Function1)OasisClient::sendInputFrame$lambda$0));
        }
    }

    public final void onStartCommand(@NotNull CommandContext<FabricClientCommandSource> context, @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        if (isRunning) {
            class_5250 class_52502 = class_2561.method_43470((String)"Already running").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage(context, (class_2561)class_52502);
            return;
        }
        isRunning = true;
        connectionTimeoutTimeMs = class_156.method_658() + 10000L;
        Map<String, JsonElement> userAgent = Utils.INSTANCE.buildUserAgent(apiKey);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(userAgent, context, null){
            int label;
            final /* synthetic */ Map<String, JsonElement> $userAgent;
            final /* synthetic */ CommandContext<FabricClientCommandSource> $context;
            {
                this.$userAgent = $userAgent;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = Http.INSTANCE.createSession(new JsonObject(this.$userAgent), (Continuation<? super CreateSessionResponse>)((Continuation)this));
                        ** if (v0 != var6_2) goto lbl11
lbl10:
                        // 1 sources

                        return var6_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var3_3 = (CreateSessionResponse)v0;
                        }
                        catch (Exception error) {
                            Utils.INSTANCE.exception("Error creating session", error);
                            v1 = class_2561.method_43470((String)"Error contacting the server, please try again later.").method_27692(class_124.field_1061);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"formatted(...)");
                            Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v1);
                            OasisClient.INSTANCE.stop();
                            return Unit.INSTANCE;
                        }
                        config = var3_3;
                        Utils.INSTANCE.log("Config: " + config);
                        var3_3 = config;
                        if (var3_3 instanceof CreateSessionError) {
                            for (String errorMessage : ((CreateSessionError)config).getErrorMessages()) {
                                v2 = class_2561.method_43470((String)errorMessage).method_27692(class_124.field_1061);
                                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"formatted(...)");
                                Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v2);
                            }
                            OasisClient.INSTANCE.stop();
                            return Unit.INSTANCE;
                        }
                        if (!(var3_3 instanceof SessionConfig)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        Utils.INSTANCE.log("Session ID: " + ((SessionConfig)config).getSessionId());
                        OasisClient.INSTANCE.setCurrentConfig((SessionConfig)config);
                        OasisClient.INSTANCE.setCurrentRecommendedPrompts(CollectionsKt.toList((Iterable)(((SessionConfig)config).getRecommendedPrompts().isEmpty() != false ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"", (Object)"")) : (Map)((SessionConfig)config).getRecommendedPrompts()).entrySet()));
                        class_310.method_1551().execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(ai.decart.oasis.CreateSessionResponse ), ()V)((CreateSessionResponse)config));
                        OasisClient.INSTANCE.setConnectionTimeoutTimeMs(class_156.method_658() + ((SessionConfig)config).getTotalConnectTimeoutMs());
                        OasisClient.INSTANCE.setCurrentPromptIndex(0);
                        OasisClient.INSTANCE.setCurrentPrompt(OasisClient.INSTANCE.getCurrentRecommendedPrompts().get(OasisClient.INSTANCE.getCurrentPromptIndex()).getKey());
                        v3 = class_2561.method_43470((String)("Starting with prompt: \"" + Utils.INSTANCE.shortString(OasisClient.INSTANCE.getCurrentPrompt(), 50) + "\"")).method_27692(class_124.field_1060);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"formatted(...)");
                        Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v3);
                        v4 = class_2561.method_43470((String)"Starting your session timer now. When the session ends, you can use \"/oasis start\" again to restart the session.").method_27692(class_124.field_1060);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"formatted(...)");
                        Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v4);
                        v5 = class_2561.method_43470((String)("Try using \"/oasis help\" to learn how to use " + Utils.INSTANCE.getModMetadata().getName() + "!")).method_27692(class_124.field_1060);
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"formatted(...)");
                        Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v5);
                        for (String chatMessage : ((SessionConfig)config).getChatMessages()) {
                            v6 = class_2561.method_43470((String)chatMessage).method_27692(class_124.field_1054);
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"formatted(...)");
                            Utils.INSTANCE.sendChatMessage(this.$context, (class_2561)v6);
                        }
                        OasisClient.INSTANCE.connectToWebSocketServer();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(CreateSessionResponse $config) {
                Utils.INSTANCE.log("Creating buffers");
                OasisClient.INSTANCE.setWindowDownloader(new Graphics.WindowDownloader(((SessionConfig)$config).getInputVideoWidth(), ((SessionConfig)$config).getInputVideoHeight()));
                OasisClient.INSTANCE.setWindowUploader(new Graphics.WindowUploader(((SessionConfig)$config).getMaxOutputVideoWidth(), ((SessionConfig)$config).getMaxOutputVideoHeight()));
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void connectToWebSocketServer() {
        void connectTimeout$iv;
        void uri$iv;
        SessionConfig sessionConfig = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig);
        URI uRI = URI.create(sessionConfig.getWebsocketUrl());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        URI uRI2 = uRI;
        SessionConfig sessionConfig2 = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig2);
        Duration duration = Duration.ofMillis(sessionConfig2.getWebsocketConnectTimeoutMs());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        Duration duration2 = duration;
        JsonWebSocket.Listener listener$iv = new JsonWebSocket.Listener<MirageIncomingMessage>(){

            public void onOpen() {
                OasisClient.INSTANCE.setupPeerConnection();
                OasisClient.INSTANCE.sendOffer();
            }

            public void onClose(int status, String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                OasisClient.INSTANCE.onUnexpectedError(OasisClient.INSTANCE.getHasReceivedFrameBack() ? "Lost connection to the server, please try again later" : null);
            }

            public void onError(Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                OasisClient.onUnexpectedError$default(OasisClient.INSTANCE, null, 1, null);
            }

            public void onMessage(MirageIncomingMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OasisClient.INSTANCE.handleMessage(message);
            }
        };
        boolean $i$f$JsonWebSocket = false;
        webSocket = new JsonWebSocket<MirageIncomingMessage>(MirageIncomingMessage.Companion.serializer(), (URI)uri$iv, (Duration)connectTimeout$iv, listener$iv);
    }

    public final void handleMessage(@NotNull MirageIncomingMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MirageIncomingMessage mirageIncomingMessage = message;
        if (mirageIncomingMessage instanceof MirageIncomingIceCandidateMessage) {
            Utils.INSTANCE.log("Received ice-candidate message, adding candidate");
            RTCPeerConnection rTCPeerConnection = peerConnection;
            if (rTCPeerConnection != null) {
                rTCPeerConnection.addIceCandidate(new RTCIceCandidate(((MirageIncomingIceCandidateMessage)message).getCandidate().getSdpMid(), ((MirageIncomingIceCandidateMessage)message).getCandidate().getSdpMLineIndex(), ((MirageIncomingIceCandidateMessage)message).getCandidate().getCandidate()));
            }
        } else if (mirageIncomingMessage instanceof MirageIncomingAnswerMessage) {
            Utils.INSTANCE.log("Received answer message, setting remote description");
            RTCPeerConnection rTCPeerConnection = peerConnection;
            if (rTCPeerConnection != null) {
                rTCPeerConnection.setRemoteDescription(new RTCSessionDescription(RTCSdpType.ANSWER, ((MirageIncomingAnswerMessage)message).getSdp()), new SetSessionDescriptionObserver(){

                    public void onSuccess() {
                        Utils.INSTANCE.log("Set remote description");
                    }

                    public void onFailure(String error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        Utils.INSTANCE.log("Failed to set remote description: " + error);
                        OasisClient.onUnexpectedError$default(OasisClient.INSTANCE, null, 1, null);
                    }
                });
            }
        } else if (mirageIncomingMessage instanceof MirageIncomingErrorMessage) {
            Utils.INSTANCE.log("Received error message: " + ((MirageIncomingErrorMessage)message).getError());
            this.onUnexpectedError(Intrinsics.areEqual((Object)((MirageIncomingErrorMessage)message).getError(), (Object)"401: Invalid API key") ? "Invalid API key" : null);
        } else if (!(mirageIncomingMessage instanceof MirageIncomingSessionIdMessage || mirageIncomingMessage instanceof MirageIncomingPromptAckMessage || mirageIncomingMessage instanceof MirageIncomingGenerationStartedMessage)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void sendOffer() {
        block0: {
            Utils.INSTANCE.log("Sending offer");
            RTCPeerConnection rTCPeerConnection = peerConnection;
            if (rTCPeerConnection == null) break block0;
            rTCPeerConnection.createOffer(new RTCOfferOptions(), new CreateSessionDescriptionObserver(){

                public void onSuccess(RTCSessionDescription description) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                        Utils.INSTANCE.log("Created offer: " + description);
                        RTCPeerConnection rTCPeerConnection = OasisClient.INSTANCE.getPeerConnection();
                        if (rTCPeerConnection == null) break block0;
                        rTCPeerConnection.setLocalDescription(description, new SetSessionDescriptionObserver(description){
                            final /* synthetic */ RTCSessionDescription $description;
                            {
                                this.$description = $description;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void onSuccess() {
                                block1: {
                                    void this_$iv;
                                    void this_$iv$iv;
                                    Utils.INSTANCE.log("Set local description");
                                    JsonWebSocket<MirageIncomingMessage> jsonWebSocket = OasisClient.INSTANCE.getWebSocket();
                                    if (jsonWebSocket == null) break block1;
                                    JsonWebSocket<MirageIncomingMessage> jsonWebSocket2 = jsonWebSocket;
                                    String string = this.$description.sdp;
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdp");
                                    MirageOutgoingOfferMessage message$iv = new MirageOutgoingOfferMessage(string);
                                    boolean $i$f$sendMessage = false;
                                    Json json = (Json)Json.Default;
                                    MirageOutgoingOfferMessage value$iv$iv = message$iv;
                                    boolean $i$f$encodeToString = false;
                                    this_$iv$iv.getSerializersModule();
                                    String rawMessage$iv = this_$iv$iv.encodeToString((SerializationStrategy)MirageOutgoingMessage.Companion.serializer(), (Object)value$iv$iv);
                                    Utils.INSTANCE.log("Sending WebSocket message: " + rawMessage$iv);
                                    WebSocket webSocket = this_$iv.getInnerWebSocket();
                                    if (webSocket != null) {
                                        webSocket.sendText(rawMessage$iv, true);
                                    }
                                }
                            }

                            public void onFailure(String error) {
                                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                Utils.INSTANCE.log("Failed to set local description: " + error);
                                OasisClient.onUnexpectedError$default(OasisClient.INSTANCE, null, 1, null);
                            }
                        });
                    }
                }

                public void onFailure(String error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    Utils.INSTANCE.log("Failed to create offer: " + error);
                    OasisClient.onUnexpectedError$default(OasisClient.INSTANCE, null, 1, null);
                }
            });
        }
    }

    public final void setupPeerConnection() {
        Utils.INSTANCE.log("Setting up peer connection");
        peerConnection = WebRTC.INSTANCE.createPeerConnection(new PeerConnectionObserver(){

            public void onConnectionChange(RTCPeerConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                switch (setupPeerConnection.WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                    case 1: {
                        OasisClient.INSTANCE.setConnected(true);
                        OasisClient.INSTANCE.sendPrompt(OasisClient.INSTANCE.getCurrentRecommendedPrompts().get(OasisClient.INSTANCE.getCurrentPromptIndex()).getValue(), false);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        OasisClient.onUnexpectedError$default(OasisClient.INSTANCE, null, 1, null);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public void onIceCandidate(RTCIceCandidate candidate) {
                block1: {
                    void this_$iv;
                    void this_$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                    JsonWebSocket<MirageIncomingMessage> jsonWebSocket = OasisClient.INSTANCE.getWebSocket();
                    if (jsonWebSocket == null) break block1;
                    JsonWebSocket<MirageIncomingMessage> jsonWebSocket2 = jsonWebSocket;
                    String string = candidate.sdp;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdp");
                    String string2 = candidate.sdpMid;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdpMid");
                    MirageOutgoingIceCandidateMessage message$iv = new MirageOutgoingIceCandidateMessage(new IceCandidate(string, string2, candidate.sdpMLineIndex));
                    boolean $i$f$sendMessage = false;
                    Json json = (Json)Json.Default;
                    MirageOutgoingIceCandidateMessage value$iv$iv = message$iv;
                    boolean $i$f$encodeToString = false;
                    this_$iv$iv.getSerializersModule();
                    String rawMessage$iv = this_$iv$iv.encodeToString((SerializationStrategy)MirageOutgoingMessage.Companion.serializer(), (Object)value$iv$iv);
                    Utils.INSTANCE.log("Sending WebSocket message: " + rawMessage$iv);
                    WebSocket webSocket = this_$iv.getInnerWebSocket();
                    if (webSocket != null) {
                        webSocket.sendText(rawMessage$iv, true);
                    }
                }
            }

            public void onTrack(RTCRtpTransceiver transceiver) {
                Intrinsics.checkNotNullParameter((Object)transceiver, (String)"transceiver");
                MediaStreamTrack incomingTrack = transceiver.getReceiver().getTrack();
                if (!(incomingTrack instanceof VideoTrack)) {
                    return;
                }
                Ref.ObjectRef nextOutputFrameRGBA = new Ref.ObjectRef();
                nextOutputFrameRGBA.element = ByteBuffer.allocate(OasisClient.INSTANCE.getCurrentOutputWidth() * OasisClient.INSTANCE.getCurrentOutputHeight() * 4);
                ((VideoTrack)incomingTrack).addSink(arg_0 -> setupPeerConnection.1.onTrack$lambda$0(nextOutputFrameRGBA, arg_0));
            }

            private static final void onTrack$lambda$0(Ref.ObjectRef $nextOutputFrameRGBA, VideoFrame frame) {
                if (OasisClient.INSTANCE.getCurrentOutputWidth() != frame.buffer.getWidth() || OasisClient.INSTANCE.getCurrentOutputHeight() != frame.buffer.getHeight() || ((ByteBuffer)$nextOutputFrameRGBA.element).capacity() != OasisClient.INSTANCE.getCurrentOutputWidth() * OasisClient.INSTANCE.getCurrentOutputHeight() * 4) {
                    OasisClient.INSTANCE.setCurrentOutputWidth(frame.buffer.getWidth());
                    OasisClient.INSTANCE.setCurrentOutputHeight(frame.buffer.getHeight());
                    Utils.INSTANCE.log("Resizing buffer to " + OasisClient.INSTANCE.getCurrentOutputWidth() + "x" + OasisClient.INSTANCE.getCurrentOutputHeight());
                    $nextOutputFrameRGBA.element = ByteBuffer.allocate(OasisClient.INSTANCE.getCurrentOutputWidth() * OasisClient.INSTANCE.getCurrentOutputHeight() * 4);
                }
                try {
                    VideoBufferConverter.convertFromI420((VideoFrameBuffer)frame.buffer, (ByteBuffer)((ByteBuffer)$nextOutputFrameRGBA.element), (FourCC)FourCC.ABGR);
                    Object object = $nextOutputFrameRGBA.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
                    Utils.INSTANCE.flipImageBufferVertically((ByteBuffer)object, OasisClient.INSTANCE.getCurrentOutputWidth(), OasisClient.INSTANCE.getCurrentOutputHeight());
                    ((ByteBuffer)$nextOutputFrameRGBA.element).rewind();
                }
                catch (Exception error) {
                    Utils.INSTANCE.log("Error converting video frame: " + error);
                }
                frame.release();
                if (!OasisClient.INSTANCE.getHasReceivedFrameBack()) {
                    double d = OasisClient.INSTANCE.getCurrentReceiveFPS();
                    SessionConfig sessionConfig = OasisClient.INSTANCE.getCurrentConfig();
                    Intrinsics.checkNotNull((Object)sessionConfig);
                    if (d >= sessionConfig.getFpsStableMinimum()) {
                        OasisClient.INSTANCE.setHasReceivedFrameBack(true);
                        OasisClient.INSTANCE.setModelIsPrimaryView(true);
                    }
                }
                ByteBuffer tmp = (ByteBuffer)$nextOutputFrameRGBA.element;
                $nextOutputFrameRGBA.element = OasisClient.INSTANCE.getCurrentOutputFrameRGBA();
                OasisClient.INSTANCE.setCurrentOutputFrameRGBA(tmp);
            }
        });
        videoSource = new CustomVideoSource();
        VideoTrack videoTrack = WebRTC.INSTANCE.getPeerConnectionFactory().createVideoTrack("videoTrack", (VideoTrackSource)videoSource);
        RTCPeerConnection rTCPeerConnection = peerConnection;
        Intrinsics.checkNotNull((Object)rTCPeerConnection);
        RTCRtpTransceiver transceiver = rTCPeerConnection.addTransceiver((MediaStreamTrack)videoTrack, new RTCRtpTransceiverInit());
        Intrinsics.checkNotNull((Object)transceiver);
        WebRTC.INSTANCE.preferVideoCodec(transceiver, "VP8");
        RTCRtpSender sender = transceiver.getSender();
        RTCRtpSendParameters parameters = sender.getParameters();
        List list = parameters.encodings;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"encodings");
        if (!((Collection)list).isEmpty()) {
            RTCRtpEncodingParameters encoding = (RTCRtpEncodingParameters)parameters.encodings.get(0);
            encoding.minBitrate = 400000;
            encoding.maxBitrate = 2500000;
            sender.setParameters(parameters);
            Utils.INSTANCE.log("Configured VP8 sender bitrate: min=400kbps, max=2.5mbps");
        }
    }

    public final void onUnexpectedError(@Nullable String message) {
        if (isRunning) {
            String string = message;
            if (string == null) {
                string = hasReceivedFrameBack ? "Disconnected due to an unexpected error, please try again later." : "Failed to connect! Our servers may be at capacity at the moment, please try again later.";
            }
            String message2 = string;
            class_124[] class_124Array = new class_124[]{class_124.field_1061, class_124.field_1067};
            class_5250 class_52502 = class_2561.method_43470((String)message2).method_27695(class_124Array);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage((class_2561)class_52502);
            this.stop();
        }
    }

    public static /* synthetic */ void onUnexpectedError$default(OasisClient oasisClient, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        oasisClient.onUnexpectedError(string);
    }

    public final void stop() {
        if (!isRunning) {
            return;
        }
        Utils.INSTANCE.log("Stopping");
        isRunning = false;
        CustomVideoSource customVideoSource = videoSource;
        if (customVideoSource != null) {
            customVideoSource.dispose();
        }
        videoSource = null;
        RTCPeerConnection rTCPeerConnection = peerConnection;
        if (rTCPeerConnection != null) {
            rTCPeerConnection.close();
        }
        peerConnection = null;
        JsonWebSocket<MirageIncomingMessage> jsonWebSocket = webSocket;
        if (jsonWebSocket != null) {
            jsonWebSocket.close();
        }
        webSocket = null;
        class_310.method_1551().execute(OasisClient::stop$lambda$0);
        isConnected = false;
        hasReceivedFrameBack = false;
        modelIsPrimaryView = true;
        showModelOutput = true;
        currentConfig = null;
        currentRecommendedPrompts = CollectionsKt.toList((Iterable)MapsKt.mapOf((Pair)TuplesKt.to((Object)"", (Object)"")).entrySet());
        currentOutputWidth = 0;
        currentOutputHeight = 0;
        currentOutputFrameRGBA = ByteBuffer.allocate(currentOutputWidth * currentOutputHeight * 4);
        connectionTimeoutTimeMs = 0L;
        lastFrameTimeMs = 0L;
        lastStatsTimeMs = 0L;
        currentSendFPS = 0.0;
        currentReceiveFPS = 0.0;
        currentPromptIndex = 0;
        currentPrompt = "";
    }

    private static final void onInitializeClient$lambda$0(class_310 it) {
        Utils.INSTANCE.log("Client started");
        Graphics.INSTANCE.init();
    }

    private static final void onInitializeClient$lambda$1(class_310 it) {
        Utils.INSTANCE.log("Client stopping");
    }

    private static final void onInitializeClient$lambda$2(MinecraftServer it) {
        Utils.INSTANCE.log("Server stopping");
        INSTANCE.stop();
    }

    private static final void onInitializeClient$lambda$3(class_2561 message, class_7471 class_74712, GameProfile gameProfile, class_2556.class_7602 params, Instant receptionTimestamp) {
        Intrinsics.checkNotNull((Object)message);
        INSTANCE.onReceivedChatMessage(message);
    }

    private static final void onInitializeClient$lambda$4(class_304 $keyNextPrompt, class_304 $keyPreviousPrompt, class_304 $keyToggleModel, class_304 $keyPeekModel, class_310 client) {
        int n;
        if (!isConnected) {
            return;
        }
        if ($keyNextPrompt.method_1436()) {
            n = currentPromptIndex;
            currentPromptIndex = n + 1;
            if (currentPromptIndex == currentRecommendedPrompts.size()) {
                currentPromptIndex = 0;
            }
            INSTANCE.sendPrompt(currentRecommendedPrompts.get(currentPromptIndex).getValue(), false);
            currentPrompt = currentRecommendedPrompts.get(currentPromptIndex).getKey();
        }
        if ($keyPreviousPrompt.method_1436()) {
            if (currentPromptIndex == 0) {
                currentPromptIndex = currentRecommendedPrompts.size();
            }
            n = currentPromptIndex;
            currentPromptIndex = n + -1;
            INSTANCE.sendPrompt(currentRecommendedPrompts.get(currentPromptIndex).getValue(), false);
            currentPrompt = currentRecommendedPrompts.get(currentPromptIndex).getKey();
        }
        if ($keyToggleModel.method_1436()) {
            modelIsPrimaryView = !modelIsPrimaryView;
        }
        showModelOutput = modelIsPrimaryView != $keyPeekModel.method_1434();
    }

    private static final void onInitializeClient$lambda$5(LiteralArgumentBuilder $oasisCommand, CommandDispatcher dispatcher, class_7157 registryAccess) {
        dispatcher.register($oasisCommand);
    }

    private static final int onInitializeClient$lambda$6(CommandContext context) {
        String sessionId;
        Intrinsics.checkNotNull((Object)context);
        class_5250 class_52502 = class_2561.method_43470((String)("Minecraft v" + class_155.method_16673().comp_4025()));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)("Mod v" + Utils.INSTANCE.getModMetadata().getVersion().getFriendlyString()));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)("Window size " + Graphics.INSTANCE.getWindowWidth() + " x " + Graphics.INSTANCE.getWindowHeight()));
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52504);
        class_5250 class_52505 = class_2561.method_43470((String)(isRunning ? "Running" : "Stopped")).method_27692(isRunning ? class_124.field_1060 : class_124.field_1061);
        Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52505);
        class_5250 class_52506 = class_2561.method_43470((String)(isConnected ? "Connected" : "Disconnected")).method_27692(isConnected ? class_124.field_1060 : class_124.field_1061);
        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52506);
        SessionConfig sessionConfig = currentConfig;
        String string = sessionId = sessionConfig != null ? sessionConfig.getSessionId() : null;
        if (sessionId != null) {
            class_5250 class_52507 = class_2561.method_43470((String)("Session ID: " + sessionId));
            Intrinsics.checkNotNullExpressionValue((Object)class_52507, (String)"literal(...)");
            Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52507);
        }
        return 1;
    }

    private static final int onInitializeClient$lambda$7(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        INSTANCE.onStartCommand((CommandContext<FabricClientCommandSource>)context, "oasis-trial-key");
        return 1;
    }

    private static final int onInitializeClient$lambda$8(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"API Key");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        INSTANCE.onStartCommand((CommandContext<FabricClientCommandSource>)context, ((Object)StringsKt.trim((CharSequence)string)).toString());
        return 1;
    }

    private static final int onInitializeClient$lambda$9(CommandContext context) {
        if (isRunning) {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52502 = class_2561.method_43470((String)"Stopping").method_27692(class_124.field_1061);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
            INSTANCE.stop();
        } else {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52503 = class_2561.method_43470((String)"Not running").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        }
        return 1;
    }

    private static final int onInitializeClient$lambda$10(CommandContext context) {
        if (isConnected) {
            String string = StringArgumentType.getString((CommandContext)context, (String)"prompt");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            currentPrompt = string;
            INSTANCE.sendPrompt(currentPrompt, true);
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52502 = class_2561.method_43470((String)("Prompt sent: \"" + Utils.INSTANCE.shortString(currentPrompt, 50) + "\"")).method_27692(class_124.field_1060);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
        } else {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52503 = class_2561.method_43470((String)"Not connected yet! Use \"/oasis start\" to start a new session.").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
            Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        }
        return 1;
    }

    private static final int onInitializeClient$lambda$11(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_5250 class_52502 = class_2561.method_43470((String)"Use \"/oasis start\" to turn on the stream.").method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)"Use \"/oasis status\" to see the stream's status.").method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)"Use '[' and ']' to flip through default prompts, and \"/oasis prompt PROMPT\" to use a custom prompt!").method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52504);
        class_5250 class_52505 = class_2561.method_43470((String)("Use R to show/hide " + Utils.INSTANCE.getModMetadata().getName() + ", and V to toggle show/hide!")).method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52505);
        class_5250 class_52506 = class_2561.method_43470((String)"Use \"/oasis stop\" to turn off the stream.").method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"formatted(...)");
        Utils.INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52506);
        return 1;
    }

    private static final void afterRenderWorld$lambda$0(RTCStatsReport report) {
        Map map = report.getStats();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getStats(...)");
        for (Map.Entry entry : map.entrySet()) {
            String id = (String)entry.getKey();
            RTCStats stat = (RTCStats)entry.getValue();
            Double fps = (Double)stat.getAttributes().get("framesPerSecond");
            if (fps == null) continue;
            RTCStatsType rTCStatsType = stat.getType();
            switch (rTCStatsType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rTCStatsType.ordinal()]) {
                case 1: {
                    currentSendFPS = fps;
                    break;
                }
                case 2: {
                    currentReceiveFPS = fps;
                }
            }
        }
    }

    private static final Unit sendInputFrame$lambda$0(ByteBuffer bufferBGRA) {
        Intrinsics.checkNotNullParameter((Object)bufferBGRA, (String)"bufferBGRA");
        if (!isConnected) {
            return Unit.INSTANCE;
        }
        SessionConfig sessionConfig = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig);
        int n = sessionConfig.getInputVideoWidth();
        SessionConfig sessionConfig2 = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig2);
        Utils.INSTANCE.flipImageBufferVertically(bufferBGRA, n, sessionConfig2.getInputVideoHeight());
        bufferBGRA.rewind();
        SessionConfig sessionConfig3 = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig3);
        int n2 = sessionConfig3.getInputVideoWidth();
        SessionConfig sessionConfig4 = currentConfig;
        Intrinsics.checkNotNull((Object)sessionConfig4);
        NativeI420Buffer i420Buffer = NativeI420Buffer.allocate((int)n2, (int)sessionConfig4.getInputVideoHeight());
        VideoBufferConverter.convertToI420((ByteBuffer)bufferBGRA, (I420Buffer)((I420Buffer)i420Buffer), (FourCC)FourCC.ARGB);
        VideoFrame videoFrame = new VideoFrame((VideoFrameBuffer)i420Buffer, System.nanoTime());
        CustomVideoSource customVideoSource = videoSource;
        if (customVideoSource != null) {
            customVideoSource.pushFrame(videoFrame);
        }
        videoFrame.release();
        return Unit.INSTANCE;
    }

    private static final void stop$lambda$0() {
        Utils.INSTANCE.log("Deleting buffers");
        Graphics.WindowDownloader windowDownloader = OasisClient.windowDownloader;
        if (windowDownloader != null) {
            windowDownloader.close();
        }
        OasisClient.windowDownloader = null;
        Graphics.WindowUploader windowUploader = OasisClient.windowUploader;
        if (windowUploader != null) {
            windowUploader.close();
        }
        OasisClient.windowUploader = null;
    }

    static {
        modelIsPrimaryView = true;
        showModelOutput = true;
        currentRecommendedPrompts = CollectionsKt.toList((Iterable)MapsKt.mapOf((Pair)TuplesKt.to((Object)"", (Object)"")).entrySet());
        currentOutputFrameRGBA = ByteBuffer.allocate(currentOutputWidth * currentOutputHeight * 4);
        currentPrompt = "";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RTCStatsType.values().length];
            try {
                nArray[RTCStatsType.OUTBOUND_RTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RTCStatsType.INBOUND_RTP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

