/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.oasis;

import ai.decart.oasis.Graphics;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.brigadier.context.CommandContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ#\u0010\u0013\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u001d\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJC\u0010$\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0017\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0017\u00a2\u0006\u0004\b(\u0010)J%\u0010.\u001a\u00020\u00062\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017\u00a2\u0006\u0004\b.\u0010/J!\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u000202012\u0006\u00100\u001a\u00020\u0004\u00a2\u0006\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00108\u001a\u0002058\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b8\u00107R\u001f\u0010;\u001a\n :*\u0004\u0018\u000109098\u0006\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lai/decart/oasis/Utils;", "", "<init>", "()V", "", "message", "", "log", "(Ljava/lang/String;)V", "", "error", "exception", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "Lnet/minecraft/class_2561;", "formatChatMessage", "(Lnet/minecraft/class_2561;)Lnet/minecraft/class_2561;", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "context", "sendChatMessage", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_2561;)V", "(Lnet/minecraft/class_2561;)V", "description", "", "defaultKeyCode", "Lnet/minecraft/class_304;", "registerKeyBinding", "(Ljava/lang/String;I)Lnet/minecraft/class_304;", "Lnet/minecraft/class_332;", "drawContext", "", "lines", "x", "y", "lineGap", "color", "drawMultilineText", "(Lnet/minecraft/class_332;Ljava/util/List;IIII)V", "string", "maxLength", "shortString", "(Ljava/lang/String;I)Ljava/lang/String;", "Ljava/nio/ByteBuffer;", "buffer", "width", "height", "flipImageBufferVertically", "(Ljava/nio/ByteBuffer;II)V", "apiKey", "", "Lkotlinx/serialization/json/JsonElement;", "buildUserAgent", "(Ljava/lang/String;)Ljava/util/Map;", "", "MOD_PROD_BUILD", "Z", "DEBUG", "Lnet/fabricmc/loader/api/metadata/ModMetadata;", "kotlin.jvm.PlatformType", "modMetadata", "Lnet/fabricmc/loader/api/metadata/ModMetadata;", "getModMetadata", "()Lnet/fabricmc/loader/api/metadata/ModMetadata;", "mirage-minecraft-mod_client"})
@Environment(value=EnvType.CLIENT)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    public static final boolean MOD_PROD_BUILD = true;
    public static final boolean DEBUG = false;
    private static final ModMetadata modMetadata;

    private Utils() {
    }

    public final ModMetadata getModMetadata() {
        return modMetadata;
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public final void exception(@NotNull String message, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
    }

    private final class_2561 formatChatMessage(class_2561 message) {
        class_124[] class_124Array = new class_124[]{class_124.field_1063, class_124.field_1067};
        class_5250 class_52502 = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27695(class_124Array));
        class_124Array = new class_124[]{class_124.field_1075, class_124.field_1067};
        class_5250 class_52503 = class_52502.method_10852((class_2561)class_2561.method_43470((String)modMetadata.getName()).method_27695(class_124Array));
        class_124Array = new class_124[]{class_124.field_1063, class_124.field_1067};
        class_5250 class_52504 = class_52503.method_10852((class_2561)class_2561.method_43470((String)"] ").method_27695(class_124Array)).method_10852(message);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"append(...)");
        return (class_2561)class_52504;
    }

    public final void sendChatMessage(@NotNull CommandContext<FabricClientCommandSource> context, @NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((FabricClientCommandSource)context.getSource()).sendFeedback(this.formatChatMessage(message));
    }

    public final void sendChatMessage(@NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        class_310.method_1551().field_1705.method_1743().method_1812(this.formatChatMessage(message));
    }

    @NotNull
    public final class_304 registerKeyBinding(@NotNull String description, int defaultKeyCode) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        class_304 class_3042 = KeyBindingHelper.registerKeyBinding((class_304)new class_304(description, defaultKeyCode, modMetadata.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)class_3042, (String)"registerKeyBinding(...)");
        return class_3042;
    }

    public final void drawMultilineText(@NotNull class_332 drawContext, @NotNull List<? extends class_2561> lines, int x, int y, int lineGap, int color) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        class_327 textRenderer = class_310.method_1551().field_1772;
        int height = y;
        for (class_2561 class_25612 : lines) {
            int textWidth = textRenderer.method_27525((class_5348)class_25612);
            int textHeight = textRenderer.method_44378((class_5348)class_25612, textWidth);
            drawContext.method_60649(textRenderer, class_25612, x, height, textWidth, color);
            height += lineGap + textHeight;
        }
    }

    @NotNull
    public final String shortString(@NotNull String string, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return string.length() > maxLength ? StringsKt.take((String)string, (int)maxLength) + "..." : string;
    }

    public final void flipImageBufferVertically(@NotNull ByteBuffer buffer, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int rowSize = width * 4;
        byte[] rowBufferTop = new byte[rowSize];
        byte[] rowBufferBottom = new byte[rowSize];
        int n = height / 2;
        for (int y = 0; y < n; ++y) {
            int topOffset = y * rowSize;
            int bottomOffset = (height - y - 1) * rowSize;
            buffer.position(topOffset);
            buffer.get(rowBufferTop);
            buffer.position(bottomOffset);
            buffer.get(rowBufferBottom);
            buffer.position(topOffset);
            buffer.put(rowBufferBottom);
            buffer.position(bottomOffset);
            buffer.put(rowBufferTop);
        }
    }

    @NotNull
    public final Map<String, JsonElement> buildUserAgent(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"javaVersion", (Object)JsonElementKt.JsonPrimitive((String)System.getProperty("java.version"))), TuplesKt.to((Object)"minecraftVersion", (Object)JsonElementKt.JsonPrimitive((String)class_155.method_16673().comp_4025())), TuplesKt.to((Object)"modId", (Object)JsonElementKt.JsonPrimitive((String)modMetadata.getId())), TuplesKt.to((Object)"modVersion", (Object)JsonElementKt.JsonPrimitive((String)modMetadata.getVersion().getFriendlyString())), TuplesKt.to((Object)"osName", (Object)JsonElementKt.JsonPrimitive((String)System.getProperty("os.name"))), TuplesKt.to((Object)"osArch", (Object)JsonElementKt.JsonPrimitive((String)System.getProperty("os.arch"))), TuplesKt.to((Object)"cpu", (Object)JsonElementKt.JsonPrimitive((String)GLX._getCpuInfo())), TuplesKt.to((Object)"gpuRenderer", (Object)JsonElementKt.JsonPrimitive((String)Graphics.INSTANCE.getDevice().getRenderer())), TuplesKt.to((Object)"gpuVendor", (Object)JsonElementKt.JsonPrimitive((String)Graphics.INSTANCE.getDevice().getVendor())), TuplesKt.to((Object)"gpuBackend", (Object)JsonElementKt.JsonPrimitive((String)Graphics.INSTANCE.getDevice().getBackendName())), TuplesKt.to((Object)"gpuVersion", (Object)JsonElementKt.JsonPrimitive((String)Graphics.INSTANCE.getDevice().getVersion())), TuplesKt.to((Object)"apiKey", (Object)JsonElementKt.JsonPrimitive((String)apiKey)), TuplesKt.to((Object)"width", (Object)JsonElementKt.JsonPrimitive((Number)Graphics.INSTANCE.getWindowWidth())), TuplesKt.to((Object)"height", (Object)JsonElementKt.JsonPrimitive((Number)Graphics.INSTANCE.getWindowHeight()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    static {
        Object v0 = FabricLoader.getInstance().getModContainer("mirage-minecraft-mod").orElse(null);
        Intrinsics.checkNotNull(v0);
        modMetadata = ((ModContainer)v0).getMetadata();
    }
}

