/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.oasis;

import ai.decart.oasis.Utils;
import dev.onvoid.webrtc.PeerConnectionFactory;
import dev.onvoid.webrtc.PeerConnectionObserver;
import dev.onvoid.webrtc.RTCConfiguration;
import dev.onvoid.webrtc.RTCDataChannel;
import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCIceConnectionState;
import dev.onvoid.webrtc.RTCIceGatheringState;
import dev.onvoid.webrtc.RTCIceServer;
import dev.onvoid.webrtc.RTCPeerConnection;
import dev.onvoid.webrtc.RTCPeerConnectionIceErrorEvent;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpCapabilities;
import dev.onvoid.webrtc.RTCRtpCodecCapability;
import dev.onvoid.webrtc.RTCRtpReceiver;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCSignalingState;
import dev.onvoid.webrtc.logging.LogSink;
import dev.onvoid.webrtc.logging.Logging;
import dev.onvoid.webrtc.media.MediaStream;
import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0012\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lai/decart/oasis/WebRTC;", "", "<init>", "()V", "", "enableLogging", "Ldev/onvoid/webrtc/PeerConnectionObserver;", "observer", "Ldev/onvoid/webrtc/RTCPeerConnection;", "createPeerConnection", "(Ldev/onvoid/webrtc/PeerConnectionObserver;)Ldev/onvoid/webrtc/RTCPeerConnection;", "Ldev/onvoid/webrtc/RTCRtpTransceiver;", "transceiver", "", "preferredCodecName", "preferVideoCodec", "(Ldev/onvoid/webrtc/RTCRtpTransceiver;Ljava/lang/String;)V", "Ldev/onvoid/webrtc/PeerConnectionFactory;", "peerConnectionFactory", "Ldev/onvoid/webrtc/PeerConnectionFactory;", "getPeerConnectionFactory", "()Ldev/onvoid/webrtc/PeerConnectionFactory;", "mirage-minecraft-mod_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nWebRTC.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebRTC.kt\nai/decart/oasis/WebRTC\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1869#2,2:130\n*S KotlinDebug\n*F\n+ 1 WebRTC.kt\nai/decart/oasis/WebRTC\n*L\n118#1:130,2\n*E\n"})
public final class WebRTC {
    @NotNull
    public static final WebRTC INSTANCE = new WebRTC();
    @NotNull
    private static final PeerConnectionFactory peerConnectionFactory = new PeerConnectionFactory();

    private WebRTC() {
    }

    @NotNull
    public final PeerConnectionFactory getPeerConnectionFactory() {
        return peerConnectionFactory;
    }

    public final void enableLogging() {
        Logging.logToDebug((Logging.Severity)Logging.Severity.INFO);
        Logging.logThreads((boolean)true);
        Logging.logTimestamps((boolean)true);
        Logging.addLogSink((Logging.Severity)Logging.Severity.INFO, (LogSink)new LogSink(){

            public void onLogMessage(Logging.Severity severity, String message) {
                Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                String string = "[WebRTC] [" + severity + "] " + ((Object)StringsKt.trim((CharSequence)message)).toString();
                System.out.println((Object)string);
            }
        });
    }

    @NotNull
    public final RTCPeerConnection createPeerConnection(@NotNull PeerConnectionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        RTCConfiguration config = new RTCConfiguration();
        RTCIceServer iceServer = new RTCIceServer();
        iceServer.urls.add("stun:stun.l.google.com:19302");
        config.iceServers.add(iceServer);
        RTCPeerConnection rTCPeerConnection = peerConnectionFactory.createPeerConnection(config, new PeerConnectionObserver(observer){
            final /* synthetic */ PeerConnectionObserver $observer;
            {
                this.$observer = $observer;
            }

            public void onSignalingChange(RTCSignalingState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Utils.INSTANCE.log("onSignalingChange: " + state);
                this.$observer.onSignalingChange(state);
            }

            public void onConnectionChange(RTCPeerConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Utils.INSTANCE.log("onConnectionChange: " + state);
                this.$observer.onConnectionChange(state);
            }

            public void onIceConnectionChange(RTCIceConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Utils.INSTANCE.log("onIceConnectionChange: " + state);
                this.$observer.onIceConnectionChange(state);
            }

            public void onStandardizedIceConnectionChange(RTCIceConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Utils.INSTANCE.log("onStandardizedIceConnectionChange: " + state);
                this.$observer.onStandardizedIceConnectionChange(state);
            }

            public void onIceConnectionReceivingChange(boolean receiving) {
                Utils.INSTANCE.log("onIceConnectionReceivingChange: " + receiving);
                this.$observer.onIceConnectionReceivingChange(receiving);
            }

            public void onIceGatheringChange(RTCIceGatheringState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Utils.INSTANCE.log("onIceGatheringChange: " + state);
                this.$observer.onIceGatheringChange(state);
            }

            public void onIceCandidate(RTCIceCandidate candidate) {
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                Utils.INSTANCE.log("Received ICE candidate: " + candidate);
                this.$observer.onIceCandidate(candidate);
            }

            public void onIceCandidateError(RTCPeerConnectionIceErrorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Utils.INSTANCE.log("onIceCandidateError: " + event);
                this.$observer.onIceCandidateError(event);
            }

            public void onIceCandidatesRemoved(RTCIceCandidate[] candidates) {
                Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
                Utils.INSTANCE.log("onIceCandidatesRemoved: " + candidates);
                this.$observer.onIceCandidatesRemoved(candidates);
            }

            public void onAddStream(MediaStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                Utils.INSTANCE.log("onAddStream: " + stream);
                this.$observer.onAddStream(stream);
            }

            public void onRemoveStream(MediaStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                Utils.INSTANCE.log("onRemoveStream: " + stream);
                this.$observer.onRemoveStream(stream);
            }

            public void onDataChannel(RTCDataChannel dataChannel) {
                Intrinsics.checkNotNullParameter((Object)dataChannel, (String)"dataChannel");
                Utils.INSTANCE.log("onDataChannel: " + dataChannel);
                this.$observer.onDataChannel(dataChannel);
            }

            public void onRenegotiationNeeded() {
                Utils.INSTANCE.log("onRenegotiationNeeded");
                this.$observer.onRenegotiationNeeded();
            }

            public void onAddTrack(RTCRtpReceiver receiver, MediaStream[] mediaStreams) {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter((Object)mediaStreams, (String)"mediaStreams");
                Utils.INSTANCE.log("onAddTrack: " + receiver + ", " + mediaStreams);
                this.$observer.onAddTrack(receiver, mediaStreams);
            }

            public void onRemoveTrack(RTCRtpReceiver receiver) {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Utils.INSTANCE.log("onRemoveTrack: " + receiver);
                this.$observer.onRemoveTrack(receiver);
            }

            public void onTrack(RTCRtpTransceiver transceiver) {
                Intrinsics.checkNotNullParameter((Object)transceiver, (String)"transceiver");
                MediaStreamTrack mediaStreamTrack = transceiver.getSender().getTrack();
                MediaStreamTrack mediaStreamTrack2 = transceiver.getReceiver().getTrack();
                Utils.INSTANCE.log("onTrack: " + transceiver + ", " + transceiver.getDirection() + ", " + (mediaStreamTrack != null ? mediaStreamTrack.getKind() : null) + ", " + (mediaStreamTrack2 != null ? mediaStreamTrack2.getKind() : null));
                this.$observer.onTrack(transceiver);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)rTCPeerConnection, (String)"createPeerConnection(...)");
        return rTCPeerConnection;
    }

    public final void preferVideoCodec(@NotNull RTCRtpTransceiver transceiver, @NotNull String preferredCodecName) {
        Intrinsics.checkNotNullParameter((Object)transceiver, (String)"transceiver");
        Intrinsics.checkNotNullParameter((Object)preferredCodecName, (String)"preferredCodecName");
        RTCRtpCapabilities capabilities = peerConnectionFactory.getRtpSenderCapabilities(MediaType.VIDEO);
        List preferredCodecs = new ArrayList();
        List otherCodecs = new ArrayList();
        List list = capabilities.getCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCodecs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            RTCRtpCodecCapability codec = (RTCRtpCodecCapability)element$iv;
            boolean bl2 = false;
            String string = codec.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)preferredCodecName, (boolean)true)) {
                Intrinsics.checkNotNull((Object)codec);
                bl = preferredCodecs.add(codec);
                continue;
            }
            Intrinsics.checkNotNull((Object)codec);
            bl = otherCodecs.add(codec);
        }
        transceiver.setCodecPreferences(CollectionsKt.plus((Collection)preferredCodecs, (Iterable)otherCodecs));
    }
}

