/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.mirage;

import ai.decart.mirage.MirageClient;
import ai.decart.mirage.MirageClientKt;
import ai.decart.mirage.SdpTweaker;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.onvoid.webrtc.CreateSessionDescriptionObserver;
import dev.onvoid.webrtc.PeerConnectionFactory;
import dev.onvoid.webrtc.PeerConnectionObserver;
import dev.onvoid.webrtc.RTCConfiguration;
import dev.onvoid.webrtc.RTCDataChannel;
import dev.onvoid.webrtc.RTCIceCandidate;
import dev.onvoid.webrtc.RTCIceConnectionState;
import dev.onvoid.webrtc.RTCIceGatheringState;
import dev.onvoid.webrtc.RTCIceServer;
import dev.onvoid.webrtc.RTCOfferOptions;
import dev.onvoid.webrtc.RTCPeerConnection;
import dev.onvoid.webrtc.RTCPeerConnectionIceErrorEvent;
import dev.onvoid.webrtc.RTCPeerConnectionState;
import dev.onvoid.webrtc.RTCRtpReceiver;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCRtpTransceiverInit;
import dev.onvoid.webrtc.RTCSdpType;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.RTCSignalingState;
import dev.onvoid.webrtc.RTCStats;
import dev.onvoid.webrtc.RTCStatsReport;
import dev.onvoid.webrtc.SetSessionDescriptionObserver;
import dev.onvoid.webrtc.media.FourCC;
import dev.onvoid.webrtc.media.MediaStream;
import dev.onvoid.webrtc.media.MediaStreamTrack;
import dev.onvoid.webrtc.media.video.CustomVideoSource;
import dev.onvoid.webrtc.media.video.I420Buffer;
import dev.onvoid.webrtc.media.video.NativeI420Buffer;
import dev.onvoid.webrtc.media.video.VideoBufferConverter;
import dev.onvoid.webrtc.media.video.VideoFrame;
import dev.onvoid.webrtc.media.video.VideoFrameBuffer;
import dev.onvoid.webrtc.media.video.VideoTrack;
import dev.onvoid.webrtc.media.video.VideoTrackSource;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6367;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0003J\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0003J\r\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0015\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u0003J\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u0003J\r\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u0003J\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u0003J\r\u0010!\u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\u0003J\r\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b\"\u0010\u0003J\u0015\u0010$\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J#\u0010)\u001a\u00020\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u001d\u001a\u00020#\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010)\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020#\u00a2\u0006\u0004\b)\u0010+J%\u0010.\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b.\u0010/J/\u00102\u001a\u00020\u00042\u0006\u00100\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\b\u0002\u00101\u001a\u00020\r\u00a2\u0006\u0004\b2\u00103J%\u00105\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u00104\u001a\u00020,\u00a2\u0006\u0004\b5\u0010/R\u001f\u00108\u001a\n 7*\u0004\u0018\u000106068\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;R\"\u0010<\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b<\u0010>\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010=\u001a\u0004\bA\u0010>\"\u0004\bB\u0010@R\"\u0010D\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\"\u0010J\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010E\u001a\u0004\bK\u0010G\"\u0004\bL\u0010IR$\u0010N\u001a\u0004\u0018\u00010M8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR$\u0010U\u001a\u0004\u0018\u00010T8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010V\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\"\u0010[\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b[\u0010\\\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\"\u0010a\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\ba\u0010\\\u001a\u0004\bb\u0010^\"\u0004\bc\u0010`R$\u0010d\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bd\u0010e\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\"\u0010j\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bj\u0010\\\u001a\u0004\bk\u0010^\"\u0004\bl\u0010`R\"\u0010m\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bm\u0010\\\u001a\u0004\bn\u0010^\"\u0004\bo\u0010`R$\u0010p\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010e\u001a\u0004\bq\u0010g\"\u0004\br\u0010iR$\u0010s\u001a\u0004\u0018\u00010,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bs\u0010e\u001a\u0004\bt\u0010g\"\u0004\bu\u0010iR*\u0010w\u001a\n 7*\u0004\u0018\u00010v0v8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bw\u0010x\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R(\u0010~\u001a\u0004\u0018\u00010}8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0016\n\u0004\b~\u0010\u007f\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001\"\u0006\b\u0082\u0001\u0010\u0083\u0001R,\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0084\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\"\u0006\b\u0089\u0001\u0010\u008a\u0001R&\u0010\u008b\u0001\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u008b\u0001\u0010\\\u001a\u0005\b\u008c\u0001\u0010^\"\u0005\b\u008d\u0001\u0010`R&\u0010\u008e\u0001\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u008e\u0001\u0010=\u001a\u0005\b\u008f\u0001\u0010>\"\u0005\b\u0090\u0001\u0010@R,\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0091\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0092\u0001\u0010\u0093\u0001\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001\"\u0006\b\u0096\u0001\u0010\u0097\u0001R&\u0010\u0098\u0001\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0098\u0001\u0010\\\u001a\u0005\b\u0099\u0001\u0010^\"\u0005\b\u009a\u0001\u0010`R&\u0010\u009b\u0001\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009b\u0001\u0010=\u001a\u0005\b\u009c\u0001\u0010>\"\u0005\b\u009d\u0001\u0010@R&\u0010\u009e\u0001\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u009e\u0001\u0010=\u001a\u0005\b\u009f\u0001\u0010>\"\u0005\b\u00a0\u0001\u0010@R,\u0010\u00a2\u0001\u001a\u0005\u0018\u00010\u00a1\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a2\u0001\u0010\u00a3\u0001\u001a\u0006\b\u00a4\u0001\u0010\u00a5\u0001\"\u0006\b\u00a6\u0001\u0010\u00a7\u0001R,\u0010\u00a9\u0001\u001a\u0005\u0018\u00010\u00a8\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00a9\u0001\u0010\u00aa\u0001\u001a\u0006\b\u00ab\u0001\u0010\u00ac\u0001\"\u0006\b\u00ad\u0001\u0010\u00ae\u0001R)\u0010\u00af\u0001\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00af\u0001\u0010\u00b0\u0001\u001a\u0006\b\u00b1\u0001\u0010\u00b2\u0001\"\u0006\b\u00b3\u0001\u0010\u00b4\u0001R)\u0010\u00b5\u0001\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00b5\u0001\u0010\u00b0\u0001\u001a\u0006\b\u00b6\u0001\u0010\u00b2\u0001\"\u0006\b\u00b7\u0001\u0010\u00b4\u0001R,\u0010\u00b9\u0001\u001a\u0005\u0018\u00010\u00b8\u00018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u00b9\u0001\u0010\u00ba\u0001\u001a\u0006\b\u00bb\u0001\u0010\u00bc\u0001\"\u0006\b\u00bd\u0001\u0010\u00be\u0001R&\u0010\u00bf\u0001\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00bf\u0001\u0010\\\u001a\u0005\b\u00c0\u0001\u0010^\"\u0005\b\u00c1\u0001\u0010`R&\u0010\u00c2\u0001\u001a\u00020C8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u00c2\u0001\u0010E\u001a\u0005\b\u00c3\u0001\u0010G\"\u0005\b\u00c4\u0001\u0010IR\u0016\u0010\u00c5\u0001\u001a\u00020C8\u0006X\u0086T\u00a2\u0006\u0007\n\u0005\b\u00c5\u0001\u0010E\u00a8\u0006\u00c6\u0001"}, d2={"Lai/decart/mirage/MirageClient;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "", "inputPrompt", "", "shouldEnrich", "sendPrompt", "(Ljava/lang/String;Z)V", "constructor", "", "width", "height", "onResized", "(II)V", "close", "afterRenderWorld", "Lnet/minecraft/class_332;", "drawContext", "beforeInGameHudRender", "(Lnet/minecraft/class_332;)V", "sendInputFrame", "start", "startSessionTimer", "connectToWebSocketServer", "", "message", "handleMessage", "(Ljava/lang/CharSequence;)V", "sendOffer", "setupPeerConnection", "stop", "Lnet/minecraft/class_2561;", "formatChatMessage", "(Lnet/minecraft/class_2561;)Lnet/minecraft/class_2561;", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "context", "sendChatMessage", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_2561;)V", "(Lnet/minecraft/class_2561;)V", "Ljava/nio/ByteBuffer;", "bgraBuffer", "sendInputFrameToWebRTC", "(IILjava/nio/ByteBuffer;)V", "buffer", "bytesPerPixel", "flipByteBufferVertically", "(Ljava/nio/ByteBuffer;III)V", "frameBGRA", "uploadOutputFrameToTexture", "Lnet/minecraft/class_310;", "kotlin.jvm.PlatformType", "minecraftClient", "Lnet/minecraft/class_310;", "getMinecraftClient", "()Lnet/minecraft/class_310;", "isRunning", "Z", "()Z", "setRunning", "(Z)V", "isConnected", "setConnected", "", "lastFrameTimeMs", "J", "getLastFrameTimeMs", "()J", "setLastFrameTimeMs", "(J)V", "lastStatsTimeMs", "getLastStatsTimeMs", "setLastStatsTimeMs", "Ldev/onvoid/webrtc/RTCPeerConnection;", "peerConnection", "Ldev/onvoid/webrtc/RTCPeerConnection;", "getPeerConnection", "()Ldev/onvoid/webrtc/RTCPeerConnection;", "setPeerConnection", "(Ldev/onvoid/webrtc/RTCPeerConnection;)V", "Ljava/net/http/WebSocket;", "webSocket", "Ljava/net/http/WebSocket;", "getWebSocket", "()Ljava/net/http/WebSocket;", "setWebSocket", "(Ljava/net/http/WebSocket;)V", "currentOutputWidth", "I", "getCurrentOutputWidth", "()I", "setCurrentOutputWidth", "(I)V", "currentOutputHeight", "getCurrentOutputHeight", "setCurrentOutputHeight", "currentOutputFrameBGRA", "Ljava/nio/ByteBuffer;", "getCurrentOutputFrameBGRA", "()Ljava/nio/ByteBuffer;", "setCurrentOutputFrameBGRA", "(Ljava/nio/ByteBuffer;)V", "inputPboHandle", "getInputPboHandle", "setInputPboHandle", "outputPboHandle", "getOutputPboHandle", "setOutputPboHandle", "oldInputPboBuffer", "getOldInputPboBuffer", "setOldInputPboBuffer", "oldOutputPboBuffer", "getOldOutputPboBuffer", "setOldOutputPboBuffer", "Lnet/minecraft/class_2960;", "outputTextureIdentifier", "Lnet/minecraft/class_2960;", "getOutputTextureIdentifier", "()Lnet/minecraft/class_2960;", "setOutputTextureIdentifier", "(Lnet/minecraft/class_2960;)V", "Lnet/minecraft/class_1044;", "outputTexture", "Lnet/minecraft/class_1044;", "getOutputTexture", "()Lnet/minecraft/class_1044;", "setOutputTexture", "(Lnet/minecraft/class_1044;)V", "Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "videoSource", "Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "getVideoSource", "()Ldev/onvoid/webrtc/media/video/CustomVideoSource;", "setVideoSource", "(Ldev/onvoid/webrtc/media/video/CustomVideoSource;)V", "frameCount", "getFrameCount", "setFrameCount", "hasReceivedFrameBack", "getHasReceivedFrameBack", "setHasReceivedFrameBack", "Ldev/onvoid/webrtc/media/video/VideoTrack;", "videoTrack", "Ldev/onvoid/webrtc/media/video/VideoTrack;", "getVideoTrack", "()Ldev/onvoid/webrtc/media/video/VideoTrack;", "setVideoTrack", "(Ldev/onvoid/webrtc/media/video/VideoTrack;)V", "currentPromptIndex", "getCurrentPromptIndex", "setCurrentPromptIndex", "modelIsPrimaryView", "getModelIsPrimaryView", "setModelIsPrimaryView", "showModelOutput", "getShowModelOutput", "setShowModelOutput", "Ldev/onvoid/webrtc/PeerConnectionFactory;", "factory", "Ldev/onvoid/webrtc/PeerConnectionFactory;", "getFactory", "()Ldev/onvoid/webrtc/PeerConnectionFactory;", "setFactory", "(Ldev/onvoid/webrtc/PeerConnectionFactory;)V", "Ldev/onvoid/webrtc/RTCRtpTransceiver;", "rtcTransceiver", "Ldev/onvoid/webrtc/RTCRtpTransceiver;", "getRtcTransceiver", "()Ldev/onvoid/webrtc/RTCRtpTransceiver;", "setRtcTransceiver", "(Ldev/onvoid/webrtc/RTCRtpTransceiver;)V", "secretKeyword", "Ljava/lang/String;", "getSecretKeyword", "()Ljava/lang/String;", "setSecretKeyword", "(Ljava/lang/String;)V", "currentReceiveFPS", "getCurrentReceiveFPS", "setCurrentReceiveFPS", "Lnet/minecraft/class_6367;", "inputFbo", "Lnet/minecraft/class_6367;", "getInputFbo", "()Lnet/minecraft/class_6367;", "setInputFbo", "(Lnet/minecraft/class_6367;)V", "sessionTime", "getSessionTime", "setSessionTime", "lastSentFrameMs", "getLastSentFrameMs", "setLastSentFrameMs", "FRAME_SEND_INTERVAL_MS", "decart-mirage_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nMirageClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirageClient.kt\nai/decart/mirage/MirageClient\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,873:1\n205#2:874\n*S KotlinDebug\n*F\n+ 1 MirageClient.kt\nai/decart/mirage/MirageClient\n*L\n270#1:874\n*E\n"})
public final class MirageClient
implements ClientModInitializer {
    @NotNull
    public static final MirageClient INSTANCE = new MirageClient();
    private static final class_310 minecraftClient = class_310.method_1551();
    private static boolean isRunning;
    private static boolean isConnected;
    private static long lastFrameTimeMs;
    private static long lastStatsTimeMs;
    @Nullable
    private static RTCPeerConnection peerConnection;
    @Nullable
    private static WebSocket webSocket;
    private static int currentOutputWidth;
    private static int currentOutputHeight;
    @Nullable
    private static ByteBuffer currentOutputFrameBGRA;
    private static int inputPboHandle;
    private static int outputPboHandle;
    @Nullable
    private static ByteBuffer oldInputPboBuffer;
    @Nullable
    private static ByteBuffer oldOutputPboBuffer;
    private static class_2960 outputTextureIdentifier;
    @Nullable
    private static class_1044 outputTexture;
    @Nullable
    private static CustomVideoSource videoSource;
    private static int frameCount;
    private static boolean hasReceivedFrameBack;
    @Nullable
    private static VideoTrack videoTrack;
    private static int currentPromptIndex;
    private static boolean modelIsPrimaryView;
    private static boolean showModelOutput;
    @Nullable
    private static PeerConnectionFactory factory;
    @Nullable
    private static RTCRtpTransceiver rtcTransceiver;
    @NotNull
    private static String secretKeyword;
    @NotNull
    private static String currentReceiveFPS;
    @Nullable
    private static class_6367 inputFbo;
    private static int sessionTime;
    private static long lastSentFrameMs;
    public static final long FRAME_SEND_INTERVAL_MS = 3000L;

    private MirageClient() {
    }

    public final class_310 getMinecraftClient() {
        return minecraftClient;
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    public final boolean isConnected() {
        return isConnected;
    }

    public final void setConnected(boolean bl) {
        isConnected = bl;
    }

    public final long getLastFrameTimeMs() {
        return lastFrameTimeMs;
    }

    public final void setLastFrameTimeMs(long l) {
        lastFrameTimeMs = l;
    }

    public final long getLastStatsTimeMs() {
        return lastStatsTimeMs;
    }

    public final void setLastStatsTimeMs(long l) {
        lastStatsTimeMs = l;
    }

    @Nullable
    public final RTCPeerConnection getPeerConnection() {
        return peerConnection;
    }

    public final void setPeerConnection(@Nullable RTCPeerConnection rTCPeerConnection) {
        peerConnection = rTCPeerConnection;
    }

    @Nullable
    public final WebSocket getWebSocket() {
        return webSocket;
    }

    public final void setWebSocket(@Nullable WebSocket webSocket) {
        MirageClient.webSocket = webSocket;
    }

    public final int getCurrentOutputWidth() {
        return currentOutputWidth;
    }

    public final void setCurrentOutputWidth(int n) {
        currentOutputWidth = n;
    }

    public final int getCurrentOutputHeight() {
        return currentOutputHeight;
    }

    public final void setCurrentOutputHeight(int n) {
        currentOutputHeight = n;
    }

    @Nullable
    public final ByteBuffer getCurrentOutputFrameBGRA() {
        return currentOutputFrameBGRA;
    }

    public final void setCurrentOutputFrameBGRA(@Nullable ByteBuffer byteBuffer) {
        currentOutputFrameBGRA = byteBuffer;
    }

    public final int getInputPboHandle() {
        return inputPboHandle;
    }

    public final void setInputPboHandle(int n) {
        inputPboHandle = n;
    }

    public final int getOutputPboHandle() {
        return outputPboHandle;
    }

    public final void setOutputPboHandle(int n) {
        outputPboHandle = n;
    }

    @Nullable
    public final ByteBuffer getOldInputPboBuffer() {
        return oldInputPboBuffer;
    }

    public final void setOldInputPboBuffer(@Nullable ByteBuffer byteBuffer) {
        oldInputPboBuffer = byteBuffer;
    }

    @Nullable
    public final ByteBuffer getOldOutputPboBuffer() {
        return oldOutputPboBuffer;
    }

    public final void setOldOutputPboBuffer(@Nullable ByteBuffer byteBuffer) {
        oldOutputPboBuffer = byteBuffer;
    }

    public final class_2960 getOutputTextureIdentifier() {
        return outputTextureIdentifier;
    }

    public final void setOutputTextureIdentifier(class_2960 class_29602) {
        outputTextureIdentifier = class_29602;
    }

    @Nullable
    public final class_1044 getOutputTexture() {
        return outputTexture;
    }

    public final void setOutputTexture(@Nullable class_1044 class_10442) {
        outputTexture = class_10442;
    }

    @Nullable
    public final CustomVideoSource getVideoSource() {
        return videoSource;
    }

    public final void setVideoSource(@Nullable CustomVideoSource customVideoSource) {
        videoSource = customVideoSource;
    }

    public final int getFrameCount() {
        return frameCount;
    }

    public final void setFrameCount(int n) {
        frameCount = n;
    }

    public final boolean getHasReceivedFrameBack() {
        return hasReceivedFrameBack;
    }

    public final void setHasReceivedFrameBack(boolean bl) {
        hasReceivedFrameBack = bl;
    }

    @Nullable
    public final VideoTrack getVideoTrack() {
        return videoTrack;
    }

    public final void setVideoTrack(@Nullable VideoTrack videoTrack) {
        MirageClient.videoTrack = videoTrack;
    }

    public final int getCurrentPromptIndex() {
        return currentPromptIndex;
    }

    public final void setCurrentPromptIndex(int n) {
        currentPromptIndex = n;
    }

    public final boolean getModelIsPrimaryView() {
        return modelIsPrimaryView;
    }

    public final void setModelIsPrimaryView(boolean bl) {
        modelIsPrimaryView = bl;
    }

    public final boolean getShowModelOutput() {
        return showModelOutput;
    }

    public final void setShowModelOutput(boolean bl) {
        showModelOutput = bl;
    }

    @Nullable
    public final PeerConnectionFactory getFactory() {
        return factory;
    }

    public final void setFactory(@Nullable PeerConnectionFactory peerConnectionFactory) {
        factory = peerConnectionFactory;
    }

    @Nullable
    public final RTCRtpTransceiver getRtcTransceiver() {
        return rtcTransceiver;
    }

    public final void setRtcTransceiver(@Nullable RTCRtpTransceiver rTCRtpTransceiver) {
        rtcTransceiver = rTCRtpTransceiver;
    }

    @NotNull
    public final String getSecretKeyword() {
        return secretKeyword;
    }

    public final void setSecretKeyword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        secretKeyword = string;
    }

    @NotNull
    public final String getCurrentReceiveFPS() {
        return currentReceiveFPS;
    }

    public final void setCurrentReceiveFPS(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        currentReceiveFPS = string;
    }

    @Nullable
    public final class_6367 getInputFbo() {
        return inputFbo;
    }

    public final void setInputFbo(@Nullable class_6367 class_63672) {
        inputFbo = class_63672;
    }

    public final int getSessionTime() {
        return sessionTime;
    }

    public final void setSessionTime(int n) {
        sessionTime = n;
    }

    public void onInitializeClient() {
        String minecraftVersion = class_155.method_16673().method_48019();
        Object v0 = FabricLoader.getInstance().getModContainer("decart-mirage").orElse(null);
        Intrinsics.checkNotNull(v0);
        String modVersion = ((ModContainer)v0).getMetadata().getVersion().getFriendlyString();
        System.out.println((Object)"[Mirage] onInitializeClient");
        ClientLifecycleEvents.CLIENT_STARTED.register(MirageClient::onInitializeClient$lambda$0);
        ClientLifecycleEvents.CLIENT_STOPPING.register(MirageClient::onInitializeClient$lambda$1);
        ServerLifecycleEvents.SERVER_STOPPING.register(MirageClient::onInitializeClient$lambda$2);
        class_304 keyNextPrompt = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Switch to the next prompt", 93, "MirageCraft"));
        class_304 keyPreviousPrompt = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Switch to the previous prompt", 91, "MirageCraft"));
        class_304 keyToggleModel = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Toggle AI/normal view", 86, "MirageCraft"));
        class_304 keyPeekModel = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Peek AI/normal view", 82, "MirageCraft"));
        ClientTickEvents.END_CLIENT_TICK.register(arg_0 -> MirageClient.onInitializeClient$lambda$3(keyNextPrompt, keyPreviousPrompt, keyToggleModel, keyPeekModel, arg_0));
        LiteralArgumentBuilder mirageCommand = ClientCommandManager.literal((String)"mirage");
        ClientCommandRegistrationCallback.EVENT.register((arg_0, arg_1) -> MirageClient.onInitializeClient$lambda$4(mirageCommand, arg_0, arg_1));
        LiteralArgumentBuilder mirageStatusCommand = ClientCommandManager.literal((String)"status");
        mirageStatusCommand.executes(arg_0 -> MirageClient.onInitializeClient$lambda$5(modVersion, minecraftVersion, arg_0));
        mirageCommand.then((ArgumentBuilder)mirageStatusCommand);
        LiteralArgumentBuilder mirageStartCommand = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"start").then(ClientCommandManager.argument((String)"Access Key", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(MirageClient::onInitializeClient$lambda$6));
        mirageCommand.then((ArgumentBuilder)mirageStartCommand);
        LiteralArgumentBuilder mirageStopCommand = ClientCommandManager.literal((String)"stop");
        mirageStopCommand.executes(MirageClient::onInitializeClient$lambda$7);
        mirageCommand.then((ArgumentBuilder)mirageStopCommand);
        LiteralArgumentBuilder mirageSwitchPromptCommand = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"prompt").then(ClientCommandManager.argument((String)"prompt", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(MirageClient::onInitializeClient$lambda$8));
        mirageCommand.then((ArgumentBuilder)mirageSwitchPromptCommand);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendPrompt(@NotNull String inputPrompt, boolean shouldEnrich) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)inputPrompt, (String)"inputPrompt");
        if (!isConnected) {
            return;
        }
        WebSocket webSocket = MirageClient.webSocket;
        Intrinsics.checkNotNull((Object)webSocket);
        Json json = (Json)Json.Default;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)JsonElementKt.JsonPrimitive((String)"prompt")), TuplesKt.to((Object)"prompt", (Object)JsonElementKt.JsonPrimitive((String)inputPrompt)), TuplesKt.to((Object)"should_enrich", (Object)JsonElementKt.JsonPrimitive((Boolean)shouldEnrich))};
        JsonObject value$iv = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        webSocket.sendText(this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv), true);
    }

    public final void constructor() {
        System.out.println((Object)"[Mirage] Constructor");
        inputFbo = new class_6367(768, 432, false);
        inputPboHandle = GlStateManager._glGenBuffers();
        outputPboHandle = GlStateManager._glGenBuffers();
        long outputSize = 0x144000L;
        RenderSystem.glBindBuffer((int)35051, (int)inputPboHandle);
        GlStateManager._glBufferData((int)35051, (long)outputSize, (int)35041);
        RenderSystem.glBindBuffer((int)35051, (int)0);
        RenderSystem.glBindBuffer((int)35052, (int)outputPboHandle);
        GlStateManager._glBufferData((int)35052, (long)outputSize, (int)35040);
        RenderSystem.glBindBuffer((int)35052, (int)0);
        outputTexture = minecraftClient.method_1531().method_4619(outputTextureIdentifier);
    }

    public final void onResized(int width, int height) {
        System.out.println((Object)("[Mirage] Resized to " + width + " x " + height));
    }

    public final void close() {
        block0: {
            System.out.println((Object)"[Mirage] Closing");
            this.stop();
            RenderSystem.glDeleteBuffers((int)inputPboHandle);
            RenderSystem.glDeleteBuffers((int)outputPboHandle);
            class_1044 class_10442 = outputTexture;
            if (class_10442 == null) break block0;
            class_10442.method_4528();
        }
    }

    public final void afterRenderWorld() {
        if (!isConnected || !isRunning) {
            return;
        }
        long frameTimeMs = class_156.method_658();
        if (frameTimeMs / (long)71 != lastFrameTimeMs / (long)71) {
            long deltaMs = frameTimeMs - lastFrameTimeMs;
            if (deltaMs > 0L) {
                double fps = 1000.0 / (double)deltaMs;
            }
            lastFrameTimeMs = frameTimeMs;
            if (frameTimeMs / (long)1000 != lastStatsTimeMs / (long)1000) {
                lastStatsTimeMs = frameTimeMs;
                RTCPeerConnection rTCPeerConnection = peerConnection;
                Intrinsics.checkNotNull((Object)rTCPeerConnection);
                rTCPeerConnection.getStats(MirageClient::afterRenderWorld$lambda$9);
            }
            this.sendInputFrame();
            ByteBuffer byteBuffer = currentOutputFrameBGRA;
            if (byteBuffer == null) {
                return;
            }
            ByteBuffer outputFrameBGRA = byteBuffer;
            outputFrameBGRA.rewind();
            long t0 = System.nanoTime();
            this.uploadOutputFrameToTexture(currentOutputWidth, currentOutputHeight, outputFrameBGRA);
        }
        if (hasReceivedFrameBack) {
            class_332 drawContext = new class_332(minecraftClient, minecraftClient.method_22940().method_23000());
            int width = drawContext.method_51421();
            int height = drawContext.method_51443();
            if (showModelOutput) {
                drawContext.method_25291(class_1921::method_62277, outputTextureIdentifier, 0, 0, 0.0f, 0.0f, width, height, width, height, -1);
            }
        }
    }

    public final void beforeInGameHudRender(@NotNull class_332 drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        if (!(isConnected && isRunning && hasReceivedFrameBack)) {
            return;
        }
        int width = drawContext.method_51421();
        class_327 textRenderer = MirageClient.minecraftClient.field_1772;
        class_5250 watermarkText = class_2561.method_43470((String)"MirageCraft by Decart");
        int watermarkTextW = textRenderer.method_27525((class_5348)watermarkText);
        int watermarkTextWLH = textRenderer.method_44378((class_5348)watermarkText, watermarkTextW);
        class_5250 promptText = class_2561.method_43470((String)("Prompt: " + MirageClientKt.getCurrentPrompt()));
        int promptTextW = textRenderer.method_27525((class_5348)promptText);
        int promptTextWLH = textRenderer.method_44378((class_5348)promptText, promptTextW);
        class_5250 fpsText = class_2561.method_43470((String)("FPS: " + (int)Double.parseDouble(currentReceiveFPS)));
        int fpsTextW = textRenderer.method_27525((class_5348)fpsText);
        int fpsTextWLH = textRenderer.method_44378((class_5348)fpsText, fpsTextW);
        class_5250 sessionTimerText = class_2561.method_43470((String)("Minutes left: " + sessionTime / 60));
        int sessionTimerTextW = textRenderer.method_27525((class_5348)sessionTimerText);
        if (showModelOutput) {
            drawContext.method_60649(textRenderer, (class_2561)watermarkText, width - watermarkTextW - 10, 8, watermarkTextW, -1);
            drawContext.method_60649(textRenderer, (class_2561)promptText, width - promptTextW - 10, 11 + watermarkTextWLH, promptTextW, -1);
            drawContext.method_60649(textRenderer, (class_2561)fpsText, width - fpsTextW - 10, 14 + watermarkTextWLH + promptTextWLH, fpsTextW, -1);
            drawContext.method_60649(textRenderer, (class_2561)sessionTimerText, width - sessionTimerTextW - 10, 17 + watermarkTextWLH + promptTextWLH + fpsTextWLH, sessionTimerTextW, -1);
        }
    }

    public final long getLastSentFrameMs() {
        return lastSentFrameMs;
    }

    public final void setLastSentFrameMs(long l) {
        lastSentFrameMs = l;
    }

    public final void sendInputFrame() {
        ByteBuffer pboBuffer;
        class_276 framebuffer = minecraftClient.method_1522();
        class_1041 window = minecraftClient.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        int framebufferSize = width * height * 4;
        GlStateManager._glBindFramebuffer((int)36008, (int)framebuffer.field_1476);
        class_6367 class_63672 = inputFbo;
        Intrinsics.checkNotNull((Object)class_63672);
        GlStateManager._glBindFramebuffer((int)36009, (int)class_63672.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)width, (int)height, (int)0, (int)0, (int)768, (int)432, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
        RenderSystem.glBindBuffer((int)35051, (int)inputPboHandle);
        class_6367 class_63673 = inputFbo;
        Intrinsics.checkNotNull((Object)class_63673);
        class_63673.method_1235(false);
        GlStateManager._readPixels((int)0, (int)0, (int)768, (int)432, (int)32993, (int)5121, (long)0L);
        class_6367 class_63674 = inputFbo;
        Intrinsics.checkNotNull((Object)class_63674);
        class_63674.method_1240();
        ByteBuffer byteBuffer = GL15.glMapBuffer((int)35051, (int)35000, (long)framebufferSize, (ByteBuffer)oldInputPboBuffer);
        Intrinsics.checkNotNull((Object)byteBuffer);
        oldInputPboBuffer = pboBuffer = byteBuffer;
        GlStateManager._glUnmapBuffer((int)35051);
        RenderSystem.glBindBuffer((int)35051, (int)0);
        this.sendInputFrameToWebRTC(768, 432, pboBuffer);
    }

    public final void start() {
        if (isRunning) {
            return;
        }
        isRunning = true;
        System.out.println((Object)("[Mirage] Starting with prompt: " + MirageClientKt.getCurrentPrompt()));
        this.connectToWebSocketServer();
    }

    public final void startSessionTimer() {
        TimerTask timerTask2 = new TimerTask(){

            public void run() {
                if (MirageClient.INSTANCE.getSessionTime() == 0) {
                    System.out.println((Object)"[Mirage] Session timer expired");
                    class_5250 class_52502 = class_2561.method_43470((String)"Your time is up! Use \"/mirage start\" to start a new session.").method_27692(class_124.field_1054);
                    Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
                    MirageClient.INSTANCE.sendChatMessage((class_2561)class_52502);
                    MirageClient.INSTANCE.stop();
                    this.cancel();
                } else {
                    int n = MirageClient.INSTANCE.getSessionTime();
                    MirageClient.INSTANCE.setSessionTime(n + -1);
                }
            }
        };
        Timer timer = new Timer("session-timer");
        timer.scheduleAtFixedRate(timerTask2, 0L, 1000L);
    }

    public final void connectToWebSocketServer() {
        WebSocket.Listener listener2 = new WebSocket.Listener(){
            private StringBuilder message;
            {
                this.message = new StringBuilder();
            }

            public final StringBuilder getMessage() {
                return this.message;
            }

            public final void setMessage(StringBuilder stringBuilder) {
                Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
                this.message = stringBuilder;
            }

            /*
             * WARNING - void declaration
             */
            public void onOpen(WebSocket webSocket) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                System.out.println((Object)"[Mirage] WebSocket opened");
                MirageClient.INSTANCE.setupPeerConnection();
                Json json = (Json)Json.Default;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)JsonElementKt.JsonPrimitive((String)"initialize_session")), TuplesKt.to((Object)"session_id", (Object)JsonElementKt.JsonPrimitive((String)UUID.randomUUID().toString())), TuplesKt.to((Object)"fps", (Object)JsonElementKt.JsonPrimitive((Number)14)), TuplesKt.to((Object)"prompt", (Object)JsonElementKt.JsonPrimitive((String)MirageClientKt.getPROMPT_LIST().get(0))), TuplesKt.to((Object)"product", (Object)JsonElementKt.JsonPrimitive((String)"miragecraft")), TuplesKt.to((Object)"access_key", (Object)JsonElementKt.JsonPrimitive((String)MirageClient.INSTANCE.getSecretKeyword()))};
                JsonObject value$iv = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                webSocket.sendText(this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv), true);
                webSocket.request(1L);
            }

            public CompletionStage<Void> onClose(WebSocket webSocket, int status, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                System.out.println((Object)("[Mirage] WebSocket closed for reason: " + reason));
                if (Intrinsics.areEqual((Object)reason, (Object)"Invalid access key")) {
                    class_124[] class_124Array = new class_124[]{class_124.field_1061, class_124.field_1067};
                    class_5250 class_52502 = class_2561.method_43470((String)"Your access code is invalid").method_27695(class_124Array);
                    Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
                    MirageClient.INSTANCE.sendChatMessage((class_2561)class_52502);
                    MirageClient.INSTANCE.stop();
                }
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }

            public void onError(WebSocket webSocket, Throwable error) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                System.out.println((Object)("[Mirage] WebSocket error: " + error));
            }

            public CompletionStage<Void> onText(WebSocket webSocket, CharSequence message, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                System.out.println((Object)("[Mirage] WebSocket message: " + last + " " + message.length() + " | " + message));
                this.message.append(message);
                if (last) {
                    MirageClient.INSTANCE.handleMessage(this.message);
                    this.message = new StringBuilder();
                }
                webSocket.request(1L);
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }
        };
        HttpClient httpClient = HttpClient.newHttpClient();
        webSocket = httpClient.newWebSocketBuilder().connectTimeout(Duration.ofSeconds(10L)).buildAsync(URI.create("wss://bouncer.mirage.decart.ai/ws?gameTimeLimitSeconds=7200"), listener2).join();
    }

    public final void handleMessage(@NotNull CharSequence message) {
        String messageType;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        System.out.println((Object)("[Mirage] Handling message: " + message));
        JsonElement parsedJson = Json.Default.parseToJsonElement(((Object)message).toString());
        Intrinsics.checkNotNull((Object)parsedJson, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
        Object object = ((JsonObject)parsedJson).get((Object)"type");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
        String string = messageType = ((JsonPrimitive)object).getContent();
        if (Intrinsics.areEqual((Object)string, (Object)"ready")) {
            System.out.println((Object)"[Mirage] Received ready message, sending offer");
            Object object2 = ((JsonObject)parsedJson).get((Object)"game_time_limit_seconds");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            sessionTime = (int)Double.parseDouble(((JsonPrimitive)object2).getContent());
            this.startSessionTimer();
            this.sendOffer();
        } else if (Intrinsics.areEqual((Object)string, (Object)"answer")) {
            System.out.println((Object)"[Mirage] Received answer message");
            Object object3 = ((JsonObject)parsedJson).get((Object)"sdp");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            String sdp = ((JsonPrimitive)object3).getContent();
            RTCPeerConnection rTCPeerConnection = peerConnection;
            Intrinsics.checkNotNull((Object)rTCPeerConnection);
            rTCPeerConnection.setRemoteDescription(new RTCSessionDescription(RTCSdpType.ANSWER, sdp), new SetSessionDescriptionObserver(){

                public void onSuccess() {
                    System.out.println((Object)"[Mirage] Set remote description");
                }

                public void onFailure(String error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    System.out.println((Object)("[Mirage] Failed to set remote description: " + error));
                }
            });
        }
    }

    public final void sendOffer() {
        System.out.println((Object)"[Mirage] Sending offer");
        PeerConnectionFactory peerConnectionFactory = factory;
        Intrinsics.checkNotNull((Object)peerConnectionFactory);
        RTCRtpTransceiver rTCRtpTransceiver = rtcTransceiver;
        Intrinsics.checkNotNull((Object)rTCRtpTransceiver);
        SdpTweaker.INSTANCE.preferCodec("VP8", peerConnectionFactory, rTCRtpTransceiver);
        RTCPeerConnection rTCPeerConnection = peerConnection;
        Intrinsics.checkNotNull((Object)rTCPeerConnection);
        rTCPeerConnection.createOffer(new RTCOfferOptions(), new CreateSessionDescriptionObserver(){

            public void onSuccess(RTCSessionDescription description) {
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                System.out.println((Object)("[Mirage] Created offer: " + description));
                RTCPeerConnection rTCPeerConnection = MirageClient.INSTANCE.getPeerConnection();
                Intrinsics.checkNotNull((Object)rTCPeerConnection);
                rTCPeerConnection.setLocalDescription(description, new SetSessionDescriptionObserver(description){
                    final /* synthetic */ RTCSessionDescription $description;
                    {
                        this.$description = $description;
                    }

                    public void onSuccess() {
                        System.out.println((Object)"[Mirage] Set local description");
                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)JsonElementKt.JsonPrimitive((String)"offer")), TuplesKt.to((Object)"sdp", (Object)JsonElementKt.JsonPrimitive((String)this.$description.sdp))};
                        JsonObject offerMessage = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
                        WebSocket webSocket = MirageClient.INSTANCE.getWebSocket();
                        Intrinsics.checkNotNull((Object)webSocket);
                        Json this_$iv = (Json)Json.Default;
                        boolean $i$f$encodeToString = false;
                        this_$iv.getSerializersModule();
                        webSocket.sendText(this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)offerMessage), true);
                        WebSocket webSocket2 = MirageClient.INSTANCE.getWebSocket();
                        Intrinsics.checkNotNull((Object)webSocket2);
                        webSocket2.request(1L);
                    }

                    public void onFailure(String error) {
                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                        System.out.println((Object)("[Mirage] Failed to set local description: " + error));
                    }
                });
            }

            public void onFailure(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                System.out.println((Object)("[Mirage] Failed to create offer: " + error));
            }
        });
    }

    public final void setupPeerConnection() {
        System.out.println((Object)"[Mirage] Setting up peer connection");
        factory = new PeerConnectionFactory();
        RTCConfiguration config = new RTCConfiguration();
        RTCIceServer iceServer = new RTCIceServer();
        iceServer.urls = CollectionsKt.listOf((Object)"stun:stun.l.google.com:19302");
        config.iceServers.add(iceServer);
        PeerConnectionFactory peerConnectionFactory = factory;
        Intrinsics.checkNotNull((Object)peerConnectionFactory);
        peerConnection = peerConnectionFactory.createPeerConnection(config, new PeerConnectionObserver(){

            public void onSignalingChange(RTCSignalingState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                System.out.println((Object)("[Mirage] onSignalingChange: " + state));
            }

            public void onConnectionChange(RTCPeerConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                System.out.println((Object)("[Mirage] onConnectionChange: " + state));
                if (state.equals((Object)RTCPeerConnectionState.CONNECTED)) {
                    System.out.println((Object)"connected, should start videoSource now");
                    MirageClient.INSTANCE.setConnected(true);
                }
            }

            public void onIceConnectionChange(RTCIceConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                System.out.println((Object)("[Mirage] onIceConnectionChange: " + state));
            }

            public void onStandardizedIceConnectionChange(RTCIceConnectionState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                System.out.println((Object)("[Mirage] onStandardizedIceConnectionChange: " + state));
            }

            public void onIceConnectionReceivingChange(boolean receiving) {
                System.out.println((Object)("[Mirage] onIceConnectionReceivingChange: " + receiving));
            }

            public void onIceGatheringChange(RTCIceGatheringState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                System.out.println((Object)("[Mirage] onIceGatheringChange: " + state));
            }

            /*
             * WARNING - void declaration
             */
            public void onIceCandidate(RTCIceCandidate candidate) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
                System.out.println((Object)("[Mirage] Received ICE candidate: " + candidate));
                WebSocket webSocket = MirageClient.INSTANCE.getWebSocket();
                Intrinsics.checkNotNull((Object)webSocket);
                Json json = (Json)Json.Default;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"type", (Object)JsonElementKt.JsonPrimitive((String)"ice-candidate"));
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"candidate", (Object)JsonElementKt.JsonPrimitive((String)candidate.sdp)), TuplesKt.to((Object)"sdpMid", (Object)JsonElementKt.JsonPrimitive((String)candidate.sdpMid)), TuplesKt.to((Object)"sdpMLineIndex", (Object)JsonElementKt.JsonPrimitive((Number)candidate.sdpMLineIndex))};
                pairArray[1] = TuplesKt.to((Object)"candidate", (Object)new JsonObject(MapsKt.mapOf((Pair[])pairArray2)));
                JsonObject value$iv = new JsonObject(MapsKt.mapOf((Pair[])pairArray));
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                webSocket.sendText(this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv), true);
            }

            public void onIceCandidateError(RTCPeerConnectionIceErrorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                System.out.println((Object)("[Mirage] onIceCandidateError: " + event));
            }

            public void onIceCandidatesRemoved(RTCIceCandidate[] candidates) {
                Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
                System.out.println((Object)("[Mirage] onIceCandidatesRemoved: " + candidates));
            }

            public void onAddStream(MediaStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                System.out.println((Object)("[Mirage] onAddStream: " + stream));
            }

            public void onRemoveStream(MediaStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                System.out.println((Object)("[Mirage] onRemoveStream: " + stream));
            }

            public void onDataChannel(RTCDataChannel dataChannel) {
                Intrinsics.checkNotNullParameter((Object)dataChannel, (String)"dataChannel");
                System.out.println((Object)("[Mirage] onDataChannel: " + dataChannel));
            }

            public void onRenegotiationNeeded() {
                System.out.println((Object)"[Mirage] onRenegotiationNeeded");
            }

            public void onAddTrack(RTCRtpReceiver receiver, MediaStream[] mediaStreams) {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                Intrinsics.checkNotNullParameter((Object)mediaStreams, (String)"mediaStreams");
                System.out.println((Object)("[Mirage] onAddTrack: " + receiver + ", " + mediaStreams));
            }

            public void onRemoveTrack(RTCRtpReceiver receiver) {
                Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
                System.out.println((Object)("[Mirage] onRemoveTrack: " + receiver));
            }

            public void onTrack(RTCRtpTransceiver transceiver) {
                Intrinsics.checkNotNullParameter((Object)transceiver, (String)"transceiver");
                MediaStreamTrack mediaStreamTrack = transceiver.getSender().getTrack();
                MediaStreamTrack mediaStreamTrack2 = transceiver.getReceiver().getTrack();
                System.out.println((Object)("[Mirage] onTrack: " + transceiver + " " + transceiver.getDirection() + " " + (mediaStreamTrack != null ? mediaStreamTrack.getKind() : null) + " " + (mediaStreamTrack2 != null ? mediaStreamTrack2.getKind() : null)));
                MediaStreamTrack incomingTrack = transceiver.getReceiver().getTrack();
                if (!(incomingTrack instanceof VideoTrack)) {
                    return;
                }
                Ref.ObjectRef buffer = new Ref.ObjectRef();
                buffer.element = ByteBuffer.allocate(MirageClient.INSTANCE.getCurrentOutputWidth() * MirageClient.INSTANCE.getCurrentOutputHeight() * 4);
                Ref.IntRef frameCount = new Ref.IntRef();
                ((VideoTrack)incomingTrack).addSink(arg_0 -> setupPeerConnection.1.onTrack$lambda$0(frameCount, buffer, arg_0));
            }

            private static final void onTrack$lambda$0(Ref.IntRef $frameCount, Ref.ObjectRef $buffer, VideoFrame frame) {
                MirageClient.INSTANCE.setHasReceivedFrameBack(true);
                int n = $frameCount.element;
                $frameCount.element = n + 1;
                if (((ByteBuffer)$buffer.element).capacity() != frame.buffer.getWidth() * frame.buffer.getHeight() * 4) {
                    $buffer.element = ByteBuffer.allocate(frame.buffer.getWidth() * frame.buffer.getHeight() * 4);
                    MirageClient.INSTANCE.setCurrentOutputWidth(frame.buffer.getWidth());
                    MirageClient.INSTANCE.setCurrentOutputHeight(frame.buffer.getHeight());
                    MirageClient.INSTANCE.setCurrentOutputFrameBGRA((ByteBuffer)$buffer.element);
                }
                try {
                    VideoBufferConverter.convertFromI420((VideoFrameBuffer)frame.buffer, (ByteBuffer)((ByteBuffer)$buffer.element), (FourCC)FourCC.ABGR);
                    ((ByteBuffer)$buffer.element).rewind();
                    MirageClient.INSTANCE.setCurrentOutputFrameBGRA((ByteBuffer)$buffer.element);
                }
                catch (Exception e) {
                    System.out.println((Object)("[Mirage] Error converting video frame: " + e));
                }
            }
        });
        videoSource = new CustomVideoSource();
        PeerConnectionFactory peerConnectionFactory2 = factory;
        Intrinsics.checkNotNull((Object)peerConnectionFactory2);
        videoTrack = peerConnectionFactory2.createVideoTrack("videoTrack", (VideoTrackSource)videoSource);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String videoId = string;
        RTCPeerConnection rTCPeerConnection = peerConnection;
        Intrinsics.checkNotNull((Object)rTCPeerConnection);
        rtcTransceiver = rTCPeerConnection.addTransceiver((MediaStreamTrack)videoTrack, new RTCRtpTransceiverInit());
        Ref.IntRef frameCount = new Ref.IntRef();
        VideoTrack videoTrack = MirageClient.videoTrack;
        Intrinsics.checkNotNull((Object)videoTrack);
        videoTrack.addSink(arg_0 -> MirageClient.setupPeerConnection$lambda$10(frameCount, arg_0));
    }

    public final void stop() {
        if (!isRunning) {
            return;
        }
        System.out.println((Object)"[Mirage] Stopping");
        RTCPeerConnection rTCPeerConnection = peerConnection;
        if (rTCPeerConnection != null) {
            rTCPeerConnection.close();
        }
        peerConnection = null;
        lastFrameTimeMs = 0L;
        WebSocket webSocket = MirageClient.webSocket;
        if (webSocket != null) {
            webSocket.sendClose(1000, "Normal Closure");
        }
        MirageClient.webSocket = null;
        videoSource = null;
        frameCount = 0;
        isRunning = false;
        hasReceivedFrameBack = false;
        isConnected = false;
    }

    @NotNull
    public final class_2561 formatChatMessage(@NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        class_124[] class_124Array = new class_124[]{class_124.field_1063, class_124.field_1067};
        class_5250 class_52502 = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27695(class_124Array));
        class_124Array = new class_124[]{class_124.field_1075, class_124.field_1067};
        class_5250 class_52503 = class_52502.method_10852((class_2561)class_2561.method_43470((String)"Mirage").method_27695(class_124Array));
        class_124Array = new class_124[]{class_124.field_1063, class_124.field_1067};
        class_5250 class_52504 = class_52503.method_10852((class_2561)class_2561.method_43470((String)"] ").method_27695(class_124Array)).method_10852(message);
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"append(...)");
        return (class_2561)class_52504;
    }

    public final void sendChatMessage(@NotNull CommandContext<FabricClientCommandSource> context, @NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((FabricClientCommandSource)context.getSource()).sendFeedback(this.formatChatMessage(message));
    }

    public final void sendChatMessage(@NotNull class_2561 message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MirageClient.minecraftClient.field_1705.method_1743().method_1812(this.formatChatMessage(message));
    }

    public final void sendInputFrameToWebRTC(int width, int height, @NotNull ByteBuffer bgraBuffer) {
        Intrinsics.checkNotNullParameter((Object)bgraBuffer, (String)"bgraBuffer");
        if (videoSource == null) {
            return;
        }
        MirageClient.flipByteBufferVertically$default(this, bgraBuffer, width, height, 0, 8, null);
        NativeI420Buffer i420Buffer = NativeI420Buffer.allocate((int)width, (int)height);
        VideoBufferConverter.convertToI420((ByteBuffer)bgraBuffer, (I420Buffer)((I420Buffer)i420Buffer), (FourCC)FourCC.ARGB);
        VideoFrame videoFrame = new VideoFrame((VideoFrameBuffer)i420Buffer, System.nanoTime());
        CustomVideoSource customVideoSource = videoSource;
        Intrinsics.checkNotNull((Object)customVideoSource);
        customVideoSource.pushFrame(videoFrame);
        videoFrame.release();
    }

    public final void flipByteBufferVertically(@NotNull ByteBuffer buffer, int width, int height, int bytesPerPixel) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int rowSize = width * bytesPerPixel;
        byte[] rowBufferTop = new byte[rowSize];
        byte[] rowBufferBottom = new byte[rowSize];
        int n = height / 2;
        for (int y = 0; y < n; ++y) {
            int topOffset = y * rowSize;
            int bottomOffset = (height - y - 1) * rowSize;
            buffer.position(topOffset);
            buffer.get(rowBufferTop);
            buffer.position(bottomOffset);
            buffer.get(rowBufferBottom);
            buffer.position(topOffset);
            buffer.put(rowBufferBottom);
            buffer.position(bottomOffset);
            buffer.put(rowBufferTop);
        }
        buffer.rewind();
    }

    public static /* synthetic */ void flipByteBufferVertically$default(MirageClient mirageClient, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 4;
        }
        mirageClient.flipByteBufferVertically(byteBuffer, n, n2, n3);
    }

    public final void uploadOutputFrameToTexture(int width, int height, @NotNull ByteBuffer frameBGRA) {
        ByteBuffer pboBuffer;
        Intrinsics.checkNotNullParameter((Object)frameBGRA, (String)"frameBGRA");
        RenderSystem.glBindBuffer((int)35052, (int)outputPboHandle);
        GlStateManager._glBufferData((int)35052, (long)frameBGRA.capacity(), (int)35040);
        ByteBuffer byteBuffer = GL15.glMapBuffer((int)35052, (int)35001, (long)frameBGRA.capacity(), (ByteBuffer)oldOutputPboBuffer);
        Intrinsics.checkNotNull((Object)byteBuffer);
        oldOutputPboBuffer = pboBuffer = byteBuffer;
        pboBuffer.put(frameBGRA);
        GlStateManager._glUnmapBuffer((int)35052);
        class_1044 class_10442 = outputTexture;
        Intrinsics.checkNotNull((Object)class_10442);
        class_10442.method_23207();
        GL11.glPixelStorei((int)3315, (int)0);
        GlStateManager._texImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        RenderSystem.glBindBuffer((int)35052, (int)0);
        RenderSystem.bindTexture((int)0);
    }

    private static final void onInitializeClient$lambda$0(class_310 it) {
        System.out.println((Object)"[Mirage] Client started");
    }

    private static final void onInitializeClient$lambda$1(class_310 it) {
        System.out.println((Object)"[Mirage] Client stopping");
    }

    private static final void onInitializeClient$lambda$2(MinecraftServer it) {
        System.out.println((Object)"[Mirage] Server stopping");
        INSTANCE.stop();
    }

    private static final void onInitializeClient$lambda$3(class_304 $keyNextPrompt, class_304 $keyPreviousPrompt, class_304 $keyToggleModel, class_304 $keyPeekModel, class_310 client) {
        int n;
        if ($keyNextPrompt.method_1436()) {
            n = currentPromptIndex;
            currentPromptIndex = n + 1;
            if (currentPromptIndex == MirageClientKt.getPROMPT_LIST().size()) {
                currentPromptIndex = 0;
            }
            INSTANCE.sendPrompt(MirageClientKt.getPROMPT_LIST().get(currentPromptIndex), false);
            MirageClientKt.setCurrentPrompt(MirageClientKt.getPROMPT_NAMES().get(currentPromptIndex));
        }
        if ($keyPreviousPrompt.method_1436()) {
            if (currentPromptIndex == 0) {
                currentPromptIndex = MirageClientKt.getPROMPT_LIST().size();
            }
            n = currentPromptIndex;
            currentPromptIndex = n + -1;
            INSTANCE.sendPrompt(MirageClientKt.getPROMPT_LIST().get(currentPromptIndex), false);
            MirageClientKt.setCurrentPrompt(MirageClientKt.getPROMPT_NAMES().get(currentPromptIndex));
        }
        if ($keyToggleModel.method_1436()) {
            modelIsPrimaryView = !modelIsPrimaryView;
        }
        showModelOutput = modelIsPrimaryView != $keyPeekModel.method_1434();
    }

    private static final void onInitializeClient$lambda$4(LiteralArgumentBuilder $mirageCommand, CommandDispatcher dispatcher, class_7157 registryAccess) {
        dispatcher.register($mirageCommand);
    }

    private static final int onInitializeClient$lambda$5(String $modVersion, String $minecraftVersion, CommandContext context) {
        class_1041 window = minecraftClient.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        Intrinsics.checkNotNull((Object)context);
        class_5250 class_52502 = class_2561.method_43470((String)(isRunning ? "Running" : "Stopped")).method_27692(isRunning ? class_124.field_1060 : class_124.field_1061);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
        class_5250 class_52503 = class_2561.method_43470((String)(isConnected ? "Connected" : "Disconnected")).method_27692(isConnected ? class_124.field_1060 : class_124.field_1061);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        class_5250 class_52504 = class_2561.method_43470((String)("Window size " + width + " x " + height));
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52504);
        class_5250 class_52505 = class_2561.method_43470((String)("Mod v" + $modVersion));
        Intrinsics.checkNotNullExpressionValue((Object)class_52505, (String)"literal(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52505);
        class_5250 class_52506 = class_2561.method_43470((String)("Minecraft v" + $minecraftVersion));
        Intrinsics.checkNotNullExpressionValue((Object)class_52506, (String)"literal(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52506);
        return 1;
    }

    private static final int onInitializeClient$lambda$6(CommandContext context) {
        if (isRunning) {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52502 = class_2561.method_43470((String)"Already running").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
        } else {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52503 = class_2561.method_43470((String)("Starting with prompt: " + StringsKt.take((String)MirageClientKt.getCurrentPrompt(), (int)50) + "...")).method_27692(class_124.field_1060);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
            class_5250 class_52504 = class_2561.method_43470((String)"Starting your session timer now. When the session ends, you can use \"/mirage start\" again to restart the session.").method_27692(class_124.field_1060);
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52504);
            String string = StringArgumentType.getString((CommandContext)context, (String)"Access Key");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            secretKeyword = string;
            INSTANCE.start();
        }
        return 1;
    }

    private static final int onInitializeClient$lambda$7(CommandContext context) {
        if (isRunning) {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52502 = class_2561.method_43470((String)"Stopping").method_27692(class_124.field_1061);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
            INSTANCE.stop();
        } else {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52503 = class_2561.method_43470((String)"Not running").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        }
        return 1;
    }

    private static final int onInitializeClient$lambda$8(CommandContext context) {
        if (!isConnected) {
            Intrinsics.checkNotNull((Object)context);
            class_5250 class_52502 = class_2561.method_43470((String)"Not connected yet! Use \"/mirage start\" to start a new session.").method_27692(class_124.field_1054);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"formatted(...)");
            INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52502);
            return 1;
        }
        String inputPrompt = StringArgumentType.getString((CommandContext)context, (String)"prompt");
        Intrinsics.checkNotNull((Object)inputPrompt);
        INSTANCE.sendPrompt(inputPrompt, true);
        MirageClientKt.setCurrentPrompt(inputPrompt);
        Intrinsics.checkNotNull((Object)context);
        class_5250 class_52503 = class_2561.method_43470((String)("Prompt sent: " + StringsKt.take((String)inputPrompt, (int)50) + "...")).method_27692(class_124.field_1060);
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"formatted(...)");
        INSTANCE.sendChatMessage((CommandContext<FabricClientCommandSource>)context, (class_2561)class_52503);
        return 1;
    }

    private static final void afterRenderWorld$lambda$9(RTCStatsReport report) {
        Map map = report.getStats();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getStats(...)");
        for (Map.Entry entry : map.entrySet()) {
            String id = (String)entry.getKey();
            RTCStats stat = (RTCStats)entry.getValue();
            Map map2 = stat.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAttributes(...)");
            for (Map.Entry entry2 : map2.entrySet()) {
                String key = (String)entry2.getKey();
                Object value = entry2.getValue();
                if (!Intrinsics.areEqual((Object)key, (Object)"framesPerSecond")) continue;
                currentReceiveFPS = value.toString();
            }
        }
    }

    private static final void setupPeerConnection$lambda$10(Ref.IntRef $frameCount, VideoFrame frame) {
        int n = $frameCount.element;
        $frameCount.element = n + 1;
    }

    static {
        currentOutputWidth = 1;
        currentOutputHeight = 1;
        outputTextureIdentifier = class_2960.method_60655((String)"decart", (String)"mirage");
        modelIsPrimaryView = true;
        showModelOutput = true;
        secretKeyword = "";
        currentReceiveFPS = "";
    }
}

