/*
 * Decompiled with CFR 0.152.
 */
package ai.decart.mirage;

import dev.onvoid.webrtc.PeerConnectionFactory;
import dev.onvoid.webrtc.RTCRtpCapabilities;
import dev.onvoid.webrtc.RTCRtpCodecCapability;
import dev.onvoid.webrtc.RTCRtpTransceiver;
import dev.onvoid.webrtc.RTCSessionDescription;
import dev.onvoid.webrtc.media.MediaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0012\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000bJ'\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001b\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010#\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$J'\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b%\u0010\u0018\u00a8\u0006&"}, d2={"Lai/decart/mirage/SdpTweaker;", "", "<init>", "()V", "Ldev/onvoid/webrtc/RTCSessionDescription;", "original", "modifyOffer", "(Ldev/onvoid/webrtc/RTCSessionDescription;)Ldev/onvoid/webrtc/RTCSessionDescription;", "", "sdp", "ensureH264FmtpLines", "(Ljava/lang/String;)Ljava/lang/String;", "", "lines", "", "startIdx", "payload", "", "hasFmtpLine", "(Ljava/util/List;ILjava/lang/String;)Z", "createDefaultH264FmtpLine", "maxBitrate", "startBitrate", "addBitrateControls", "(Ljava/lang/String;II)Ljava/lang/String;", "addBandwidthLimit", "(Ljava/lang/String;I)Ljava/lang/String;", "findH264PayloadTypes", "(Ljava/lang/String;)Ljava/util/List;", "preferredCodecName", "Ldev/onvoid/webrtc/PeerConnectionFactory;", "factory", "Ldev/onvoid/webrtc/RTCRtpTransceiver;", "rtcTransceiver", "", "preferCodec", "(Ljava/lang/String;Ldev/onvoid/webrtc/PeerConnectionFactory;Ldev/onvoid/webrtc/RTCRtpTransceiver;)V", "addGoogleBitrateParams", "decart-mirage_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nSdpTweaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdpTweaker.kt\nai/decart/mirage/SdpTweaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1761#2,3:184\n774#2:187\n865#2,2:188\n1563#2:190\n1634#2,3:191\n1869#2,2:194\n*S KotlinDebug\n*F\n+ 1 SdpTweaker.kt\nai/decart/mirage/SdpTweaker\n*L\n118#1:184,3\n130#1:187\n130#1:188,2\n131#1:190\n131#1:191,3\n151#1:194,2\n*E\n"})
public final class SdpTweaker {
    @NotNull
    public static final SdpTweaker INSTANCE = new SdpTweaker();

    private SdpTweaker() {
    }

    @NotNull
    public final RTCSessionDescription modifyOffer(@NotNull RTCSessionDescription original) {
        String sdp;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        String string = sdp = original.sdp;
        Intrinsics.checkNotNull((Object)string);
        sdp = this.ensureH264FmtpLines(string);
        return new RTCSessionDescription(original.sdpType, sdp);
    }

    private final String ensureH264FmtpLines(String sdp) {
        String[] stringArray = new String[]{"\r\n"};
        List lines = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)sdp, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        for (int i = 0; i < lines.size(); ++i) {
            String payloadType;
            String line = (String)lines.get(i);
            if (!StringsKt.startsWith$default((String)line, (String)"a=rtpmap:", (boolean)false, (int)2, null) || !StringsKt.contains$default((CharSequence)line, (CharSequence)"H264/90000", (boolean)false, (int)2, null) || this.hasFmtpLine(lines, i, payloadType = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)line, (char)':', null, (int)2, null), (char)' ', null, (int)2, null))) continue;
            lines.add(i + 1, this.createDefaultH264FmtpLine(payloadType));
            ++i;
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\r\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final boolean hasFmtpLine(List<String> lines, int startIdx, String payload) {
        int n = Math.min(startIdx + 5, lines.size());
        for (int j = startIdx + 1; j < n; ++j) {
            String l = lines.get(j);
            if (StringsKt.startsWith$default((String)l, (String)("a=fmtp:" + payload), (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)l, (String)"a=rtpmap:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)l, (String)"m=", (boolean)false, (int)2, null)) break;
        }
        return false;
    }

    private final String createDefaultH264FmtpLine(String payload) {
        return "a=fmtp:" + payload + " profile-level-id=42e01f;packetization-mode=1;level-asymmetry-allowed=1;x-google-max-bframes=0;sps-pps-idr-in-keyframe=1";
    }

    private final String addBitrateControls(String sdp, int maxBitrate, int startBitrate) {
        String out = this.addBandwidthLimit(sdp, maxBitrate);
        out = this.addGoogleBitrateParams(out, maxBitrate, startBitrate);
        return out;
    }

    private final String addBandwidthLimit(String sdp, int maxBitrate) {
        int kbps = maxBitrate / 1000;
        String[] stringArray = new String[]{"\r\n"};
        List lines = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)sdp, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        int n = ((Collection)lines).size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            block4: {
                if (!StringsKt.startsWith$default((String)((String)lines.get(i)), (String)"m=video", (boolean)false, (int)2, null)) continue;
                Iterable $this$any$iv = lines.subList(i + 1, lines.size());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"b=AS:", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) break;
            lines.add(i + 1, "b=AS:" + kbps);
            break;
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\r\n", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> findH264PayloadTypes(@NotNull String sdp) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sdp, (String)"sdp");
        String[] stringArray = new String[]{"\r\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)sdp, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default((String)it, (String)"a=rtpmap:", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)"H264/90000", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it, (String)"a=rtpmap:", null, (int)2, null), (char)' ', null, (int)2, null));
        }
        return (List)destination$iv$iv;
    }

    public final void preferCodec(@NotNull String preferredCodecName, @NotNull PeerConnectionFactory factory, @NotNull RTCRtpTransceiver rtcTransceiver) {
        Intrinsics.checkNotNullParameter((Object)preferredCodecName, (String)"preferredCodecName");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)rtcTransceiver, (String)"rtcTransceiver");
        RTCRtpCapabilities capabilities = factory.getRtpSenderCapabilities(MediaType.VIDEO);
        List pref = rtcTransceiver.getCodecPreferences();
        if (capabilities == null) {
            System.err.println("Could not get video sender capabilities.");
            return;
        }
        List preferredCodecs = new ArrayList();
        List otherCodecs = new ArrayList();
        List list = capabilities.getCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCodecs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            RTCRtpCodecCapability codec = (RTCRtpCodecCapability)element$iv;
            boolean bl2 = false;
            String string = codec.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains((CharSequence)string, (CharSequence)preferredCodecName, (boolean)true)) {
                Intrinsics.checkNotNull((Object)codec);
                bl = preferredCodecs.add(codec);
                continue;
            }
            Intrinsics.checkNotNull((Object)codec);
            bl = otherCodecs.add(codec);
        }
        List orderedCodecs = CollectionsKt.plus((Collection)preferredCodecs, (Iterable)otherCodecs);
        if (orderedCodecs.isEmpty()) {
            System.err.println("No video codecs found to set preferences for.");
            return;
        }
        rtcTransceiver.setCodecPreferences(orderedCodecs);
    }

    private final String addGoogleBitrateParams(String sdp, int maxBitrate, int startBitrate) {
        String[] stringArray = new String[]{"\r\n"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)sdp, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\r\n", null, null, (int)0, null, arg_0 -> SdpTweaker.addGoogleBitrateParams$lambda$5(maxBitrate, startBitrate, arg_0), (int)30, null);
    }

    private static final CharSequence addGoogleBitrateParams$lambda$5(int $maxBitrate, int $startBitrate, String line) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.startsWith$default((String)line, (String)"a=fmtp:", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)"profile-level-id=42e01f", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder;
            StringBuilder $this$addGoogleBitrateParams_u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$addGoogleBitrateParams_u24lambda_u245_u24lambda_u244.append(line);
            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"x-google-max-bitrate", (boolean)false, (int)2, null)) {
                $this$addGoogleBitrateParams_u24lambda_u245_u24lambda_u244.append(";x-google-max-bitrate=" + $maxBitrate);
            }
            if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"x-google-start-bitrate", (boolean)false, (int)2, null)) {
                $this$addGoogleBitrateParams_u24lambda_u245_u24lambda_u244.append(";x-google-start-bitrate=" + $startBitrate);
            }
            charSequence = stringBuilder.toString();
        } else {
            charSequence = line;
        }
        return charSequence;
    }
}

