/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks;

import com.maxim.tacionian.api.energy.ITachyonStorage;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StabilizationPlateBlockEntity
extends BlockEntity
implements ITachyonStorage {
    private int storedEnergy = 0;
    private final int MAX_CAPACITY = 1000;

    public StabilizationPlateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STABILIZER_PLATE_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StabilizationPlateBlockEntity be) {
        if (level.f_46443_ || be.storedEnergy <= 0) {
            return;
        }
        int transferRate = 100;
        for (Direction dir : Direction.values()) {
            if (be.storedEnergy <= 0) break;
            BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
            if (neighbor == null) continue;
            neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_()).ifPresent(cap -> {
                int toPush;
                int accepted;
                if (cap.getEnergy() < cap.getMaxCapacity() && (accepted = cap.receiveTacionEnergy(toPush = Math.min(be.storedEnergy, transferRate), false)) > 0) {
                    be.storedEnergy -= accepted;
                    be.m_6596_();
                }
            });
        }
    }

    @Override
    public int receiveTacionEnergy(int amount, boolean simulate) {
        int canReceive = Math.min(amount, 1000 - this.storedEnergy);
        if (!simulate) {
            this.storedEnergy += canReceive;
            this.m_6596_();
        }
        return canReceive;
    }

    @Override
    public int extractTacionEnergy(int amount, boolean simulate) {
        int canExtract = Math.min(amount, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= canExtract;
            this.m_6596_();
        }
        return canExtract;
    }

    @Override
    public int getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxCapacity() {
        return 1000;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.TACHYON_STORAGE) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }
}

