/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.cable;

import com.maxim.tacionian.blocks.cable.TachyonCableBlockEntity;
import com.maxim.tacionian.register.ModCapabilities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TachyonCableBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light_level", (int)0, (int)3);
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    private static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.NORTH, Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0), Direction.SOUTH, Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0), Direction.WEST, Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0), Direction.EAST, Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Direction.UP, Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Direction.DOWN, Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0));

    public TachyonCableBlock(BlockBehaviour.Properties props) {
        super(props.m_60953_(state -> (Integer)state.m_61143_((Property)LIGHT_LEVEL) * 4));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = CENTER_SHAPE;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.NORTH));
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.SOUTH));
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.EAST));
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.WEST));
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.UP));
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES.get(Direction.DOWN));
        }
        return shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.makeConnections((LevelAccessor)context.m_43725_(), context.m_8083_(), 0);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.makeConnections(level, pos, (Integer)state.m_61143_((Property)LIGHT_LEVEL));
    }

    private BlockState makeConnections(LevelAccessor level, BlockPos pos, int light) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(light > 0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_122012_(), Direction.SOUTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_122019_(), Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_122029_(), Direction.WEST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_122024_(), Direction.EAST)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_7494_(), Direction.DOWN)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(level, pos.m_7495_(), Direction.UP)));
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos neighborPos, Direction side) {
        BlockEntity be = level.m_7702_(neighborPos);
        if (be == null) {
            return false;
        }
        return be.getCapability(ModCapabilities.TACHYON_STORAGE, side).isPresent();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, LIGHT_LEVEL, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TachyonCableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, be) -> {
            if (be instanceof TachyonCableBlockEntity) {
                TachyonCableBlockEntity cable = (TachyonCableBlockEntity)be;
                TachyonCableBlockEntity.tick(lvl, pos, st, cable);
            }
        };
    }
}

