/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.cable;

import com.maxim.tacionian.api.energy.ITachyonStorage;
import com.maxim.tacionian.blocks.cable.TachyonCableBlock;
import com.maxim.tacionian.energy.TachyonEnergyStorage;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TachyonCableBlockEntity
extends BlockEntity
implements ITachyonStorage {
    private final TachyonEnergyStorage energyStorage = new TachyonEnergyStorage(1000, 200, 200);
    private final LazyOptional<ITachyonStorage> holder = LazyOptional.of(() -> this);
    private int lastLightLevel = -1;

    public TachyonCableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CABLE_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TachyonCableBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        if (be.getEnergy() > 0) {
            for (Direction dir : Direction.values()) {
                BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
                if (neighbor == null) continue;
                neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_()).ifPresent(other -> {
                    if (be.getEnergy() > other.getEnergy()) {
                        int diff = be.getEnergy() - other.getEnergy();
                        int toSend = Math.min(be.energyStorage.getMaxExtract(), diff / 2);
                        if (toSend > 0) {
                            int accepted = other.receiveTacionEnergy(toSend, false);
                            be.extractTacionEnergy(accepted, false);
                        }
                    }
                });
            }
        }
        if (level.m_46467_() % 20L == 0L) {
            int targetLight;
            int n = targetLight = be.getEnergy() > 0 ? Math.min(3, be.getEnergy() / 333 + 1) : 0;
            if (be.lastLightLevel != targetLight) {
                be.lastLightLevel = targetLight;
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TachyonCableBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(targetLight))).m_61124_((Property)TachyonCableBlock.POWERED, (Comparable)Boolean.valueOf(targetLight > 0)), 3);
            }
        }
    }

    @Override
    public int receiveTacionEnergy(int amount, boolean simulate) {
        return this.energyStorage.receiveEnergy(amount, simulate);
    }

    @Override
    public int extractTacionEnergy(int amount, boolean simulate) {
        return this.energyStorage.extractEnergy(amount, simulate);
    }

    @Override
    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxCapacity() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.TACHYON_STORAGE) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_("Energy", this.energyStorage.getEnergyStored());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energyStorage.setEnergy(tag.m_128451_("Energy"));
    }
}

