/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.charger;

import com.maxim.tacionian.blocks.charger.TachyonChargerBlockEntity;
import com.maxim.tacionian.blocks.charger.TachyonSafeChargerBlockEntity;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TachyonChargerBlock
extends BaseEntityBlock {
    protected final boolean isSafe;

    public TachyonChargerBlock(BlockBehaviour.Properties props, boolean isSafe) {
        super(props);
        this.isSafe = isSafe;
    }

    public TachyonChargerBlock(BlockBehaviour.Properties props) {
        this(props, false);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.isSafe ? new TachyonSafeChargerBlockEntity(pos, state) : new TachyonChargerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : TachyonChargerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.CHARGER_BE.get()), TachyonChargerBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_ || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TachyonChargerBlockEntity) {
            TachyonChargerBlockEntity charger = (TachyonChargerBlockEntity)be;
            if (player.m_6144_()) {
                charger.handlePlayerExtraction(serverPlayer);
                return InteractionResult.SUCCESS;
            }
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
                int minLimit;
                int n = minLimit = this.isSafe ? (int)((float)pEnergy.getMaxEnergy() * 0.15f) : 0;
                if (pEnergy.getEnergy() > minLimit) {
                    int available;
                    int toTransfer;
                    int canAccept = charger.receiveTacionEnergy(100, true);
                    if (canAccept > 0 && (toTransfer = Math.min(canAccept, available = pEnergy.getEnergy() - minLimit)) > 0) {
                        int taken = pEnergy.extractEnergyPure(toTransfer, false);
                        charger.receiveTacionEnergy(taken, false);
                        pEnergy.addExperience((float)taken * 0.1f, serverPlayer);
                        pEnergy.sync(serverPlayer);
                        level.m_5594_(null, pos, (SoundEvent)ModSounds.ENERGY_CHARGE.get(), SoundSource.BLOCKS, 0.7f, 1.4f);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.tacionian.safety_limit").m_130940_(ChatFormatting.RED), true);
                    level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_12209_.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }
}

