/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.charger;

import com.maxim.tacionian.api.energy.ITachyonStorage;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TachyonChargerBlockEntity
extends BlockEntity
implements ITachyonStorage {
    protected int storedEnergy = 0;
    protected final int MAX_CAPACITY = 5000;
    private final LazyOptional<ITachyonStorage> tachyonHolder = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyStorage> rfHolder = LazyOptional.of(() -> new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int txToExtract = Math.min(TachyonChargerBlockEntity.this.storedEnergy, (int)((float)(maxExtract / 10) / TachyonChargerBlockEntity.this.getEfficiency()));
            if (!simulate && txToExtract > 0) {
                TachyonChargerBlockEntity.this.storedEnergy -= txToExtract;
                TachyonChargerBlockEntity.this.m_6596_();
            }
            return (int)((float)(txToExtract * 10) * TachyonChargerBlockEntity.this.getEfficiency());
        }

        public int getEnergyStored() {
            return (int)((float)(TachyonChargerBlockEntity.this.storedEnergy * 10) * TachyonChargerBlockEntity.this.getEfficiency());
        }

        public int getMaxEnergyStored() {
            return 50000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    });

    public TachyonChargerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CHARGER_BE.get(), pos, state);
    }

    protected float getEfficiency() {
        return 0.9f;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TachyonChargerBlockEntity be) {
        LazyOptional txCap;
        BlockEntity neighbor;
        if (level.f_46443_) {
            return;
        }
        boolean changed = false;
        if (be.storedEnergy < be.MAX_CAPACITY) {
            for (Direction dir : Direction.values()) {
                neighbor = level.m_7702_(pos.m_121945_(dir));
                if (neighbor == null || neighbor instanceof TachyonChargerBlockEntity || !(txCap = neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_())).isPresent()) continue;
                int space = be.MAX_CAPACITY - be.storedEnergy;
                int pulled = ((ITachyonStorage)txCap.orElse(null)).extractTacionEnergy(Math.min(space, 100), false);
                if (pulled <= 0) continue;
                be.storedEnergy += pulled;
                changed = true;
            }
        }
        if (be.storedEnergy <= 0) {
            if (changed) {
                be.m_6596_();
            }
            return;
        }
        for (Direction dir : Direction.values()) {
            float eff;
            int maxRfAvailable;
            int toSendRF;
            int acceptedRF;
            IEnergyStorage storage;
            LazyOptional rfCap;
            if (be.storedEnergy <= 0) break;
            neighbor = level.m_7702_(pos.m_121945_(dir));
            if (neighbor == null || neighbor instanceof TachyonChargerBlockEntity) continue;
            txCap = neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_());
            if (txCap.isPresent()) {
                int toPush = Math.min(be.storedEnergy, 100);
                int accepted = ((ITachyonStorage)txCap.orElse(null)).receiveTacionEnergy(toPush, false);
                if (accepted > 0) {
                    be.storedEnergy -= accepted;
                    changed = true;
                }
            }
            if (be.storedEnergy <= 0 || !(rfCap = neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_())).isPresent() || !(storage = (IEnergyStorage)rfCap.orElse(null)).canReceive() || (acceptedRF = storage.receiveEnergy(toSendRF = Math.min(maxRfAvailable = (int)((float)(be.storedEnergy * 10) * (eff = be.getEfficiency())), 1000), false)) <= 0) continue;
            int txToDrain = (int)Math.ceil((double)acceptedRF / 10.0 / (double)eff);
            be.storedEnergy = Math.max(0, be.storedEnergy - txToDrain);
            changed = true;
        }
        if (changed) {
            be.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    public void handlePlayerExtraction(ServerPlayer player) {
        player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
            int toTransfer = Math.min(this.storedEnergy, 100);
            if (toTransfer > 0) {
                int accepted = pEnergy.receiveEnergyPure(toTransfer, false);
                this.storedEnergy -= accepted;
                this.m_6596_();
                pEnergy.sync(player);
            }
        });
    }

    @Override
    public int receiveTacionEnergy(int amount, boolean simulate) {
        int toReceive = Math.min(amount, 5000 - this.storedEnergy);
        if (!simulate && toReceive > 0) {
            this.storedEnergy += toReceive;
            this.m_6596_();
        }
        return toReceive;
    }

    @Override
    public int extractTacionEnergy(int amount, boolean simulate) {
        int toTake = Math.min(this.storedEnergy, amount);
        if (!simulate && toTake > 0) {
            this.storedEnergy -= toTake;
            this.m_6596_();
        }
        return toTake;
    }

    @Override
    public int getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxCapacity() {
        return 5000;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.TACHYON_STORAGE) {
            return this.tachyonHolder.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.rfHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("energy", this.storedEnergy);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.storedEnergy = nbt.m_128451_("energy");
    }
}

