/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.storage;

import com.maxim.tacionian.api.events.TachyonWasteEvent;
import com.maxim.tacionian.blocks.storage.EnergyReservoirBlockEntity;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class EnergyReservoirBlock
extends BaseEntityBlock {
    public EnergyReservoirBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnergyReservoirBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : EnergyReservoirBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.RESERVOIR_BE.get()), EnergyReservoirBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof EnergyReservoirBlockEntity) {
            EnergyReservoirBlockEntity reservoir = (EnergyReservoirBlockEntity)be;
            if (player.m_21120_(hand).m_41619_() && !player.m_6144_()) {
                player.m_5661_((Component)Component.m_237110_((String)"tooltip.tacionian.energy_reservoir.energy", (Object[])new Object[]{reservoir.getEnergy(), reservoir.getMaxCapacity()}).m_130940_(ChatFormatting.YELLOW), true);
                return InteractionResult.SUCCESS;
            }
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
                int amount = 500;
                boolean actionHappened = false;
                if (player.m_6144_()) {
                    int extracted = reservoir.extractTacionEnergy(amount, false);
                    if (extracted > 0) {
                        pEnergy.receiveEnergyPure(extracted, false);
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7a[<] \u0412\u0438\u0442\u044f\u0433\u043d\u0443\u0442\u043e: " + extracted + " Tx")), true);
                        actionHappened = true;
                    }
                } else {
                    int taken = pEnergy.extractEnergyPure(amount, false);
                    if (taken > 0) {
                        int added = reservoir.receiveTacionEnergy(taken, false);
                        if (added < taken) {
                            pEnergy.receiveEnergyPure(taken - added, false);
                        }
                        player.m_5661_((Component)Component.m_237113_((String)("\u00a7c[>] \u0417\u0430\u043b\u0438\u0442\u043e: " + added + " Tx")), true);
                        actionHappened = true;
                    }
                }
                if (actionHappened) {
                    pEnergy.sync((ServerPlayer)player);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            EnergyReservoirBlockEntity reservoir;
            int leftover;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof EnergyReservoirBlockEntity && (leftover = (reservoir = (EnergyReservoirBlockEntity)be).getEnergy()) > 0 && !level.f_46443_) {
                MinecraftForge.EVENT_BUS.post((Event)new TachyonWasteEvent(level, pos, leftover));
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

