/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.storage;

import com.maxim.tacionian.api.energy.ITachyonStorage;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyReservoirBlockEntity
extends BlockEntity
implements ITachyonStorage {
    private int energy = 0;
    private final int MAX_CAPACITY = 25000;
    private final LazyOptional<ITachyonStorage> holder = LazyOptional.of(() -> this);

    public EnergyReservoirBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.RESERVOIR_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnergyReservoirBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
            if (neighbor == null) continue;
            neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_()).ifPresent(net -> {
                double myFill = (double)be.energy / (double)be.MAX_CAPACITY;
                double netFill = (double)net.getEnergy() / (double)net.getMaxCapacity();
                if (myFill > netFill) {
                    int toPush = Math.min(be.energy, 500);
                    int accepted = net.receiveTacionEnergy(toPush, false);
                    be.extractTacionEnergy(accepted, false);
                } else if (netFill > myFill) {
                    int toPull = Math.min(net.getEnergy(), 500);
                    int taken = net.extractTacionEnergy(toPull, false);
                    be.receiveTacionEnergy(taken, false);
                }
            });
        }
    }

    @Override
    public int receiveTacionEnergy(int amount, boolean simulate) {
        int toAdd = Math.min(amount, 25000 - this.energy);
        if (!simulate && toAdd > 0) {
            this.energy += toAdd;
            this.m_6596_();
        }
        return toAdd;
    }

    @Override
    public int extractTacionEnergy(int amount, boolean simulate) {
        int toTake = Math.min(amount, this.energy);
        if (!simulate && toTake > 0) {
            this.energy -= toTake;
            this.m_6596_();
        }
        return toTake;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxCapacity() {
        return 25000;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.TACHYON_STORAGE) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("Energy", this.energy);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energy = nbt.m_128451_("Energy");
    }
}

