/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.blocks.wireless;

import com.maxim.tacionian.api.energy.ITachyonStorage;
import com.maxim.tacionian.energy.PlayerEnergy;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModBlockEntities;
import com.maxim.tacionian.register.ModCapabilities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WirelessEnergyInterfaceBlockEntity
extends BlockEntity
implements ITachyonStorage {
    private int mode = 0;
    private int storedEnergy = 0;
    private final int MAX_CAPACITY = 2000;
    private final LazyOptional<ITachyonStorage> tachyonHolder = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyStorage> rfHolder = LazyOptional.of(() -> new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int toTakeTx = Math.min(WirelessEnergyInterfaceBlockEntity.this.storedEnergy, maxExtract / 10);
            if (!simulate && toTakeTx > 0) {
                WirelessEnergyInterfaceBlockEntity.this.storedEnergy -= toTakeTx;
                WirelessEnergyInterfaceBlockEntity.this.m_6596_();
            }
            return toTakeTx * 10;
        }

        public int getEnergyStored() {
            return WirelessEnergyInterfaceBlockEntity.this.storedEnergy * 10;
        }

        public int getMaxEnergyStored() {
            return 20000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    });

    public WirelessEnergyInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WIRELESS_BE.get(), pos, state);
    }

    public void cycleMode(Player player) {
        this.mode = (this.mode + 1) % 4;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            player.m_5661_((Component)Component.m_237110_((String)"message.tacionian.mode_switched", (Object[])new Object[]{this.getModeName()}), true);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public Component getModeName() {
        return switch (this.mode) {
            case 0 -> Component.m_237115_((String)"mode.tacionian.safe");
            case 1 -> Component.m_237115_((String)"mode.tacionian.balanced");
            case 2 -> Component.m_237115_((String)"mode.tacionian.performance");
            default -> Component.m_237115_((String)"mode.tacionian.unrestricted");
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WirelessEnergyInterfaceBlockEntity be) {
        if (level.f_46443_) {
            return;
        }
        ServerPlayer closestPlayer = (ServerPlayer)level.m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 20.0, true);
        be.processEnergyTransfer(level, pos, closestPlayer);
        AABB area = new AABB(pos).m_82400_(20.0);
        List players = level.m_45976_(Player.class, area);
        int threshold = switch (be.mode) {
            case 0 -> 75;
            case 1 -> 40;
            case 2 -> 15;
            default -> 0;
        };
        boolean changed = false;
        for (Player player : players) {
            ServerPlayer serverPlayer;
            LazyOptional cap;
            if (!(player instanceof ServerPlayer) || !(cap = (serverPlayer = (ServerPlayer)player).getCapability(PlayerEnergyProvider.PLAYER_ENERGY)).isPresent()) continue;
            PlayerEnergy pEnergy = (PlayerEnergy)cap.orElse(null);
            pEnergy.setRemoteStabilized(true);
            if (pEnergy.getEnergyPercent() > threshold || pEnergy.isOverloaded()) {
                int toExtract = 50;
                int extracted = pEnergy.extractEnergyPure(toExtract, false);
                int accepted = be.receiveFromPlayer(extracted, false);
                if (accepted < extracted) {
                    pEnergy.addExperience((float)(extracted - accepted) * 0.02f, serverPlayer);
                }
                changed = true;
            }
            if (level.m_46467_() % 10L != 0L) continue;
            pEnergy.sync(serverPlayer);
        }
        if (changed) {
            be.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private void processEnergyTransfer(Level level, BlockPos pos, @Nullable ServerPlayer player) {
        if (this.storedEnergy <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            if (this.storedEnergy <= 0) break;
            BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
            if (neighbor == null || neighbor instanceof WirelessEnergyInterfaceBlockEntity) continue;
            neighbor.getCapability(ModCapabilities.TACHYON_STORAGE, dir.m_122424_()).ifPresent(txCap -> {
                int accepted = txCap.receiveTacionEnergy(Math.min(this.storedEnergy, 100), false);
                if (accepted > 0) {
                    this.extractTacionEnergy(accepted, false);
                }
            });
            if (this.storedEnergy <= 0) continue;
            neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(rfCap -> {
                int acceptedRF;
                int usedTx;
                if (rfCap.canReceive() && (usedTx = (int)Math.ceil((double)(acceptedRF = rfCap.receiveEnergy(Math.min(this.storedEnergy * 10, 1000), false)) / 10.0)) > 0) {
                    this.extractTacionEnergy(usedTx, false);
                    if (player != null) {
                        player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(e -> e.addExperience((float)usedTx * 0.15f, player));
                    }
                }
            });
        }
    }

    public int receiveFromPlayer(int amount, boolean simulate) {
        int space = 2000 - this.storedEnergy;
        int toAdd = Math.min(amount, space);
        if (!simulate && toAdd > 0) {
            this.storedEnergy += toAdd;
            this.m_6596_();
        }
        return toAdd;
    }

    @Override
    public int receiveTacionEnergy(int amount, boolean simulate) {
        return 0;
    }

    @Override
    public int extractTacionEnergy(int amount, boolean simulate) {
        int toTake = Math.min(this.storedEnergy, amount);
        if (!simulate && toTake > 0) {
            this.storedEnergy -= toTake;
            this.m_6596_();
        }
        return toTake;
    }

    @Override
    public int getEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxCapacity() {
        return 2000;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.TACHYON_STORAGE) {
            return this.tachyonHolder.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.rfHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("StoredEnergy", this.storedEnergy);
        nbt.m_128405_("Mode", this.mode);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.storedEnergy = nbt.m_128451_("StoredEnergy");
        this.mode = nbt.m_128451_("Mode");
    }
}

