/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.client.hud;

import com.maxim.tacionian.api.effects.ITachyonEffect;
import com.maxim.tacionian.client.hud.EnergyColorHelper;
import com.maxim.tacionian.energy.ClientPlayerEnergy;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class EnergyHudOverlay {
    public static final IGuiOverlay HUD = (gui, graphics, partialTick, width, height) -> {
        int scanPos;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || mc.f_91074_.m_5833_()) {
            return;
        }
        if (!ClientPlayerEnergy.hasData()) {
            return;
        }
        int x = 15;
        int y = 20;
        int barWidth = 140;
        int barHeight = 10;
        float gameTime = (float)mc.f_91073_.m_46467_() + partialTick;
        graphics.m_280168_().m_85836_();
        float shake = EnergyColorHelper.getShakeAmplitude();
        if (shake > 0.0f) {
            graphics.m_280168_().m_252880_((mc.f_91073_.f_46441_.m_188501_() - 0.5f) * shake, (mc.f_91073_.f_46441_.m_188501_() - 0.5f) * shake, 0.0f);
        }
        int baseColor = EnergyColorHelper.getColor();
        graphics.m_280056_(mc.f_91062_, "LVL " + ClientPlayerEnergy.getLevel(), x, y - 11, 64511, true);
        String energyInfo = ClientPlayerEnergy.getEnergy() + " / " + ClientPlayerEnergy.getMaxEnergy() + " Tx";
        graphics.m_280056_(mc.f_91062_, energyInfo, x + barWidth - mc.f_91062_.m_92895_(energyInfo), y - 11, 0xFFFFFF, true);
        graphics.m_280509_(x - 1, y - 1, x + barWidth + 1, y + barHeight + 1, -13290187);
        graphics.m_280509_(x, y, x + barWidth, y + barHeight, -16448251);
        float ratio = Math.min(ClientPlayerEnergy.getRatio(), 1.0f);
        int fillWidth = (int)((float)barWidth * ratio);
        if (fillWidth > 0) {
            graphics.m_280024_(x, y, x + fillWidth, y + barHeight, baseColor, EnergyHudOverlay.darkenColor(baseColor, 0.6f));
            graphics.m_280509_(x, y, x + fillWidth, y + 1, 0x44FFFFFF);
        }
        if ((ClientPlayerEnergy.isStabilized() || ClientPlayerEnergy.isRemoteStabilized()) && fillWidth > 5 && (scanPos = (int)((double)gameTime * 3.0 % (double)barWidth)) < fillWidth) {
            graphics.m_280509_(x + scanPos, y, Math.min(x + scanPos + 10, x + fillWidth), y + barHeight, 0x33FFFFFF);
        }
        int xpY = y + barHeight + 3;
        int xpHeight = 1;
        float xpRatio = (float)ClientPlayerEnergy.getExperience() / (float)ClientPlayerEnergy.getRequiredExp();
        graphics.m_280509_(x, xpY, x + barWidth, xpY + xpHeight, 0x44000000);
        int xpFillWidth = (int)((float)barWidth * Math.min(xpRatio, 1.0f));
        if (xpFillWidth > 0) {
            graphics.m_280509_(x, xpY, x + xpFillWidth, xpY + xpHeight, -10496);
        }
        int iconX = x;
        int iconY = xpY + xpHeight + 4;
        for (MobEffectInstance effect : mc.f_91074_.m_21220_()) {
            ITachyonEffect tachyonEffect;
            MobEffect patt3024$temp = effect.m_19544_();
            if (!(patt3024$temp instanceof ITachyonEffect) || !(tachyonEffect = (ITachyonEffect)patt3024$temp).shouldShowInHud()) continue;
            graphics.m_280509_(iconX, iconY, iconX + 6, iconY + 6, tachyonEffect.getIconColor());
            iconX += 8;
        }
        graphics.m_280168_().m_85849_();
    };

    private static int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((float)(color >> 16 & 0xFF) * factor);
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

