/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.command;

import com.maxim.tacionian.config.TacionianConfig;
import com.maxim.tacionian.energy.PlayerEnergy;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.network.EnergySyncPacket;
import com.maxim.tacionian.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class EnergyCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tachyon").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"energy").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyCommand.setEnergy((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyCommand.addEnergy((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(Commands.m_82127_((String)"jam").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> EnergyCommand.jamPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), BoolArgumentType.getBool((CommandContext)context, (String)"enabled"))))))).then(Commands.m_82127_((String)"level").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)((Integer)TacionianConfig.MAX_LEVEL.get()))).executes(context -> EnergyCommand.setLevel((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"exp").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyCommand.addExp((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyCommand.setExp((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> EnergyCommand.resetStats((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"))))));
    }

    private static int addEnergy(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.receiveEnergyPure(amount, false);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0414\u043e\u0434\u0430\u043d\u043e \u00a7f" + amount + " \u00a77\u0435\u043d\u0435\u0440\u0433\u0456\u0457.")), true);
        return targets.size();
    }

    private static int jamPlayer(CommandSourceStack source, Collection<ServerPlayer> targets, boolean enabled) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setPermanentJam(enabled);
                EnergyCommand.sync(player, energy);
            });
        }
        String status = enabled ? "\u00a7c\u0411\u041b\u041e\u041a\u041e\u0412\u0410\u041d\u041e" : "\u00a7a\u0412\u0406\u0414\u041d\u041e\u0412\u041b\u0415\u041d\u041e";
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0417\u0432'\u044f\u0437\u043e\u043a \u0437 \u043c\u0435\u0440\u0435\u0436\u0435\u044e: " + status)), true);
        return targets.size();
    }

    private static int setLevel(CommandSourceStack source, Collection<ServerPlayer> targets, int level) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setLevel(level);
                energy.setExperience(0);
                energy.setEnergy(energy.getMaxEnergy() / 2);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0420\u0456\u0432\u0435\u043d\u044c \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u00a76" + level)), true);
        return targets.size();
    }

    private static int setEnergy(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) {
        for (ServerPlayer player : targets) {
            player.getCapability(ServerPlayer.class.equals(player.getClass()) ? PlayerEnergyProvider.PLAYER_ENERGY : PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setEnergy(amount);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0415\u043d\u0435\u0440\u0433\u0456\u044e \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u00a7f" + amount)), true);
        return targets.size();
    }

    private static int addExp(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.addExperience(amount, player);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0414\u043e\u0434\u0430\u043d\u043e \u00a7e" + amount + " \u00a77\u0434\u043e\u0441\u0432\u0456\u0434\u0443.")), true);
        return targets.size();
    }

    private static int setExp(CommandSourceStack source, Collection<ServerPlayer> targets, int amount) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setExperience(amount);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7b[Tacionian] \u00a77\u0414\u043e\u0441\u0432\u0456\u0434 \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u043d\u0430 \u00a7e" + amount)), true);
        return targets.size();
    }

    private static int resetStats(CommandSourceStack source, Collection<ServerPlayer> targets) {
        for (ServerPlayer player : targets) {
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setEnergy(0);
                energy.setLevel(1);
                energy.setExperience(0);
                EnergyCommand.sync(player, energy);
            });
        }
        source.m_288197_(() -> Component.m_237113_((String)"\u00a7b[Tacionian] \u00a77\u0412\u0441\u0456 \u043f\u043e\u043a\u0430\u0437\u043d\u0438\u043a\u0438 \u0441\u043a\u0438\u043d\u0443\u0442\u043e."), true);
        return targets.size();
    }

    private static void sync(ServerPlayer player, PlayerEnergy energy) {
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnergySyncPacket(energy));
    }
}

