/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.energy;

import com.maxim.tacionian.config.TacionianConfig;
import com.maxim.tacionian.energy.PlayerEnergyEffects;
import com.maxim.tacionian.network.EnergySyncPacket;
import com.maxim.tacionian.network.NetworkHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class PlayerEnergy {
    private int energy = 0;
    private int level = 1;
    private int experience = 0;
    private float fractionalExperience = 0.0f;
    private int customColor = -1;
    private int stabilizedTimer = 0;
    private int remoteStabilizedTimer = 0;
    private int remoteNoDrainTimer = 0;
    private float capacityMultiplier = 1.0f;
    private float regenMultiplier = 1.0f;
    private int flatCapacityBonus = 0;
    private boolean connectionBlocked = false;
    private boolean permanentJam = false;

    public void setEnergy(int amount) {
        this.energy = Math.max(0, amount);
    }

    public void setLevel(int level) {
        this.level = Math.min(Math.max(1, level), (Integer)TacionianConfig.MAX_LEVEL.get());
    }

    public void setExperience(int experience) {
        this.experience = Math.max(0, experience);
    }

    public void setFractionalExperience(float f) {
        this.fractionalExperience = f;
    }

    public void setPermanentJam(boolean enabled) {
        this.permanentJam = enabled;
    }

    public void setCustomColor(int color) {
        this.customColor = color;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExperience() {
        return this.experience;
    }

    public int getCustomColor() {
        return this.customColor;
    }

    public int getEnergyPercent() {
        return (int)(this.getEnergyFraction() * 100.0f);
    }

    public int getMaxEnergy() {
        int base = 1000 + (this.level - 1) * (Integer)TacionianConfig.ENERGY_PER_LEVEL.get();
        return (int)((float)(base + this.flatCapacityBonus) * this.capacityMultiplier);
    }

    public int getRequiredExp() {
        return this.level < 20 ? 500 + this.level * 100 : 2500 + this.level * 250;
    }

    public int getRegenRate() {
        return (int)((double)((float)((Integer)TacionianConfig.BASE_REGEN.get()).intValue() * this.regenMultiplier) + (double)this.level * 2.0);
    }

    public float getEnergyFraction() {
        return this.getMaxEnergy() > 0 ? (float)this.energy / (float)this.getMaxEnergy() : 0.0f;
    }

    public boolean isOverloaded() {
        float threshold = this.level <= 5 ? 0.95f : 0.8f;
        return this.getEnergyFraction() >= threshold;
    }

    public boolean isCriticalOverload() {
        return this.getEnergyFraction() >= 0.95f;
    }

    public boolean isCriticalLow() {
        return this.getEnergyFraction() < 0.05f;
    }

    public boolean isConnectionBlocked() {
        return this.connectionBlocked || this.permanentJam;
    }

    public int receiveEnergyPure(int amount, boolean simulate) {
        int space = Math.max(0, this.getMaxEnergy() - this.energy);
        int toAdd = Math.min(amount, space);
        if (!simulate) {
            this.energy += toAdd;
        }
        return toAdd;
    }

    public int extractEnergyPure(int amount, boolean simulate) {
        int toExt = Math.min(amount, this.energy);
        if (!simulate) {
            this.energy -= toExt;
        }
        return toExt;
    }

    public int extractEnergyWithExp(int amount, boolean simulate, ServerPlayer player) {
        int toExt = Math.min(amount, this.energy);
        if (!simulate && toExt > 0) {
            this.energy -= toExt;
            this.addExperience((float)toExt * ((Double)TacionianConfig.EXP_MULTIPLIER.get()).floatValue(), player);
        }
        return toExt;
    }

    public void addExperience(float amount, ServerPlayer player) {
        if (amount <= 0.0f || this.level >= (Integer)TacionianConfig.MAX_LEVEL.get()) {
            return;
        }
        this.fractionalExperience += amount;
        if (this.fractionalExperience >= 1.0f) {
            int wholeExp = (int)this.fractionalExperience;
            this.experience += wholeExp;
            this.fractionalExperience -= (float)wholeExp;
            while (this.experience >= this.getRequiredExp() && this.level < (Integer)TacionianConfig.MAX_LEVEL.get()) {
                this.experience -= this.getRequiredExp();
                ++this.level;
                if (player == null) continue;
                player.m_213846_((Component)Component.m_237110_((String)"message.tacionian.level_up", (Object[])new Object[]{this.level}).m_130940_(ChatFormatting.AQUA));
            }
            if (player != null) {
                this.sync(player);
            }
        }
    }

    public void sync(ServerPlayer player) {
        if (player != null && !player.m_9236_().f_46443_) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnergySyncPacket(this));
        }
    }

    public void tick(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.capacityMultiplier = 1.0f;
        this.regenMultiplier = 1.0f;
        this.flatCapacityBonus = 0;
        this.connectionBlocked = false;
        this.customColor = -1;
        MinecraftForge.EVENT_BUS.post((Event)new TachyonEnergyUpdateEvent(player, this));
        if (this.stabilizedTimer > 0) {
            --this.stabilizedTimer;
        }
        if (this.remoteStabilizedTimer > 0) {
            --this.remoteStabilizedTimer;
        }
        if (this.remoteNoDrainTimer > 0) {
            --this.remoteNoDrainTimer;
        }
        if (this.getEnergy() >= this.getMaxEnergy() && !this.isStabilized() && !this.isRemoteStabilized()) {
            player.m_9236_().m_255391_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), 5.0f, true, Level.ExplosionInteraction.BLOCK);
            player.m_6469_(player.m_269291_().m_269264_(), Float.MAX_VALUE);
            this.energy = 0;
            this.sync(serverPlayer);
            return;
        }
        if (!this.permanentJam && !this.isRemoteNoDrain() && player.f_19797_ % 20 == 0) {
            int regenTarget;
            int n = regenTarget = this.level < 5 ? (int)((float)this.getMaxEnergy() * 0.9f) : this.getMaxEnergy();
            if (this.energy < regenTarget) {
                this.receiveEnergyPure(this.getRegenRate(), false);
                this.sync(serverPlayer);
            }
        }
        PlayerEnergyEffects.apply(serverPlayer, this);
    }

    public void setStabilized(boolean v) {
        if (v) {
            this.stabilizedTimer = 20;
        }
    }

    public boolean isStabilized() {
        return this.stabilizedTimer > 0;
    }

    public void setRemoteStabilized(boolean v) {
        if (v) {
            this.remoteStabilizedTimer = 20;
        }
    }

    public boolean isRemoteStabilized() {
        return this.remoteStabilizedTimer > 0;
    }

    public void setRemoteNoDrain(boolean v) {
        if (v) {
            this.remoteNoDrainTimer = 20;
        }
    }

    public boolean isRemoteNoDrain() {
        return this.remoteNoDrainTimer > 0;
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_("energy", this.energy);
        nbt.m_128405_("level", this.level);
        nbt.m_128405_("exp", this.experience);
        nbt.m_128379_("jammed", this.permanentJam);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.energy = nbt.m_128451_("energy");
        this.level = Math.max(1, nbt.m_128451_("level"));
        this.experience = nbt.m_128451_("exp");
        this.permanentJam = nbt.m_128471_("jammed");
    }

    public static class TachyonEnergyUpdateEvent
    extends Event {
        public final Player player;
        public final PlayerEnergy energy;

        public TachyonEnergyUpdateEvent(Player p, PlayerEnergy e) {
            this.player = p;
            this.energy = e;
        }
    }
}

