/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.energy;

import com.maxim.tacionian.energy.PlayerEnergy;
import com.maxim.tacionian.register.ModSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class PlayerEnergyEffects {
    public static final ResourceKey<DamageType> TACHYON_DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("tacionian", "energy"));

    public static DamageSource getTachyonDamage(ServerPlayer player) {
        return new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(TACHYON_DAMAGE_TYPE));
    }

    public static void apply(ServerPlayer player, PlayerEnergy energy) {
        boolean isProtected;
        ServerLevel level = player.m_284548_();
        int percent = energy.getEnergyPercent();
        boolean bl = isProtected = energy.isStabilized() || energy.isRemoteStabilized();
        if (energy.isOverloaded()) {
            int soundInterval = Math.max(2, 25 - (percent - 80));
            if (player.f_19797_ % soundInterval == 0) {
                float pitch = 0.5f + (float)percent / 100.0f;
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.TACHYON_HUM.get(), SoundSource.PLAYERS, 0.5f, pitch);
            }
            if (!isProtected) {
                if (percent > 85 && player.f_19797_ % 5 == 0) {
                    player.m_5997_(((double)level.f_46441_.m_188501_() - 0.5) * 0.15, 0.0, ((double)level.f_46441_.m_188501_() - 0.5) * 0.15);
                    player.f_19864_ = true;
                }
                if (percent > 90 && player.f_19797_ % 20 == 0) {
                    player.m_6469_(PlayerEnergyEffects.getTachyonDamage(player), 1.0f);
                    player.m_20254_(2);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                }
            }
            int particleCount = (percent - 70) / 5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, player.m_20185_(), player.m_20186_() + 1.2, player.m_20189_(), particleCount, 0.3, 0.5, 0.3, 0.05);
        }
        if (energy.isCriticalLow() && player.f_19797_ % 80 == 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 60, 0));
        }
    }
}

