/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.events;

import com.maxim.tacionian.energy.PlayerEnergyEffects;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.energy.control.EnergyControlResolver;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tacionian")
public class ModEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerEnergyProvider.PLAYER_ENERGY).isPresent()) {
            event.addCapability(new ResourceLocation("tacionian", "properties"), (ICapabilityProvider)new PlayerEnergyProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(oldStore -> event.getEntity().getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(newStore -> {
            CompoundTag nbt = new CompoundTag();
            oldStore.saveNBTData(nbt);
            newStore.loadNBTData(nbt);
            if (event.isWasDeath()) {
                newStore.setEnergy(0);
                newStore.setRemoteStabilized(false);
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> energy.sync(player2));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                energy.setEnergy(0);
                energy.sync(player2);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            DamageSource source = event.getSource();
            if (source.m_276093_(PlayerEnergyEffects.TACHYON_DAMAGE_TYPE)) {
                ServerLevel level = player.m_284548_();
                double x = player.m_20185_();
                double y = player.m_20186_() + 1.0;
                double z = player.m_20189_();
                level.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                level.m_8767_((ParticleOptions)ParticleTypes.f_235902_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 40, 0.2, 0.5, 0.2, 0.5);
                level.m_6263_(null, x, y, z, SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 0.5f);
                level.m_6263_(null, x, y, z, SoundEvents.f_11738_, SoundSource.PLAYERS, 1.5f, 0.1f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.f_19797_ < 60) {
                return;
            }
            player2.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(energy -> {
                EnergyControlResolver.resolve(player2, energy);
                energy.tick((Player)player2);
                PlayerEnergyEffects.apply(player2, energy);
                if (player2.m_9236_().m_46467_() % 5L == 0L) {
                    energy.sync(player2);
                }
            });
        }
    }
}

