/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.items.charger;

import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModCapabilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class BasicChargerItem
extends Item {
    public BasicChargerItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (level.f_46443_ || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        serverPlayer.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
            int[] availableTx = new int[]{pEnergy.getEnergy()};
            if (availableTx[0] <= 0) {
                return;
            }
            boolean changed = false;
            for (ItemStack target : serverPlayer.m_150109_().f_35974_) {
                int taken;
                int taken2;
                if (target.m_41619_() || target == stack) continue;
                LazyOptional txCapOpt = target.getCapability(ModCapabilities.TACHYON_STORAGE);
                if (txCapOpt.isPresent() && (taken2 = txCapOpt.map(cap -> {
                    int needed = cap.getMaxCapacity() - cap.getEnergy();
                    int toGive = Math.min(availableTx[0], Math.min(needed, 10));
                    int extracted = pEnergy.extractEnergyWithExp(toGive, false, serverPlayer);
                    return cap.receiveTacionEnergy(extracted, false);
                }).orElse(0).intValue()) > 0) {
                    changed = true;
                    availableTx[0] = availableTx[0] - taken2;
                    if (availableTx[0] > 0) continue;
                    break;
                }
                LazyOptional rfCapOpt = target.getCapability(ForgeCapabilities.ENERGY);
                if (!rfCapOpt.isPresent() || (taken = rfCapOpt.map(cap -> {
                    if (!cap.canReceive()) {
                        return 0;
                    }
                    int neededRF = Math.min(cap.receiveEnergy(100, true), availableTx[0] * 10);
                    if (neededRF > 0) {
                        int txToTake = (neededRF + 9) / 10;
                        int extracted = pEnergy.extractEnergyWithExp(txToTake, false, serverPlayer);
                        return cap.receiveEnergy(extracted * 10, false);
                    }
                    return 0;
                }).orElse(0).intValue()) <= 0) continue;
                changed = true;
                availableTx[0] = availableTx[0] - taken / 10;
                if (availableTx[0] > 0) continue;
                break;
            }
            if (changed) {
                pEnergy.sync(serverPlayer);
                if (level.m_46467_() % 10L == 0L && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, serverPlayer.m_20185_(), serverPlayer.m_20186_() + 1.0, serverPlayer.m_20189_(), 2, 0.3, 0.3, 0.3, 0.05);
                }
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.basic_charger_item.desc").m_130940_(ChatFormatting.GRAY));
    }
}

