/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.items.charger;

import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModCapabilities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class SafeChargerItem
extends Item {
    public SafeChargerItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            boolean active = !stack.m_41784_().m_128471_("Active");
            stack.m_41784_().m_128379_("Active", active);
            player.m_5661_((Component)Component.m_237115_((String)(active ? "tooltip.tacionian.active" : "tooltip.tacionian.inactive")), true);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level.f_46443_ || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (!stack.m_41784_().m_128471_("Active")) {
            return;
        }
        if (level.m_46467_() % 5L == 0L) {
            serverPlayer.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
                int minEnergy = (int)((float)pEnergy.getMaxEnergy() * 0.15f);
                int[] availableTx = new int[]{pEnergy.getEnergy() - minEnergy};
                if (availableTx[0] <= 0) {
                    return;
                }
                boolean changed = false;
                for (ItemStack target : serverPlayer.m_150109_().f_35974_) {
                    int taken;
                    int taken2;
                    if (target.m_41619_() || target == stack) continue;
                    LazyOptional txCap = target.getCapability(ModCapabilities.TACHYON_STORAGE);
                    if (txCap.isPresent() && (taken2 = txCap.map(cap -> {
                        int needed = cap.getMaxCapacity() - cap.getEnergy();
                        int toGive = Math.min(availableTx[0], Math.min(needed, 50));
                        int extracted = pEnergy.extractEnergyWithExp(toGive, false, serverPlayer);
                        return cap.receiveTacionEnergy(extracted, false);
                    }).orElse(0).intValue()) > 0) {
                        changed = true;
                        availableTx[0] = availableTx[0] - taken2;
                        if (availableTx[0] > 0) continue;
                        break;
                    }
                    LazyOptional rfCap = target.getCapability(ForgeCapabilities.ENERGY);
                    if (!rfCap.isPresent() || (taken = rfCap.map(cap -> {
                        if (!cap.canReceive()) {
                            return 0;
                        }
                        int neededRF = Math.min(cap.receiveEnergy(500, true), availableTx[0] * 10);
                        if (neededRF > 0) {
                            int txToTake = (neededRF + 9) / 10;
                            int extracted = pEnergy.extractEnergyWithExp(txToTake, false, serverPlayer);
                            return cap.receiveEnergy(extracted * 10, false);
                        }
                        return 0;
                    }).orElse(0).intValue()) <= 0) continue;
                    changed = true;
                    availableTx[0] = availableTx[0] - taken / 10;
                    if (availableTx[0] > 0) continue;
                    break;
                }
                if (changed) {
                    pEnergy.sync(serverPlayer);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123749_, serverPlayer.m_20185_(), serverPlayer.m_20186_() + 1.2, serverPlayer.m_20189_(), 1, 0.2, 0.2, 0.2, 0.02);
                    }
                }
            });
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128471_("Active");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean active = stack.m_41784_().m_128471_("Active");
        tooltip.add((Component)Component.m_237115_((String)"item.tacionian.safe_charger_item").m_130940_(ChatFormatting.GOLD));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.safe_charger_item.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)(active ? "tooltip.tacionian.active" : "tooltip.tacionian.inactive")).m_130940_(active ? ChatFormatting.GREEN : ChatFormatting.RED));
    }
}

