/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.items.energy;

import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModCapabilities;
import com.maxim.tacionian.register.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class EnergyCellItem
extends Item {
    private static final int MAX_ENERGY = 3000;

    public EnergyCellItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockEntity be = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (be != null) {
            return be.getCapability(ModCapabilities.TACHYON_STORAGE, context.m_43719_()).map(storage -> {
                CompoundTag nbt = stack.m_41784_();
                int currentEnergy = nbt.m_128451_("energy");
                if (player != null && player.m_6144_()) {
                    int toGive = storage.receiveTacionEnergy(currentEnergy, false);
                    nbt.m_128405_("energy", currentEnergy - toGive);
                    player.m_5661_((Component)Component.m_237110_((String)"message.tacionian.discharged", (Object[])new Object[]{toGive}).m_130940_(ChatFormatting.RED), true);
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.ENERGY_CHARGE.get(), SoundSource.BLOCKS, 0.6f, 0.8f);
                } else {
                    int space = 3000 - currentEnergy;
                    int toTake = storage.extractTacionEnergy(space, false);
                    nbt.m_128405_("energy", currentEnergy + toTake);
                    if (player != null) {
                        player.m_5661_((Component)Component.m_237110_((String)"message.tacionian.charged", (Object[])new Object[]{toTake}).m_130940_(ChatFormatting.GREEN), true);
                        level.m_5594_(null, pos, (SoundEvent)ModSounds.ENERGY_CHARGE.get(), SoundSource.BLOCKS, 0.6f, 1.2f);
                    }
                }
                return InteractionResult.CONSUME;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        serverPlayer.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
            CompoundTag nbt = stack.m_41784_();
            int stored = nbt.m_128451_("energy");
            int step = 100;
            if (serverPlayer.m_6144_()) {
                int toGive = Math.min(Math.min(stored, step), pEnergy.getMaxEnergy() - pEnergy.getEnergy());
                if (toGive > 0) {
                    pEnergy.receiveEnergyPure(toGive, false);
                    nbt.m_128405_("energy", stored - toGive);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MODE_SWITCH.get(), SoundSource.PLAYERS, 0.3f, 1.1f);
                }
            } else {
                int spaceInCell = 3000 - stored;
                int toTake = Math.min(Math.min(pEnergy.getEnergy(), step), spaceInCell);
                if (toTake > 0) {
                    pEnergy.extractEnergyPure(toTake, false);
                    nbt.m_128405_("energy", stored + toTake);
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MODE_SWITCH.get(), SoundSource.PLAYERS, 0.3f, 0.9f);
                }
            }
            pEnergy.sync(serverPlayer);
        });
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int energy = stack.m_41782_() ? stack.m_41783_().m_128451_("energy") : 0;
        return Math.round((float)energy * 13.0f / 3000.0f);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.55f, (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int energy = stack.m_41782_() ? stack.m_41783_().m_128451_("energy") : 0;
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tacionian.energy_cell.charge", (Object[])new Object[]{energy, 3000}).m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.energy_cell.block_hint").m_130940_(ChatFormatting.GRAY));
    }
}

