/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.items.energy;

import com.maxim.tacionian.api.events.TachyonWasteEvent;
import com.maxim.tacionian.energy.PlayerEnergyProvider;
import com.maxim.tacionian.register.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class EnergyStabilizerItem
extends Item {
    public EnergyStabilizerItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            int mode = (stack.m_41784_().m_128451_("Mode") + 1) % 4;
            stack.m_41784_().m_128405_("Mode", mode);
            level.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.MODE_SWITCH.get(), SoundSource.PLAYERS, 0.5f, 0.8f + (float)mode * 0.2f);
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"message.tacionian.mode_switched", (Object[])new Object[]{this.getModeName(mode)}), true);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.getCapability(PlayerEnergyProvider.PLAYER_ENERGY).ifPresent(pEnergy -> {
                int mode = stack.m_41784_().m_128451_("Mode");
                int threshold = this.getThresholdForMode(mode);
                if (pEnergy.getEnergyPercent() > threshold) {
                    int extracted = pEnergy.extractEnergyPure(50, false);
                    if (extracted > 0) {
                        if (count % 10 == 0) {
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.TACHYON_HUM.get(), SoundSource.PLAYERS, 0.2f, 1.5f);
                        }
                        MinecraftForge.EVENT_BUS.post((Event)new TachyonWasteEvent(level, player.m_20183_(), extracted));
                    }
                    if (count % 5 == 0) {
                        pEnergy.sync(player);
                    }
                }
            });
        }
    }

    private int getThresholdForMode(int mode) {
        return switch (mode) {
            case 0 -> 75;
            case 1 -> 40;
            case 2 -> 15;
            default -> 0;
        };
    }

    private Component getModeName(int mode) {
        return switch (mode) {
            case 0 -> Component.m_237115_((String)"mode.tacionian.safe");
            case 1 -> Component.m_237115_((String)"mode.tacionian.balanced");
            case 2 -> Component.m_237115_((String)"mode.tacionian.performance");
            default -> Component.m_237115_((String)"mode.tacionian.unrestricted");
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int mode = stack.m_41784_().m_128451_("Mode");
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.energy_stabilizer.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.energy_stabilizer.mode").m_7220_(this.getModeName(mode)).m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.tacionian.energy_stabilizer.use_info").m_130940_(ChatFormatting.YELLOW));
    }

    public int m_8105_(ItemStack s) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack s) {
        return UseAnim.BOW;
    }
}

