/*
 * Decompiled with CFR 0.152.
 */
package com.maxim.tacionian.network;

import com.maxim.tacionian.energy.ClientPlayerEnergy;
import com.maxim.tacionian.energy.PlayerEnergy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class EnergySyncPacket {
    private final int energy;
    private final int level;
    private final int experience;
    private final int maxEnergy;
    private final int requiredExp;
    private final int customColor;
    private final boolean stabilized;
    private final boolean remoteStabilized;
    private final boolean remoteNoDrain;
    private final boolean jammed;

    public EnergySyncPacket(PlayerEnergy storage) {
        this.energy = storage.getEnergy();
        this.level = storage.getLevel();
        this.experience = storage.getExperience();
        this.maxEnergy = storage.getMaxEnergy();
        this.requiredExp = storage.getRequiredExp();
        this.customColor = storage.getCustomColor();
        this.stabilized = storage.isStabilized();
        this.remoteStabilized = storage.isRemoteStabilized();
        this.remoteNoDrain = storage.isRemoteNoDrain();
        this.jammed = storage.isConnectionBlocked();
    }

    public EnergySyncPacket(int energy, int level, int experience, int maxEnergy, int requiredExp, boolean stabilized, boolean remoteStabilized, boolean remoteNoDrain, boolean jammed, int customColor) {
        this.energy = energy;
        this.level = level;
        this.experience = experience;
        this.maxEnergy = maxEnergy;
        this.requiredExp = requiredExp;
        this.stabilized = stabilized;
        this.remoteStabilized = remoteStabilized;
        this.remoteNoDrain = remoteNoDrain;
        this.jammed = jammed;
        this.customColor = customColor;
    }

    public static void encode(EnergySyncPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.energy);
        buf.writeInt(msg.level);
        buf.writeInt(msg.experience);
        buf.writeInt(msg.maxEnergy);
        buf.writeInt(msg.requiredExp);
        buf.writeBoolean(msg.stabilized);
        buf.writeBoolean(msg.remoteStabilized);
        buf.writeBoolean(msg.remoteNoDrain);
        buf.writeBoolean(msg.jammed);
        buf.writeInt(msg.customColor);
    }

    public static EnergySyncPacket decode(FriendlyByteBuf buf) {
        return new EnergySyncPacket(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readInt());
    }

    public static void handle(EnergySyncPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientPlayerEnergy.receiveSync(msg.energy, msg.level, msg.experience, msg.maxEnergy, msg.requiredExp, msg.stabilized, msg.remoteStabilized, msg.remoteNoDrain, msg.jammed, msg.customColor));
        ctx.get().setPacketHandled(true);
    }
}

