/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.block.charger;

import com.maxwell.cyber_ware_port.api.event.CyberwareEvents;
import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.init.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends BlockEntity {
    private boolean isDrainMode = false;
    private final CustomEnergyStorage energyStorage = new CustomEnergyStorage(1000000, 10000);
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);

    public ChargerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CHARGER.get(), pPos, pBlockState);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            return;
        }
        this.handlePlayerEnergyTransfer(level, pos);
        if (this.isDrainMode && this.energyStorage.getEnergyStored() > 0) {
            this.distributeEnergy(level, pos);
        }
    }

    private void handlePlayerEnergyTransfer(Level level, BlockPos pos) {
        AABB area = new AABB(pos).m_82386_(0.0, 0.0, 0.0).m_82363_(0.0, 0.5, 0.0);
        List players = level.m_45976_(Player.class, area);
        for (Player player : players) {
            CyberwareEvents.Recharge event = new CyberwareEvents.Recharge((LivingEntity)player, this, this.isDrainMode);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
                int maxTransfer = 10000;
                if (this.isDrainMode) {
                    int space;
                    int extracted = userData.extractEnergy(maxTransfer, true);
                    int toReceive = Math.min(extracted, space = this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
                    if (toReceive > 0) {
                        userData.extractEnergy(toReceive, false);
                        this.modifyEnergy(toReceive);
                    }
                } else {
                    int available = this.energyStorage.getEnergyStored();
                    int received = userData.receiveEnergy(Math.min(available, maxTransfer), true);
                    if (received > 0) {
                        this.modifyEnergy(-received);
                        userData.receiveEnergy(received, false);
                    }
                }
            });
        }
    }

    private void distributeEnergy(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (this.energyStorage.getEnergyStored() <= 0) break;
            BlockEntity neighborBe = level.m_7702_(pos.m_121945_(direction));
            if (neighborBe == null) continue;
            neighborBe.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(targetStorage -> {
                if (targetStorage.canReceive()) {
                    int extracted = this.energyStorage.extractEnergy(10000, true);
                    int received = targetStorage.receiveEnergy(extracted, false);
                    this.energyStorage.extractEnergy(received, false);
                }
            });
        }
    }

    private void modifyEnergy(int amount) {
        int current = this.energyStorage.getEnergyStored();
        int capacity = this.energyStorage.getMaxEnergyStored();
        int next = Math.max(0, Math.min(current + amount, capacity));
        this.energyStorage.setEnergyInternal(next);
        this.m_6596_();
    }

    public void toggleMode(Player player) {
        boolean bl = this.isDrainMode = !this.isDrainMode;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        if (this.isDrainMode) {
            player.m_213846_((Component)Component.m_237113_((String)"Charger Mode: DRAIN (Player -> Network)"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Charger Mode: CHARGE (Network -> Player)"));
        }
        this.m_6596_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Energy", this.energyStorage.serializeNBT());
        pTag.m_128379_("IsDrainMode", this.isDrainMode);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(pTag.m_128423_("Energy"));
        }
        this.isDrainMode = pTag.m_128471_("IsDrainMode");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyHandler.invalidate();
    }

    private class CustomEnergyStorage
    extends EnergyStorage {
        public CustomEnergyStorage(int capacity, int maxTransfer) {
            super(capacity, maxTransfer);
        }

        public void setEnergyInternal(int energy) {
            this.energy = energy;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (ChargerBlockEntity.this.isDrainMode) {
                return 0;
            }
            int ret = super.receiveEnergy(maxReceive, simulate);
            if (ret > 0 && !simulate) {
                ChargerBlockEntity.this.m_6596_();
            }
            return ret;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!ChargerBlockEntity.this.isDrainMode) {
                return 0;
            }
            int ret = super.extractEnergy(maxExtract, simulate);
            if (ret > 0 && !simulate) {
                ChargerBlockEntity.this.m_6596_();
            }
            return ret;
        }

        public boolean canReceive() {
            return !ChargerBlockEntity.this.isDrainMode;
        }

        public boolean canExtract() {
            return ChargerBlockEntity.this.isDrainMode;
        }
    }
}

