/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.block.cwb.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.maxwell.cyber_ware_port.init.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EngineeringRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final List<OutputEntry> outputs;
    private final float blueprintChance;

    public EngineeringRecipe(ResourceLocation id, Ingredient input, List<OutputEntry> outputs, float blueprintChance) {
        this.id = id;
        this.input = input;
        this.outputs = outputs;
        this.blueprintChance = blueprintChance;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public float getBlueprintChance() {
        return this.blueprintChance;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0));
    }

    public List<ItemStack> rollOutputs(RandomSource random) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (OutputEntry entry : this.outputs) {
            if (!(random.m_188501_() < entry.chance)) continue;
            results.add(entry.stack.m_41777_());
        }
        return results;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ENGINEERING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.ENGINEERING_TYPE.get();
    }

    public List<OutputEntry> getOutputs() {
        return this.outputs;
    }

    public record OutputEntry(ItemStack stack, float chance) {
    }

    public static class Serializer
    implements RecipeSerializer<EngineeringRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public EngineeringRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input"));
            JsonArray outputArray = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"outputs");
            ArrayList<OutputEntry> outputList = new ArrayList<OutputEntry>();
            for (int i = 0; i < outputArray.size(); ++i) {
                JsonObject entry = outputArray.get(i).getAsJsonObject();
                ResourceLocation itemLoc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)entry, (String)"item"));
                int count = GsonHelper.m_13824_((JsonObject)entry, (String)"count", (int)1);
                float chance = GsonHelper.m_13820_((JsonObject)entry, (String)"chance", (float)1.0f);
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemLoc), count);
                outputList.add(new OutputEntry(stack, chance));
            }
            float blueprintChance = GsonHelper.m_13820_((JsonObject)pSerializedRecipe, (String)"blueprint_chance", (float)0.5f);
            return new EngineeringRecipe(pRecipeId, input, outputList, blueprintChance);
        }

        @Nullable
        public EngineeringRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            float blueprintChance = pBuffer.readFloat();
            int size = pBuffer.readInt();
            ArrayList<OutputEntry> outputs = new ArrayList<OutputEntry>();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = pBuffer.m_130267_();
                float chance = pBuffer.readFloat();
                outputs.add(new OutputEntry(stack, chance));
            }
            return new EngineeringRecipe(pRecipeId, input, outputs, blueprintChance);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, EngineeringRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.writeFloat(pRecipe.blueprintChance);
            pBuffer.writeInt(pRecipe.outputs.size());
            for (OutputEntry entry : pRecipe.outputs) {
                pBuffer.m_130055_(entry.stack);
                pBuffer.writeFloat(entry.chance);
            }
        }
    }
}

