/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.block.radio.tower;

import com.maxwell.cyber_ware_port.common.block.radio.tower.RadioTowerCoreBlock;
import com.maxwell.cyber_ware_port.common.block.radio.tower.RadioTowerFenceBlock;
import com.maxwell.cyber_ware_port.init.ModBlockEntities;
import com.maxwell.cyber_ware_port.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RadioTowerCoreBlockEntity
extends BlockEntity {
    private static final int BASE_HEIGHT = 4;
    private static final int SHAFT_HEIGHT = 6;
    private static final int TOTAL_HEIGHT = 10;

    public RadioTowerCoreBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RADIO_TOWER_CORE.get(), pPos, pBlockState);
    }

    public void deformFencesOnly() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false, false);
    }

    public void tryToFormStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (this.checkStructure()) {
            this.setStructureState(true);
        }
    }

    public void deformStructure() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        this.setStructureState(false);
    }

    private void setStructureState(boolean formed) {
        this.setStructureState(formed, true);
    }

    private void setStructureState(boolean formed, boolean includeCore) {
        int yOffset;
        BlockState coreState;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos corePos = this.m_58899_();
        if (includeCore && (coreState = this.m_58900_()).m_61138_((Property)RadioTowerCoreBlock.FORMED)) {
            level.m_7731_(corePos, (BlockState)coreState.m_61124_((Property)RadioTowerCoreBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            this.updateFenceState(level, corePos.m_6625_(yOffset), formed);
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            BlockPos layerCenter = corePos.m_6625_(yOffset);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.updateFenceState(level, layerCenter.m_7918_(x, 0, z), formed);
                }
            }
        }
    }

    private void updateFenceState(Level level, BlockPos pos, boolean formed) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) && state.m_61138_((Property)RadioTowerFenceBlock.FORMED) && (Boolean)state.m_61143_((Property)RadioTowerFenceBlock.FORMED) != formed) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)RadioTowerFenceBlock.FORMED, (Comparable)Boolean.valueOf(formed)), 3);
        }
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB((double)pos.m_123341_() - 5.0, (double)pos.m_123342_() - 15.0, (double)pos.m_123343_() - 5.0, (double)pos.m_123341_() + 6.0, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 6.0);
    }

    private boolean checkStructure() {
        int z;
        int x;
        BlockPos layerCenter;
        int yOffset;
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        BlockPos corePos = this.m_58899_();
        for (yOffset = 1; yOffset <= 6; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockPos targetPos = layerCenter.m_7918_(x, 0, z);
                    BlockState state = level.m_8055_(targetPos);
                    if (!(x == 0 && z == 0 ? !state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get()) : !state.m_60795_())) continue;
                    return false;
                }
            }
        }
        for (yOffset = 7; yOffset <= 10; ++yOffset) {
            layerCenter = corePos.m_6625_(yOffset);
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    BlockState state = level.m_8055_(layerCenter.m_7918_(x, 0, z));
                    if (state.m_60713_((Block)ModBlocks.RADIO_TOWER_COMPONENT.get())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

