/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.capability;

import com.maxwell.cyber_ware_port.common.block.robosurgeon.RobosurgeonBlockEntity;
import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.common.capability.CyberwareUserData;
import com.maxwell.cyber_ware_port.common.item.base.BodyPartType;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.config.CyberwareConfig;
import com.maxwell.cyber_ware_port.init.ModBlocks;
import com.maxwell.cyber_ware_port.init.ModItems;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation("cyber_ware_port", "cyberware_data"), (ICapabilityProvider)new CyberwareCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(cap -> {
                if (!cap.isInitialized()) {
                    cap.fillWithHumanParts();
                }
                cap.syncToClient(serverPlayer);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CapabilityEvents.syncData(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                data.recalculateCapacity(serverPlayer);
                data.syncToClient(serverPlayer);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player newPlayer = event.getEntity();
        original.reviveCaps();
        try {
            original.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(oldData -> newPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(newData -> {
                if (!event.isWasDeath()) {
                    newData.copyFrom((CyberwareUserData)oldData);
                } else if (((Boolean)CyberwareConfig.KEEP_CYBERWARE_ON_DEATH.get()).booleanValue()) {
                    newData.copyFrom((CyberwareUserData)oldData);
                    newData.setRespawnGracePeriod(12000);
                    newData.ensureEssentialPartsAfterDeath();
                } else {
                    newData.resetToHuman();
                    ItemStackHandler handler = newData.getInstalledCyberware();
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128471_("cyberware_ghost")) continue;
                        handler.setStackInSlot(i, ItemStack.f_41583_);
                    }
                }
            }));
        }
        finally {
            original.invalidateCaps();
        }
        if (newPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)newPlayer;
            serverPlayer.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                data.recalculateCapacity(serverPlayer);
                data.syncToClient(serverPlayer);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            Collection drops = event.getDrops();
            Iterator iterator = drops.iterator();
            while (iterator.hasNext()) {
                ItemEntity drop = (ItemEntity)iterator.next();
                ItemStack stack = drop.m_32055_();
                if (!stack.m_41782_() || !stack.m_41783_().m_128471_("cyberware_ghost")) continue;
                iterator.remove();
            }
        }
    }

    private static void syncData(ServerPlayer player) {
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> data.syncToClient(player));
    }

    private static boolean isHandFunctional(Player player, InteractionHand hand) {
        if (player instanceof FakePlayer) {
            return true;
        }
        AtomicBoolean isFunctional = new AtomicBoolean(false);
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            ItemStackHandler handler = data.getInstalledCyberware();
            int armCount = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ICyberware cyberware;
                int slot;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (stack.m_41720_() == ModItems.HUMAN_LEFT_ARM.get() || stack.m_41720_() == ModItems.HUMAN_RIGHT_ARM.get()) {
                    ++armCount;
                    continue;
                }
                Item patt6725$temp = stack.m_41720_();
                if (!(patt6725$temp instanceof ICyberware) || (slot = (cyberware = (ICyberware)patt6725$temp).getSlot(stack)) != RobosurgeonBlockEntity.SLOT_ARMS && slot != RobosurgeonBlockEntity.SLOT_ARMS + 1) continue;
                ++armCount;
            }
            if (armCount >= 1) {
                isFunctional.set(true);
            }
        });
        return isFunctional.get();
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setNewSpeed(event.getOriginalSpeed() * 0.05f);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60713_((Block)ModBlocks.ROBO_SURGEON.get()) || state.m_60713_((Block)ModBlocks.SURGERY_CHAMBER.get())) {
            return;
        }
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60713_((Block)ModBlocks.ROBO_SURGEON.get()) || state.m_60713_((Block)ModBlocks.SURGERY_CHAMBER.get()) || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(BlockTags.f_13093_) || state.m_204336_(BlockTags.f_13038_)) {
            return;
        }
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(PlayerEvent.BreakSpeed event) {
        if (!CapabilityEvents.isHandFunctional(event.getEntity(), InteractionHand.MAIN_HAND)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                ItemStackHandler handler = data.getInstalledCyberware();
                boolean hasSkin = false;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ICyberware cw;
                    BodyPartType type;
                    Item patt9940$temp;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || !((patt9940$temp = stack.m_41720_()) instanceof ICyberware) || (type = (cw = (ICyberware)patt9940$temp).getBodyPartType(stack)) != BodyPartType.SKIN) continue;
                    hasSkin = true;
                }
                float multiplier = 1.0f;
                if (!hasSkin) {
                    multiplier += 0.5f;
                }
                if (multiplier > 1.0f) {
                    event.setAmount(event.getAmount() * multiplier);
                }
            });
        }
    }
}

