/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.capability;

import com.maxwell.cyber_ware_port.common.capability.CyberwareUserData;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class CyberwareCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<CyberwareUserData> CYBERWARE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CyberwareUserData>(){});
    private CyberwareUserData backend = null;
    private final LazyOptional<CyberwareUserData> optional = LazyOptional.of(this::createBackend);
    private final LazyOptional<IEnergyStorage> energyOptional = this.optional.cast();

    private CyberwareUserData createBackend() {
        if (this.backend == null) {
            this.backend = new CyberwareUserData();
        }
        return this.backend;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CYBERWARE_CAPABILITY) {
            return this.optional.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.createBackend().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createBackend().deserializeNBT(nbt);
    }
}

