/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.entity.monster.cyberwither;

import com.maxwell.cyber_ware_port.common.entity.monster.cyberwither.CyberWitherArmorLayer;
import com.maxwell.cyber_ware_port.common.entity.monster.cyberwither.CyberWitherBoss;
import com.maxwell.cyber_ware_port.common.entity.monster.cyberwither.CyberWitherModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CyberWitherBossRenderer
extends MobRenderer<CyberWitherBoss, CyberWitherModel> {
    private static final ResourceLocation WITHER_LOCATION = new ResourceLocation("cyber_ware_port", "textures/entity/wither/cyber_wither.png");
    private static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("cyber_ware_port", "textures/entity/wither/cyber_wither_invulnerable.png");
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/guardian_beam.png");

    public CyberWitherBossRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CyberWitherModel(context.m_174023_(CyberWitherModel.LAYER_LOCATION)), 1.0f);
        this.m_115326_((RenderLayer)new CyberWitherArmorLayer((RenderLayerParent<CyberWitherBoss, CyberWitherModel>)this, context.m_174027_()));
    }

    public void render(CyberWitherBoss pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        this.renderChains(pEntity, pPartialTicks, pPoseStack, pBuffer);
    }

    private void renderChains(CyberWitherBoss wither, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        for (int i = 1; i <= 3; ++i) {
            Entity minion;
            int entityId = wither.getMinionId(i);
            if (entityId == -1 || (minion = wither.m_9236_().m_6815_(entityId)) == null) continue;
            this.renderSingleChain(wither, minion, partialTick, poseStack, buffer);
        }
    }

    private void renderSingleChain(CyberWitherBoss wither, Entity minion, float partialTick, PoseStack poseStack, MultiBufferSource buffer) {
        double witherX = Mth.m_14139_((double)partialTick, (double)wither.f_19854_, (double)wither.m_20185_());
        double witherY = Mth.m_14139_((double)partialTick, (double)wither.f_19855_, (double)wither.m_20186_());
        double witherZ = Mth.m_14139_((double)partialTick, (double)wither.f_19856_, (double)wither.m_20189_());
        double minionX = Mth.m_14139_((double)partialTick, (double)minion.f_19854_, (double)minion.m_20185_());
        double minionY = Mth.m_14139_((double)partialTick, (double)minion.f_19855_, (double)minion.m_20186_());
        double minionZ = Mth.m_14139_((double)partialTick, (double)minion.f_19856_, (double)minion.m_20189_());
        float dx = (float)(minionX - witherX);
        float dy = (float)(minionY + (double)minion.m_20192_() * 0.5 - (witherY + (double)wither.m_20192_() * 0.5));
        float dz = (float)(minionZ - witherZ);
        float distH = Mth.m_14116_((float)(dx * dx + dz * dz));
        float distTotal = Mth.m_14116_((float)(dx * dx + dy * dy + dz * dz));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)wither.m_20192_() * 0.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(1.5707963267948966 - Math.atan2(dz, dx))));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(dy, distH))));
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)BEAM_LOCATION));
        float beamWidth = 0.15f;
        float vScale = distTotal * 0.5f;
        float age = (float)wither.f_19797_ + partialTick;
        float vOffset = age * 0.05f * -1.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, distTotal, beamWidth, 0.0f, 1.0f, 0.5f, 1.0f, vOffset, vScale);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        pose = poseStack.m_85850_();
        matrix4f = pose.m_252922_();
        matrix3f = pose.m_252943_();
        this.drawVertex(vertexconsumer, matrix4f, matrix3f, distTotal, beamWidth, 0.0f, 1.0f, 0.5f, 1.0f, vOffset, vScale);
        poseStack.m_85849_();
    }

    private void drawVertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, float length, float width, float r, float g, float b, float alpha, float vOffset, float vScale) {
        consumer.m_252986_(pose, -width, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(0.0f, vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, width, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_7421_(1.0f, vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, width, 0.0f, length).m_85950_(r, g, b, alpha).m_7421_(1.0f, vOffset + vScale).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, -width, 0.0f, length).m_85950_(r, g, b, alpha).m_7421_(0.0f, vOffset + vScale).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    protected int getBlockLightLevel(CyberWitherBoss pEntity, BlockPos pPos) {
        return 15;
    }

    public boolean shouldRender(CyberWitherBoss pEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        if (super.m_5523_((Mob)pEntity, pCamera, pCamX, pCamY, pCamZ)) {
            return true;
        }
        for (int i = 1; i <= 3; ++i) {
            Entity minion;
            int entityId = pEntity.getMinionId(i);
            if (entityId == -1 || (minion = pEntity.m_9236_().m_6815_(entityId)) == null) continue;
            Vec3 start = pEntity.m_20182_();
            Vec3 end = minion.m_20182_();
            if (!pCamera.m_113029_(new AABB(start.f_82479_, start.f_82480_, start.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_))) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getTextureLocation(CyberWitherBoss pEntity) {
        int invulTicks = pEntity.getInvulnerableTicks();
        if (invulTicks > 0) {
            return WITHER_LOCATION;
        }
        return pEntity.m_7090_() ? WITHER_INVULNERABLE_LOCATION : WITHER_LOCATION;
    }

    protected float getWhiteOverlayProgress(CyberWitherBoss pEntity, float pPartialTicks) {
        int invulTicks = pEntity.getInvulnerableTicks();
        if (invulTicks > 0) {
            float progress = 1.0f - ((float)invulTicks - pPartialTicks) / 220.0f;
            if (invulTicks < 10) {
                return 1.0f;
            }
            float flash = Mth.m_14031_((float)(progress * progress * 20.0f * (float)Math.PI));
            return Mth.m_14036_((float)flash, (float)0.0f, (float)0.6f);
        }
        return super.m_6931_((LivingEntity)pEntity, pPartialTicks);
    }

    protected void scale(CyberWitherBoss pLivingEntity, PoseStack pPoseStack, float pPartialTickTime) {
        float f = 2.0f;
        int i = pLivingEntity.getInvulnerableTicks();
        if (i > 0) {
            f -= ((float)i - pPartialTickTime) / 220.0f * 0.5f;
        }
        pPoseStack.m_85841_(f, f, f);
    }
}

