/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.item.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.maxwell.cyber_ware_port.common.item.base.BodyPartType;
import java.util.Collections;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public interface ICyberware {
    public int getEssenceCost(ItemStack var1);

    public int getSlot(ItemStack var1);

    public boolean isPristine(ItemStack var1);

    default public void onLivingHurt(LivingHurtEvent event, ItemStack stack, LivingEntity attacker) {
    }

    public void setPristine(ItemStack var1, boolean var2);

    public int getMaxInstallAmount(ItemStack var1);

    public Set<Item> getPrerequisites(ItemStack var1);

    default public Set<Item> getIncompatibleItems(ItemStack stack) {
        return Collections.emptySet();
    }

    public boolean hasEnergyProperties(ItemStack var1);

    public int getEnergyConsumption(ItemStack var1);

    default public int getEventConsumption(ItemStack stack) {
        return 0;
    }

    public int getEnergyGeneration(ItemStack var1);

    public int getEnergyStorage(ItemStack var1);

    public StackingRule getStackingEnergyRule(ItemStack var1);

    default public boolean isIncompatible(ItemStack self, ItemStack other) {
        if (self.m_41720_() == other.m_41720_()) {
            return this.getMaxInstallAmount(self) <= 1;
        }
        return this.getIncompatibleItems(self).contains(other.m_41720_());
    }

    default public BodyPartType getBodyPartType(ItemStack stack) {
        return BodyPartType.NONE;
    }

    default public boolean canToggle(ItemStack stack) {
        return false;
    }

    default public boolean isActive(ItemStack stack) {
        return !stack.m_41782_() || !stack.m_41783_().m_128441_("active") || stack.m_41783_().m_128471_("active");
    }

    default public int getQuality(ItemStack stack) {
        return 1;
    }

    default public void toggle(ItemStack stack) {
        boolean currentState = this.isActive(stack);
        stack.m_41784_().m_128379_("active", !currentState);
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        return ArrayListMultimap.create();
    }

    default public void onPlayerTick(TickEvent.PlayerTickEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onItemUseTick(LivingEntityUseItemEvent.Tick event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onLivingAttack(LivingAttackEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onEntityTeleport(EntityTeleportEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onPotionApplicable(MobEffectEvent.Applicable event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onLivingDeath(LivingDeathEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onHarvestCheck(PlayerEvent.HarvestCheck event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onBreakSpeed(PlayerEvent.BreakSpeed event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onLivingFall(LivingFallEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onLivingJump(LivingEvent.LivingJumpEvent event, ItemStack stack, LivingEntity wearer) {
    }

    default public void onSystemTick(LivingEntity entity, ItemStack stack) {
    }

    default public void onInstalled(LivingEntity entity, ItemStack stack) {
    }

    default public void onRemoved(LivingEntity entity, ItemStack stack) {
    }

    public static enum StackingRule {
        LINEAR,
        DIMINISHING,
        STATIC;


        public int calculate(int baseCost, int count) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LINEAR -> baseCost * count;
                case DIMINISHING -> (int)((double)baseCost * (1.0 + Math.log(count)));
                case STATIC -> count > 0 ? baseCost : 0;
            };
        }
    }
}

