/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.item.cyberware.Leg;

import com.maxwell.cyber_ware_port.common.block.robosurgeon.RobosurgeonBlockEntity;
import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.common.item.base.CyberwareItem;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.init.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingEvent;

public class LinearActuatorsItem
extends CyberwareItem {
    private static final String NBT_CROUCH_TIME = "cyberware_crouch_time";
    private static final String NBT_DOUBLE_JUMPED = "cyberware_double_jumped";
    private static final String NBT_JUMP_READY = "cyberware_jump_ready";

    public LinearActuatorsItem() {
        super(new CyberwareItem.Builder(5, RobosurgeonBlockEntity.SLOT_LEGS).requires(ModItems.CYBER_LEG_RIGHT, ModItems.CYBER_LEG_LEFT).maxInstall(1).eventCost(0).energy(0, 0, 0, ICyberware.StackingRule.LINEAR));
    }

    public static void performDoubleJump(Player player) {
        Vec3 currentMotion = player.m_20184_();
        Vec3 look = player.m_20154_();
        double boost = 0.5;
        double jumpHeight = 0.6;
        player.m_20334_(currentMotion.f_82479_ + look.f_82479_ * boost, jumpHeight, currentMotion.f_82481_ + look.f_82481_ * boost);
        player.f_19789_ = 0.0f;
        player.getPersistentData().m_128379_(NBT_DOUBLE_JUMPED, true);
    }

    @Override
    public void onSystemTick(LivingEntity wearer, ItemStack stack) {
        if (!(wearer instanceof Player)) {
            return;
        }
        Player player = (Player)wearer;
        CompoundTag tag = player.getPersistentData();
        if (player.m_6047_() && player.m_20096_()) {
            int time = tag.m_128451_(NBT_CROUCH_TIME);
            if (time < 60) {
                tag.m_128405_(NBT_CROUCH_TIME, ++time);
            }
            if (time >= 60) {
                tag.m_128379_(NBT_JUMP_READY, true);
            }
            if (player.m_9236_().m_5776_()) {
                if (time == 60) {
                    player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.7f, 1.5f);
                    for (int i = 0; i < 15; ++i) {
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 0.6, player.m_20186_() + 0.1, player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 0.6, 0.0, 0.1, 0.0);
                    }
                } else if (time > 0 && time < 60 && time % 20 == 0) {
                    float pitch = 1.0f + (float)time / 60.0f * 0.5f;
                    player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 0.5f, pitch);
                    for (int i = 0; i < 3; ++i) {
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 0.5, player.m_20186_() + 0.1, player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 0.5, 0.0, 0.05, 0.0);
                    }
                }
            }
        } else if (player.m_20096_()) {
            tag.m_128405_(NBT_CROUCH_TIME, 0);
            tag.m_128379_(NBT_JUMP_READY, false);
        }
        if (player.f_19862_ && !player.m_20096_()) {
            Vec3 motion = player.m_20184_();
            if (motion.f_82480_ < 0.0) {
                player.m_20334_(motion.f_82479_, -0.15, motion.f_82481_);
                player.f_19789_ = 0.0f;
            }
        }
        if (player.m_20096_()) {
            tag.m_128379_(NBT_DOUBLE_JUMPED, false);
        }
    }

    @Override
    public void onLivingJump(LivingEvent.LivingJumpEvent event, ItemStack stack, LivingEntity wearer) {
        if (wearer.m_9236_().m_5776_()) {
            return;
        }
        if (!(wearer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)wearer;
        CompoundTag tag = player.getPersistentData();
        if (tag.m_128471_(NBT_JUMP_READY)) {
            player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                if (this.tryConsumeEventEnergy((IEnergyStorage)data, stack)) {
                    Vec3 look = wearer.m_20154_();
                    double forwardSpeed = 1.5;
                    double upSpeed = 1.25;
                    wearer.m_20334_(look.f_82479_ * forwardSpeed, upSpeed, look.f_82481_ * forwardSpeed);
                    player.f_19864_ = true;
                    tag.m_128405_(NBT_CROUCH_TIME, 0);
                    tag.m_128379_(NBT_JUMP_READY, false);
                }
            });
        }
    }
}

