/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.network;

import com.maxwell.cyber_ware_port.common.container.CyberwareWorkbenchMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class ComponentChangePagePacket {
    private final int direction;
    private final int targetPanel;

    public ComponentChangePagePacket(int direction, int targetPanel) {
        this.direction = direction;
        this.targetPanel = targetPanel;
    }

    public static ComponentChangePagePacket fromBytes(FriendlyByteBuf buf) {
        int direction = buf.readInt();
        int targetPanel = buf.readInt();
        return new ComponentChangePagePacket(direction, targetPanel);
    }

    public static void handle(ComponentChangePagePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AbstractContainerMenu patt1089$temp;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (patt1089$temp = player.f_36096_) instanceof CyberwareWorkbenchMenu) {
                CyberwareWorkbenchMenu menu = (CyberwareWorkbenchMenu)patt1089$temp;
                switch (msg.targetPanel) {
                    case 0: {
                        menu.changePage(msg.direction);
                        break;
                    }
                    case 1: {
                        menu.changeBlueprintPage(msg.direction);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.direction);
        buf.writeInt(this.targetPanel);
    }
}

