/*
 * Decompiled with CFR 0.152.
 */
package togetherforever;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import togetherforever.ChainState;
import togetherforever.ModGameRules;
import togetherforever.PlayerChain;
import togetherforever.SharedInventoryManager;
import togetherforever.SharedStatsManager;

public class ChainManager {
    public static final List<PlayerChain> activeChains = new ArrayList<PlayerChain>();
    public static final List<Set<UUID>> connectedGroups = new ArrayList<Set<UUID>>();

    public static void register() {
        ServerTickEvents.START_WORLD_TICK.register(level -> {
            if (level.method_27983() == class_1937.field_25179) {
                for (PlayerChain chain : new ArrayList<PlayerChain>(activeChains)) {
                    ChainManager.applyChainPhysics(level, chain);
                }
                SharedStatsManager.tick(level);
                SharedInventoryManager.tick(level);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            System.out.println("TogetherForever: [EVENT] Server Started. Loading chains...");
            class_3218 overworld = server.method_30002();
            ChainState state = ChainState.getServerState(overworld);
            activeChains.clear();
            activeChains.addAll(state.chains);
            ChainManager.updateGroups();
            System.out.println("TogetherForever: [LOAD] Loaded " + activeChains.size() + " chains.");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            System.out.println("TogetherForever: [EVENT] Server Stopping. Saving...");
            class_3218 overworld = server.method_30002();
            ChainManager.saveState(overworld);
            activeChains.clear();
            connectedGroups.clear();
            System.out.println("TogetherForever: [CLEANUP] Static data cleared.");
        });
    }

    public static void addChain(class_3218 level, PlayerChain chain) {
        SharedInventoryManager.joinGroups(level, chain.player1, chain.player2);
        activeChains.add(chain);
        ChainManager.updateGroups();
        for (Set<UUID> group : connectedGroups) {
            if (!group.contains(chain.player1) && !group.contains(chain.player2)) continue;
            SharedStatsManager.syncGroupToLowest(level, group);
            break;
        }
        ChainManager.saveState(level);
    }

    public static void removeChain(class_3218 level, PlayerChain chain, class_3222 ... knownPlayers) {
        Set<UUID> targetGroup = null;
        for (Set<UUID> group : connectedGroups) {
            if (!group.contains(chain.player1) || !group.contains(chain.player2)) continue;
            targetGroup = group;
            break;
        }
        if (targetGroup != null) {
            SharedInventoryManager.distributeGroupInventory(level, targetGroup, knownPlayers);
        }
        activeChains.remove(chain);
        ChainManager.updateGroups();
        ChainManager.saveState(level);
    }

    public static void updateGroups() {
        connectedGroups.clear();
        HashMap<UUID, Set> adjacency = new HashMap<UUID, Set>();
        for (PlayerChain chain : activeChains) {
            adjacency.computeIfAbsent(chain.player1, k -> new HashSet()).add(chain.player2);
            adjacency.computeIfAbsent(chain.player2, k -> new HashSet()).add(chain.player1);
        }
        HashSet<UUID> visited = new HashSet<UUID>();
        for (UUID uuid : adjacency.keySet()) {
            if (visited.contains(uuid)) continue;
            HashSet<UUID> group = new HashSet<UUID>();
            LinkedList<UUID> queue = new LinkedList<UUID>();
            queue.add(uuid);
            visited.add(uuid);
            group.add(uuid);
            while (!queue.isEmpty()) {
                UUID current = (UUID)queue.poll();
                if (!adjacency.containsKey(current)) continue;
                for (UUID neighbor : (Set)adjacency.get(current)) {
                    if (visited.contains(neighbor)) continue;
                    visited.add(neighbor);
                    group.add(neighbor);
                    queue.add(neighbor);
                }
            }
            connectedGroups.add(group);
        }
    }

    private static void applyChainPhysics(class_3218 level, PlayerChain chain) {
        double maxDistance;
        class_243 pos2;
        class_3222 body2;
        class_3222 p1 = level.method_8503().method_3760().method_14602(chain.player1);
        class_3222 p2 = level.method_8503().method_3760().method_14602(chain.player2);
        if (p1 == null || p2 == null || p1.method_51469() != p2.method_51469()) {
            return;
        }
        class_3222 body1 = p1.method_5854() != null ? p1.method_5854() : p1;
        Object object = body2 = p2.method_5854() != null ? p2.method_5854() : p2;
        if (body1 == body2) {
            return;
        }
        class_243 pos1 = body1.method_73189();
        double currentDist = pos1.method_1022(pos2 = body2.method_73189());
        if (currentDist > (maxDistance = ((Double)level.method_64395().method_76185(ModGameRules.CHAIN_LENGTH)).doubleValue())) {
            double factor2;
            boolean unsafeState;
            class_243 difference = pos2.method_1020(pos1);
            class_243 direction = difference.method_1029();
            class_243 vel1 = body1.method_18798();
            class_243 vel2 = body2.method_18798();
            double vRel = vel2.method_1020(vel1).method_1026(direction);
            double stretch = currentDist - maxDistance;
            boolean bl = unsafeState = body1 instanceof class_3222 && !body1.method_24828() || body2 instanceof class_3222 && !body2.method_24828();
            double dampingFactor = ((Boolean)level.method_64395().method_76185(ModGameRules.DAMPENING_FORCE_AIR_ONLY)).booleanValue() ? (unsafeState ? 0.8 : 0.0) : 0.8;
            double k = Math.clamp((Double)level.method_64395().method_76185(ModGameRules.CHAIN_PULL_STRENGTH), 1.0, 200.0) / 100.0;
            double springForce = k * stretch;
            double dampingForce = vRel * dampingFactor;
            double totalPull = springForce + dampingForce * (Double)level.method_64395().method_76185(ModGameRules.DAMPENING_FORCE_MULT);
            if (totalPull < 0.0) {
                totalPull = 0.0;
            }
            double airDampening = Math.clamp((Double)level.method_64395().method_76185(ModGameRules.CHAIN_AIR_DAMPENING), 0.01, 1.0);
            double factor1 = body1 instanceof class_3222 && !body1.method_24828() ? airDampening : 1.0;
            double d = factor2 = body2 instanceof class_3222 && !body2.method_24828() ? airDampening : 1.0;
            if (totalPull > 0.0) {
                body1.method_18799(vel1.method_1019(direction.method_1021(totalPull * factor1)));
                body1.field_6037 = true;
                body2.method_18799(vel2.method_1019(direction.method_1021(-totalPull * factor2)));
                body2.field_6037 = true;
            }
        }
    }

    private static void saveState(class_3218 level) {
        ChainState state = ChainState.getServerState(level);
        if (!state.chains.equals(activeChains)) {
            state.chains.clear();
            state.chains.addAll(activeChains);
            state.method_80();
            System.out.println("TogetherForever: [SAVE] Marked state as dirty.");
        }
    }
}

