/*
 * Decompiled with CFR 0.152.
 */
package togetherforever;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_12249;
import net.minecraft.class_1657;
import net.minecraft.class_1944;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import togetherforever.ChainPayload;
import togetherforever.ClientChainManager;

@Environment(value=EnvType.CLIENT)
public class ChainRenderPipeline
implements ClientModInitializer {
    public void onInitializeClient() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            float partialTick = class_310.method_1551().method_61966().method_60637(true);
            this.render(context.matrices(), partialTick, context.consumers());
        });
    }

    private void render(class_4587 poseStack, float tickDelta, class_4597 bufferSource) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null || ClientChainManager.clientChains.isEmpty()) {
            return;
        }
        class_4588 consumer = bufferSource.method_73477(class_12249.method_75994((class_2960)class_1059.field_5275));
        class_1059 atlas = (class_1059)mc.method_1531().method_4619(class_1059.field_5275);
        if (atlas == null) {
            return;
        }
        class_1058 sprite = atlas.method_4608(class_2960.method_12829((String)"minecraft:block/iron_chain"));
        class_243 cameraPos = mc.field_1773.method_19418().method_71156();
        for (ChainPayload chain : ClientChainManager.clientChains) {
            class_1657 p1 = mc.field_1687.method_18470(chain.player1());
            class_1657 p2 = mc.field_1687.method_18470(chain.player2());
            if (p1 == null || p2 == null) continue;
            class_243 pos1 = p1.method_30950(tickDelta).method_1031(0.0, 0.8, 0.0);
            class_243 pos2 = p2.method_30950(tickDelta).method_1031(0.0, 0.8, 0.0);
            int light = this.getLight(p1);
            this.renderChainSegments(poseStack, consumer, pos1, pos2, cameraPos, sprite, light);
        }
    }

    private int getLight(class_1657 player) {
        int blockLight = player.method_73183().method_8314(class_1944.field_9282, player.method_24515());
        int skyLight = player.method_73183().method_8314(class_1944.field_9284, player.method_24515());
        return skyLight << 20 | blockLight << 4;
    }

    private void renderChainSegments(class_4587 poseStack, class_4588 consumer, class_243 start, class_243 end, class_243 cameraPos, class_1058 sprite, int light) {
        class_243 diff = end.method_1020(start);
        double distance = diff.method_1033();
        class_243 direction = diff.method_1029();
        double yaw = Math.atan2(direction.field_1352, direction.field_1350);
        double pitch = Math.asin(-direction.field_1351);
        poseStack.method_22903();
        poseStack.method_22904(start.field_1352 - cameraPos.field_1352, start.field_1351 - cameraPos.field_1351, start.field_1350 - cameraPos.field_1350);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)yaw));
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation((float)pitch));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(45.0f));
        float halfWidth = 0.1f;
        double step = 1.0;
        for (double d = 0.0; d < distance; d += step) {
            float segmentLen = (float)Math.min(step, distance - d);
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, d);
            this.renderCross(poseStack.method_23760().method_23761(), poseStack.method_23760().method_23762(), consumer, halfWidth, segmentLen, sprite, light);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private void renderCross(Matrix4f pose, Matrix3f normalMatrix, class_4588 consumer, float halfWidth, float length, class_1058 sprite, int light) {
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        float vHeight = v1 - v0;
        float textureLimit = v0 + vHeight * length;
        float offset = halfWidth * 0.75f;
        float left = -halfWidth + offset;
        float right = halfWidth + offset;
        float top = halfWidth + offset;
        float bottom = -halfWidth + offset;
        float zStart = 0.0f;
        float zEnd = length;
        float bias = 0.002f;
        this.addVertex(consumer, pose, normalMatrix, left, bias, zStart, u0, v0, light, 0, 1, 0);
        this.addVertex(consumer, pose, normalMatrix, left, bias, zEnd, u0, textureLimit, light, 0, 1, 0);
        this.addVertex(consumer, pose, normalMatrix, right, bias, zEnd, u1, textureLimit, light, 0, 1, 0);
        this.addVertex(consumer, pose, normalMatrix, right, bias, zStart, u1, v0, light, 0, 1, 0);
        this.addVertex(consumer, pose, normalMatrix, right, -bias, zStart, u1, v0, light, 0, -1, 0);
        this.addVertex(consumer, pose, normalMatrix, right, -bias, zEnd, u1, textureLimit, light, 0, -1, 0);
        this.addVertex(consumer, pose, normalMatrix, left, -bias, zEnd, u0, textureLimit, light, 0, -1, 0);
        this.addVertex(consumer, pose, normalMatrix, left, -bias, zStart, u0, v0, light, 0, -1, 0);
        this.addVertex(consumer, pose, normalMatrix, bias, bottom, zStart, u0, v0, light, 1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, bias, bottom, zEnd, u0, textureLimit, light, 1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, bias, top, zEnd, u1, textureLimit, light, 1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, bias, top, zStart, u1, v0, light, 1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, -bias, top, zStart, u1, v0, light, -1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, -bias, top, zEnd, u1, textureLimit, light, -1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, -bias, bottom, zEnd, u0, textureLimit, light, -1, 0, 0);
        this.addVertex(consumer, pose, normalMatrix, -bias, bottom, zStart, u0, v0, light, -1, 0, 0);
    }

    private void addVertex(class_4588 consumer, Matrix4f pose, Matrix3f normalMatrix, float x, float y, float z, float u, float v, int light, int nx, int ny, int nz) {
        Vector3f normal = new Vector3f((float)nx, (float)ny, (float)nz);
        normal.mul((Matrix3fc)normalMatrix);
        consumer.method_22918((Matrix4fc)pose, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_22914(normal.x(), normal.y(), normal.z());
    }
}

