/*
 * Decompiled with CFR 0.152.
 */
package togetherforever;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import togetherforever.ChainManager;

public class SharedInventoryManager {
    private static final Map<UUID, List<class_1799>> lastKnownInventories = new HashMap<UUID, List<class_1799>>();

    public static void tick(class_3218 level) {
        for (Set<UUID> group : ChainManager.connectedGroups) {
            SharedInventoryManager.processGroup(level, group);
        }
    }

    public static void joinGroups(class_3218 level, UUID p1UUID, UUID p2UUID) {
        class_3222 p1 = level.method_8503().method_3760().method_14602(p1UUID);
        class_3222 p2 = level.method_8503().method_3760().method_14602(p2UUID);
        if (p1 == null || p2 == null) {
            return;
        }
        Set<UUID> group1 = SharedInventoryManager.findGroup(p1UUID);
        Set<UUID> group2 = SharedInventoryManager.findGroup(p2UUID);
        if (group1 != null && group1 == group2) {
            return;
        }
        if (group1 == null) {
            group1 = Set.of(p1UUID);
        }
        if (group2 == null) {
            group2 = Set.of(p2UUID);
        }
        class_1661 inv1 = p1.method_31548();
        class_1661 inv2 = p2.method_31548();
        List<class_1799> itemsToMerge = SharedInventoryManager.getSnapshot(inv2);
        inv2.method_5448();
        for (class_1799 stack : itemsToMerge) {
            class_1542 itemEntity;
            if (stack.method_7960() || inv1.method_7394(stack) || (itemEntity = p1.method_7328(stack, false)) == null) continue;
            itemEntity.method_6975();
            itemEntity.method_6981((class_1297)p1);
        }
        List<class_1799> finalState = SharedInventoryManager.getSnapshot(inv1);
        HashSet<UUID> allPlayers = new HashSet<UUID>(group1);
        allPlayers.addAll(group2);
        for (UUID uuid : allPlayers) {
            class_3222 p = level.method_8503().method_3760().method_14602(uuid);
            if (p == null || !p.method_5805()) continue;
            SharedInventoryManager.applySnapshot(p, finalState, true);
            lastKnownInventories.put(p.method_5667(), SharedInventoryManager.deepCopy(finalState));
            p.field_7512.method_7623();
        }
    }

    private static Set<UUID> findGroup(UUID player) {
        for (Set<UUID> group : ChainManager.connectedGroups) {
            if (!group.contains(player)) continue;
            return group;
        }
        return null;
    }

    private static void processGroup(class_3218 level, Set<UUID> group) {
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (UUID uuid : group) {
            class_3222 p = level.method_8503().method_3760().method_14602(uuid);
            if (p == null || !p.method_5805()) continue;
            players.add(p);
        }
        if (players.size() < 2) {
            return;
        }
        List<class_1799> baseState = lastKnownInventories.get(((class_3222)players.get(0)).method_5667());
        if (baseState == null) {
            baseState = SharedInventoryManager.getSnapshot(((class_3222)players.get(0)).method_31548());
        }
        List<class_1799> consensus = SharedInventoryManager.deepCopy(baseState);
        for (class_3222 player : players) {
            List<class_1799> previous = lastKnownInventories.get(player.method_5667());
            List<class_1799> current = SharedInventoryManager.getSnapshot(player.method_31548());
            if (previous == null) {
                lastKnownInventories.put(player.method_5667(), SharedInventoryManager.deepCopy(current));
                continue;
            }
            for (int i = 0; i < current.size(); ++i) {
                class_1799 curStack = current.get(i);
                class_1799 prevStack = previous.get(i);
                class_1799 conStack = consensus.get(i);
                if (class_1799.method_7973((class_1799)curStack, (class_1799)prevStack)) continue;
                if (class_1799.method_7984((class_1799)curStack, (class_1799)prevStack) && curStack.method_7963()) {
                    int damageDelta = curStack.method_7919() - prevStack.method_7919();
                    if (!class_1799.method_7984((class_1799)conStack, (class_1799)curStack)) continue;
                    int newDamage = conStack.method_7919() + damageDelta;
                    newDamage = Math.clamp((long)newDamage, 0, conStack.method_7936());
                    conStack.method_7974(newDamage);
                    if (newDamage < conStack.method_7936()) continue;
                    consensus.set(i, class_1799.field_8037);
                    continue;
                }
                consensus.set(i, curStack.method_7972());
            }
        }
        for (class_3222 player : players) {
            boolean changed = SharedInventoryManager.applySnapshot(player, consensus, false);
            lastKnownInventories.put(player.method_5667(), SharedInventoryManager.deepCopy(consensus));
            if (!changed) continue;
            player.field_7512.method_7623();
            player.field_7498.method_7623();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void distributeGroupInventory(class_3218 level, Set<UUID> group, class_3222 ... knownPlayers) {
        System.out.println("Distributing group inventory");
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (UUID uUID : group) {
            class_3222 p = null;
            if (knownPlayers != null) {
                for (class_3222 kp : knownPlayers) {
                    if (!kp.method_5667().equals(uUID)) continue;
                    p = kp;
                    break;
                }
            }
            if (p == null) {
                p = level.method_8503().method_3760().method_14602(uUID);
            }
            if (p == null || !p.method_5805()) continue;
            players.add(p);
        }
        if (players.isEmpty()) {
            return;
        }
        System.out.println("Found " + players.size() + " players to distribute to.");
        List<class_1799> sharedLoot = SharedInventoryManager.getSnapshot(((class_3222)players.get(0)).method_31548());
        for (class_3222 p : players) {
            p.method_31548().method_5448();
            lastKnownInventories.remove(p.method_5667());
        }
        boolean bl = false;
        for (class_1799 stack : sharedLoot) {
            class_3222 dropTarget;
            class_1542 entity;
            if (stack.method_7960()) continue;
            boolean placed = false;
            for (int attempt = 0; attempt < players.size(); ++attempt) {
                void var5_8;
                class_3222 currentTarget = (class_3222)players.get((int)var5_8);
                if (currentTarget.method_31548().method_7394(stack)) {
                    placed = true;
                    var5_8 = (var5_8 + true) % players.size();
                    break;
                }
                var5_8 = (var5_8 + true) % players.size();
            }
            if (placed || (entity = (dropTarget = (class_3222)players.get(0)).method_7328(stack, false)) == null) continue;
            entity.method_6981((class_1297)dropTarget);
        }
        for (class_3222 p : players) {
            p.field_7512.method_7623();
            p.field_7498.method_7623();
        }
    }

    private static List<class_1799> getSnapshot(class_1661 inv) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            list.add(inv.method_5438(i).method_7972());
        }
        return list;
    }

    private static boolean applySnapshot(class_3222 player, List<class_1799> snapshot, boolean forceStrict) {
        class_1661 inv = player.method_31548();
        if (snapshot.size() != inv.method_5439()) {
            return false;
        }
        boolean modified = false;
        for (int i = 0; i < inv.method_5439(); ++i) {
            int diff;
            class_1799 newStack = snapshot.get(i);
            class_1799 currentStack = inv.method_5438(i);
            if (class_1799.method_7973((class_1799)currentStack, (class_1799)newStack) || !forceStrict && inv.method_67532() == i && class_1799.method_7984((class_1799)currentStack, (class_1799)newStack) && !newStack.method_7960() && (diff = Math.abs(newStack.method_7919() - currentStack.method_7919())) > 0 && diff < 5) continue;
            inv.method_5447(i, newStack.method_7972());
            modified = true;
        }
        return modified;
    }

    private static List<class_1799> deepCopy(List<class_1799> source) {
        ArrayList<class_1799> copy = new ArrayList<class_1799>();
        for (class_1799 s : source) {
            copy.add(s.method_7972());
        }
        return copy;
    }
}

