/*
 * Decompiled with CFR 0.152.
 */
package togetherforever;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2596;
import net.minecraft.class_2749;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8043;
import togetherforever.ChainManager;

public class SharedStatsManager {
    private static final Map<UUID, PlayerState> lastStates = new HashMap<UUID, PlayerState>();

    public static void syncGroupToLowest(class_3218 level, Set<UUID> group) {
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (UUID uuid : group) {
            class_3222 p = level.method_8503().method_3760().method_14602(uuid);
            if (p == null || !p.method_5805()) continue;
            players.add(p);
        }
        if (players.isEmpty()) {
            return;
        }
        float minHealth = Float.MAX_VALUE;
        int minFood = 20;
        float minSat = 20.0f;
        for (class_3222 p : players) {
            if (p.method_6032() < minHealth) {
                minHealth = p.method_6032();
            }
            if (p.method_7344().method_7586() < minFood) {
                minFood = p.method_7344().method_7586();
            }
            if (!(p.method_7344().method_7589() < minSat)) continue;
            minSat = p.method_7344().method_7589();
        }
        for (class_3222 p : players) {
            boolean changed = false;
            if ((double)Math.abs(p.method_6032() - minHealth) > 0.01) {
                p.method_6033(minHealth);
                changed = true;
            }
            if (p.method_7344().method_7586() != minFood || p.method_7344().method_7589() != minSat) {
                p.method_7344().method_7580(minFood);
                p.method_7344().method_7581(minSat);
                changed = true;
            }
            if (changed) {
                p.field_13987.method_14364((class_2596)new class_2749(p.method_6032(), p.method_7344().method_7586(), p.method_7344().method_7589()));
            }
            lastStates.put(p.method_5667(), new PlayerState(minHealth, minFood, minSat));
        }
    }

    public static void tick(class_3218 level) {
        for (Set<UUID> group : ChainManager.connectedGroups) {
            SharedStatsManager.processGroup(level, group);
        }
    }

    private static void processGroup(class_3218 level, Set<UUID> group) {
        PlayerState prev;
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        for (UUID uuid : group) {
            class_3222 p = level.method_8503().method_3760().method_14602(uuid);
            if (p == null || !p.method_5805()) continue;
            players.add(p);
        }
        if (players.size() < 2) {
            return;
        }
        float totalHealthDelta = 0.0f;
        int totalFoodDelta = 0;
        float totalSaturationDelta = 0.0f;
        boolean dirty = false;
        for (class_3222 player : players) {
            prev = lastStates.getOrDefault(player.method_5667(), new PlayerState(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
            float hDelta = player.method_6032() - prev.health;
            int fDelta = player.method_7344().method_7586() - prev.foodLevel;
            float sDelta = player.method_7344().method_7589() - prev.saturation;
            if (!((double)Math.abs(hDelta) > 0.001) && fDelta == 0 && !((double)Math.abs(sDelta) > 0.001)) continue;
            totalHealthDelta += hDelta;
            totalFoodDelta += fDelta;
            totalSaturationDelta += sDelta;
            dirty = true;
        }
        if (dirty) {
            for (class_3222 player : players) {
                prev = lastStates.getOrDefault(player.method_5667(), new PlayerState(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
                float newHealth = Math.clamp(prev.health + totalHealthDelta, 0.0f, player.method_6063());
                int newFood = Math.clamp((long)(prev.foodLevel + totalFoodDelta), 0, 20);
                float newSat = Math.clamp(prev.saturation + totalSaturationDelta, 0.0f, (float)newFood);
                boolean tookDamage = false;
                if ((double)Math.abs(player.method_6032() - newHealth) > 0.01) {
                    player.method_6033(newHealth);
                    if ((double)totalHealthDelta < -0.1) {
                        player.field_6037 = true;
                        player.field_6235 = 10;
                        player.field_6254 = 10;
                        tookDamage = true;
                    }
                }
                player.method_7344().method_7580(newFood);
                player.method_7344().method_7581(newSat);
                if (!tookDamage) continue;
                player.field_13987.method_14364((class_2596)new class_2749(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
                player.field_13987.method_14364((class_2596)new class_8043((class_1309)player));
                player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15115, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
        for (class_3222 player : players) {
            lastStates.put(player.method_5667(), new PlayerState(player.method_6032(), player.method_7344().method_7586(), player.method_7344().method_7589()));
        }
    }

    private record PlayerState(float health, int foodLevel, float saturation) {
    }
}

