/*
 * Decompiled with CFR 0.152.
 */
package togetherforever;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import togetherforever.ChainBreakPayload;
import togetherforever.ChainManager;
import togetherforever.ChainPayload;
import togetherforever.ChainResetPayload;
import togetherforever.ModGameRules;
import togetherforever.PlayerChain;

public class TogetherForever
implements ModInitializer {
    public static final String MOD_ID = "together-forever";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"together-forever");

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(ChainPayload.TYPE, ChainPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChainBreakPayload.TYPE, ChainBreakPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ChainResetPayload.TYPE, ChainResetPayload.CODEC);
        ChainManager.register();
        ModGameRules.register();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            class_3218 level = player.method_51469();
            server.execute(() -> {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ChainResetPayload());
                ArrayList<PlayerChain> chainsToBreak = new ArrayList<PlayerChain>();
                double maxAllowedDistance = (Double)level.method_64395().method_76185(ModGameRules.CHAIN_LENGTH) * 3.0;
                for (PlayerChain chain : ChainManager.activeChains) {
                    UUID partnerUUID;
                    if (!chain.player1.equals(player.method_5667()) && !chain.player2.equals(player.method_5667())) continue;
                    UUID uUID = partnerUUID = chain.player1.equals(player.method_5667()) ? chain.player2 : chain.player1;
                    class_3222 partner = server.method_3760().method_14602(partnerUUID);
                    if (partner == null) continue;
                    boolean shouldBreak = false;
                    String reason = "";
                    if (player.method_51469().method_27983() != partner.method_51469().method_27983()) {
                        shouldBreak = true;
                        reason = "separation across dimensions";
                    } else if ((double)player.method_5739((class_1297)partner) > maxAllowedDistance) {
                        shouldBreak = true;
                        reason = "excessive distance";
                    }
                    if (!shouldBreak) continue;
                    chainsToBreak.add(chain);
                    player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cChain broken due to " + reason + ".")));
                    partner.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cChain broken due to " + reason + ".")));
                }
                for (PlayerChain chain : chainsToBreak) {
                    ChainManager.removeChain(level, chain, player);
                    ChainBreakPayload breakPayload = new ChainBreakPayload(chain.player1, chain.player2);
                    for (class_3222 p : server.method_3760().method_14571()) {
                        ServerPlayNetworking.send((class_3222)p, (class_8710)breakPayload);
                    }
                }
                for (PlayerChain chain : ChainManager.activeChains) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new ChainPayload(chain.player1, chain.player2));
                }
            });
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            Set<UUID> group = null;
            for (Set<UUID> g : ChainManager.connectedGroups) {
                if (!g.contains(player.method_5667())) continue;
                group = g;
                break;
            }
            if (group != null) {
                for (UUID uuid : group) {
                    class_3222 partner;
                    if (uuid.equals(player.method_5667()) || (partner = destination.method_8503().method_3760().method_14602(uuid)) == null || partner.method_51469().method_27983() == destination.method_27983()) continue;
                    partner.method_48105(destination, player.method_23317(), player.method_23318(), player.method_23321(), Set.of(), partner.method_36454(), partner.method_36455(), true);
                    partner.method_30229();
                }
            }
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                Set<UUID> group = null;
                for (Set<UUID> g : ChainManager.connectedGroups) {
                    if (!g.contains(player.method_5667())) continue;
                    group = g;
                    break;
                }
                if (group != null) {
                    for (UUID uuid : group) {
                        class_3222 other;
                        if (uuid.equals(player.method_5667()) || (other = player.method_51469().method_8503().method_3760().method_14602(uuid)) == null || !other.method_5805()) continue;
                        other.method_31548().method_5448();
                        other.field_7512.method_7623();
                        other.method_5768(other.method_51469());
                        other.method_64398((class_2561)class_2561.method_43470((String)"Fate is shared. You died because your partner died."));
                    }
                    ArrayList<PlayerChain> chainsToRemove = new ArrayList<PlayerChain>();
                    for (PlayerChain chain : ChainManager.activeChains) {
                        if (!group.contains(chain.player1) && !group.contains(chain.player2)) continue;
                        chainsToRemove.add(chain);
                    }
                    for (PlayerChain chain : chainsToRemove) {
                        ChainManager.activeChains.remove(chain);
                        ChainBreakPayload breakPayload = new ChainBreakPayload(chain.player1, chain.player2);
                        for (class_3222 p : player.method_51469().method_18456()) {
                            ServerPlayNetworking.send((class_3222)p, (class_8710)breakPayload);
                        }
                    }
                    ChainManager.updateGroups();
                }
            }
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (world.method_8608() || !(entity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 target = (class_3222)entity;
            if (hand != class_1268.field_5808) {
                return class_1269.field_5811;
            }
            if (hitResult != null) {
                return class_1269.field_5811;
            }
            class_1799 stack = player.method_5998(hand);
            class_3222 serverPlayer = (class_3222)player;
            if (stack.method_31574(class_1802.field_23983)) {
                if (serverPlayer == target) {
                    return class_1269.field_5811;
                }
                boolean alreadyChained = ChainManager.activeChains.stream().anyMatch(c -> c.player1.equals(serverPlayer.method_5667()) && c.player2.equals(target.method_5667()) || c.player1.equals(target.method_5667()) && c.player2.equals(serverPlayer.method_5667()));
                if (alreadyChained) {
                    serverPlayer.method_64398((class_2561)class_2561.method_43470((String)("You are already chained to " + target.method_5477().getString())));
                    return class_1269.field_5814;
                }
                if (!serverPlayer.method_68878()) {
                    stack.method_7934(1);
                }
                PlayerChain newChain = new PlayerChain(serverPlayer.method_5667(), target.method_5667());
                ChainManager.addChain(serverPlayer.method_51469(), newChain);
                ChainPayload payload = new ChainPayload(serverPlayer.method_5667(), target.method_5667());
                for (class_3222 p : serverPlayer.method_51469().method_18456()) {
                    ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
                }
                world.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_24063, class_3419.field_15248, 1.0f, 1.0f);
                serverPlayer.method_64398((class_2561)class_2561.method_43470((String)("Linked with " + target.method_5477().getString())));
                target.method_64398((class_2561)class_2561.method_43470((String)("Linked with " + serverPlayer.method_5477().getString())));
                serverPlayer.method_23667(hand, true);
                return class_1269.field_5812;
            }
            if (stack.method_31574(class_1802.field_8187)) {
                PlayerChain chainToRemove = null;
                for (PlayerChain chain : ChainManager.activeChains) {
                    if ((!chain.player1.equals(serverPlayer.method_5667()) || !chain.player2.equals(target.method_5667())) && (!chain.player1.equals(target.method_5667()) || !chain.player2.equals(serverPlayer.method_5667()))) continue;
                    chainToRemove = chain;
                    break;
                }
                if (chainToRemove != null) {
                    if (!serverPlayer.method_68878()) {
                        player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
                    }
                    ChainManager.removeChain(serverPlayer.method_51469(), chainToRemove, serverPlayer);
                    ChainBreakPayload breakPayload = new ChainBreakPayload(chainToRemove.player1, chainToRemove.player2);
                    for (class_3222 p : serverPlayer.method_51469().method_18456()) {
                        ServerPlayNetworking.send((class_3222)p, (class_8710)breakPayload);
                    }
                    world.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), class_3417.field_19198, class_3419.field_15248, 1.0f, 1.0f);
                    serverPlayer.method_64398((class_2561)class_2561.method_43470((String)"Chain broken!"));
                    target.method_64398((class_2561)class_2561.method_43470((String)"Chain broken!"));
                    serverPlayer.method_23667(hand, true);
                    return class_1269.field_5812;
                }
            }
            return class_1269.field_5811;
        });
    }
}

