/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari;

import com.mojang.logging.LogUtils;
import com.vibey.imitari.ModCreativeTabs;
import com.vibey.imitari.api.CopyBlockAPI;
import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.api.registration.CopyBlockRegistration;
import com.vibey.imitari.client.CopyBlockModelProvider;
import com.vibey.imitari.compat.cbc.CBCIntegration;
import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import com.vibey.imitari.config.ImitariConfig;
import com.vibey.imitari.integration.ModIntegrations;
import com.vibey.imitari.registry.ModBlockEntities;
import com.vibey.imitari.registry.ModBlocks;
import com.vibey.imitari.registry.ModItems;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="imitari")
public class Imitari {
    public static final String MODID = "imitari";
    public static final String VERSION = "0.1.0";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Imitari() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOGGER.info("Initializing Imitari v{}", (Object)VERSION);
        ImitariConfig.register();
        modEventBus.addListener(this::commonSetup);
        ModBlocks.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModIntegrations.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            int count = CopyBlockRegistration.registerForMod(MODID);
            LOGGER.info("Registered {} CopyBlocks", (Object)count);
            VS2CopyBlockIntegration.register();
            CBCIntegration.register();
            ModIntegrations.registerWithImitariSystems();
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256837_) {
            event.accept(ModItems.DEBUG_TOOL);
        }
        ModIntegrations.addToClockworkTab(event);
        ModIntegrations.addToWariumTab(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="imitari", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                BlockColors blockColors = minecraft.m_91298_();
                ArrayList<Block> copyBlocks = new ArrayList<Block>();
                for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                    if (!(block instanceof ICopyBlock)) continue;
                    copyBlocks.add(block);
                    ItemBlockRenderTypes.setRenderLayer((Block)block, rt -> rt == RenderType.m_110463_() || rt == RenderType.m_110466_());
                }
                if (!copyBlocks.isEmpty()) {
                    blockColors.m_92589_((state, level, pos, tintIndex) -> {
                        if (level == null || pos == null) {
                            return -1;
                        }
                        BlockState copiedState = CopyBlockAPI.getCopiedBlock((BlockGetter)level, pos);
                        if (copiedState == null) {
                            return -1;
                        }
                        return blockColors.m_92577_(copiedState, level, pos, tintIndex);
                    }, (Block[])copyBlocks.toArray(Block[]::new));
                }
            });
        }

        @SubscribeEvent
        public static void onModelBake(ModelEvent.ModifyBakingResult event) {
            CopyBlockModelProvider.onModelBake(event);
        }
    }
}

