/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.api;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CopyBlockAPI {
    private static final Set<ResourceLocation> REGISTERED_BLOCKS = new HashSet<ResourceLocation>();

    public static void registerCopyBlock(ResourceLocation blockId) {
        REGISTERED_BLOCKS.add(blockId);
    }

    public static void registerCopyBlock(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id != null) {
            CopyBlockAPI.registerCopyBlock(id);
        }
    }

    public static int autoRegisterModBlocks(String modId) {
        int count = 0;
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            ICopyBlock copyBlock;
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            Block block = (Block)entry.getValue();
            if (!id.m_135827_().equals(modId) || !(block instanceof ICopyBlock) || !(copyBlock = (ICopyBlock)block).useDynamicModel()) continue;
            CopyBlockAPI.registerCopyBlock(id);
            ++count;
        }
        return count;
    }

    public static boolean unregisterCopyBlock(ResourceLocation blockId) {
        return REGISTERED_BLOCKS.remove(blockId);
    }

    public static boolean isRegistered(ResourceLocation blockId) {
        return REGISTERED_BLOCKS.contains(blockId);
    }

    public static boolean isRegistered(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        return id != null && CopyBlockAPI.isRegistered(id);
    }

    public static Set<ResourceLocation> getRegisteredBlocks() {
        return new HashSet<ResourceLocation>(REGISTERED_BLOCKS);
    }

    public static void clearRegistrations() {
        REGISTERED_BLOCKS.clear();
    }

    @Nullable
    public static BlockState getCopiedBlock(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity) {
            ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
            BlockState copied = copyBE.getCopiedBlock();
            return copied.m_60795_() ? null : copied;
        }
        return null;
    }

    public static boolean isCopyBlock(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60734_() instanceof ICopyBlock;
    }

    public static boolean hasCopiedBlock(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity) {
            ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
            return copyBE.hasCopiedBlock();
        }
        return false;
    }

    public static float getMassMultiplier(Block block) {
        if (block instanceof ICopyBlock) {
            ICopyBlock copyBlock = (ICopyBlock)block;
            return copyBlock.getMassMultiplier();
        }
        return 1.0f;
    }

    public static double getEffectiveMass(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof ICopyBlock)) {
            return 0.0;
        }
        ICopyBlock copyBlock = (ICopyBlock)block;
        BlockState copied = CopyBlockAPI.getCopiedBlock(level, pos);
        if (copied == null) {
            return 0.0;
        }
        return 50.0 * (double)copyBlock.getMassMultiplier();
    }

    public static boolean implementsICopyBlock(Block block) {
        return block instanceof ICopyBlock;
    }

    public static boolean implementsICopyBlock(BlockState state) {
        return state.m_60734_() instanceof ICopyBlock;
    }
}

