/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.api;

import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import com.vibey.imitari.config.ImitariConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public interface ICopyBlock {
    public float getMassMultiplier();

    default public boolean useDynamicModel() {
        return true;
    }

    default public boolean useDynamicTags() {
        return (Boolean)ImitariConfig.ENABLE_DYNAMIC_TAGS.get();
    }

    default public boolean useDynamicPhysics() {
        return true;
    }

    default public boolean useDynamicMass() {
        return true;
    }

    default public boolean consumesItemsOnPlace() {
        return (Boolean)ImitariConfig.CONSUMES_ITEMS_IN_SURVIVAL.get();
    }

    default public boolean allowCreativeRemoval() {
        return true;
    }

    default public boolean allowSurvivalRemoval() {
        return (Boolean)ImitariConfig.ALLOW_SURVIVAL_REMOVAL.get();
    }

    default public float copyblock$getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        ICopyBlockEntity copyBE;
        BlockState copiedState;
        if (!this.useDynamicPhysics() || !((Boolean)ImitariConfig.COPY_RESISTANCE.get()).booleanValue()) {
            return 0.5f;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity && !(copiedState = (copyBE = (ICopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            float baseResistance = copiedState.m_60734_().m_7325_();
            return baseResistance * this.getMassMultiplier();
        }
        return 0.5f;
    }

    default public float copyblock$getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        ICopyBlockEntity copyBE;
        BlockState copiedState;
        if (!this.useDynamicPhysics() || !((Boolean)ImitariConfig.COPY_HARDNESS.get()).booleanValue()) {
            return 2.0f;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity && !(copiedState = (copyBE = (ICopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            float baseProgress = copiedState.m_60625_(player, level, pos);
            return baseProgress / this.getMassMultiplier();
        }
        return 2.0f;
    }

    default public SoundType copyblock$getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        ICopyBlockEntity copyBE;
        BlockState copiedState;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity && !(copiedState = (copyBE = (ICopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            return copiedState.getSoundType(level, pos, entity);
        }
        return SoundType.f_56736_;
    }

    default public InteractionResult copyblock$use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean allowRemove;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ICopyBlockEntity)) {
            return InteractionResult.PASS;
        }
        ICopyBlockEntity copyBlockEntity = (ICopyBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        BlockState currentCopied = copyBlockEntity.getCopiedBlock();
        boolean canRemove = player.m_6144_() && heldItem.m_41619_() && !currentCopied.m_60795_();
        boolean bl = allowRemove = player.m_7500_() && this.allowCreativeRemoval() || !player.m_7500_() && this.allowSurvivalRemoval();
        if (canRemove && allowRemove) {
            copyBlockEntity.setCopiedBlock(Blocks.f_50016_.m_49966_());
            state.m_60701_((LevelAccessor)level, pos, 3);
            level.m_46672_(pos, state.m_60734_());
            return InteractionResult.SUCCESS;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block targetBlock = blockItem.m_40614_();
            if (targetBlock instanceof ICopyBlock) {
                return InteractionResult.FAIL;
            }
            BlockState targetState = targetBlock.m_5573_(new BlockPlaceContext(level, player, hand, heldItem, hit));
            if (targetState == null) {
                targetState = targetBlock.m_49966_();
            }
            if (!this.allowPartialBlocks() && !targetState.m_60838_((BlockGetter)level, pos)) {
                return InteractionResult.FAIL;
            }
            if (!currentCopied.m_60795_()) {
                if (currentCopied.m_60734_() == targetBlock) {
                    copyBlockEntity.setCopiedBlock(targetState);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (this.consumesItemsOnPlace() && !player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            copyBlockEntity.setCopiedBlock(targetState);
            this.copyblock$playBlockSound(level, pos, targetState);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    default public boolean allowPartialBlocks() {
        return false;
    }

    default public ItemStack copyblock$getCloneItemStack(BlockGetter level, BlockPos pos, BlockState state) {
        ICopyBlockEntity copyBE;
        BlockState copiedState;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity && !(copiedState = (copyBE = (ICopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && mc.f_91074_.m_6144_()) {
                    return new ItemStack((ItemLike)copiedState.m_60734_());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ItemStack.f_41583_;
    }

    default public void copyblock$onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ICopyBlockEntity) {
            ICopyBlockEntity be = (ICopyBlockEntity)blockEntity;
            BlockState copiedState = be.getCopiedBlock();
            VS2CopyBlockIntegration.onBlockRemoved(level, pos, state, copiedState);
            if (!copiedState.m_60795_() && !be.wasRemovedByCreative()) {
                ItemStack droppedItem = new ItemStack((ItemLike)copiedState.m_60734_());
                droppedItem.m_41751_(null);
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, droppedItem));
            }
        }
    }

    default public void copyblock$playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ICopyBlockEntity) {
            ICopyBlockEntity copyBlockEntity = (ICopyBlockEntity)blockEntity;
            if (player.m_7500_()) {
                copyBlockEntity.setRemovedByCreative(true);
            }
        }
    }

    default public void copyblock$setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof ICopyBlockEntity) {
            ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
            copyBE.setCopiedBlock(Blocks.f_50016_.m_49966_());
        }
    }

    default public void copyblock$playBlockSound(Level level, BlockPos pos, BlockState copiedState) {
        if (!level.f_46443_ && !copiedState.m_60795_()) {
            SoundType soundType = copiedState.getSoundType((LevelReader)level, pos, null);
            level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
    }

    default public boolean useDynamicLight() {
        return true;
    }

    default public int copyblock$getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (!this.useDynamicLight()) {
            return 0;
        }
        return 0;
    }
}

