/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.api.registration;

import com.vibey.imitari.api.CopyBlockAPI;
import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.client.CopyBlockModelProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.ApiStatus;

public class CopyBlockRegistration {
    public static int registerForMod(String modId) {
        int count = CopyBlockAPI.autoRegisterModBlocks(modId);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CopyBlockModelProvider.autoRegisterForMod(modId));
        return count;
    }

    public static void registerBlock(ResourceLocation blockId) {
        CopyBlockAPI.registerCopyBlock(blockId);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CopyBlockModelProvider.registerBlock(blockId));
    }

    public static void registerBlock(Block block) {
        CopyBlockAPI.registerCopyBlock(block);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CopyBlockModelProvider.registerBlock(block));
    }

    public static int registerBlocks(Block ... blocks) {
        int count = 0;
        for (Block block : blocks) {
            if (!(block instanceof ICopyBlock)) continue;
            CopyBlockRegistration.registerBlock(block);
            ++count;
        }
        return count;
    }

    public static int registerBlocks(ResourceLocation ... blockIds) {
        for (ResourceLocation id : blockIds) {
            CopyBlockRegistration.registerBlock(id);
        }
        return blockIds.length;
    }

    @ApiStatus.Internal
    public static void initializeImitari() {
        CopyBlockRegistration.registerForMod("imitari");
    }
}

