/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.api.vs2;

import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public class VS2IntegrationAPI {
    public static boolean isVS2Available() {
        return VS2CopyBlockIntegration.isAvailable();
    }

    public static void notifyMassChange(Level level, BlockPos pos, BlockState copyBlockState, BlockState oldCopiedBlock) {
        if (!VS2IntegrationAPI.isVS2Available()) {
            return;
        }
        VS2CopyBlockIntegration.updateCopyBlockMass(level, pos, copyBlockState, oldCopiedBlock);
    }

    public static void notifyBlockEntityLoaded(Level level, BlockPos pos, BlockState state, BlockState copiedBlock) {
        if (!VS2IntegrationAPI.isVS2Available()) {
            return;
        }
        VS2CopyBlockIntegration.onBlockEntityDataLoaded(level, pos, state, copiedBlock);
    }

    public static void registerWithVS2() {
        if (!VS2IntegrationAPI.isVS2Available()) {
            return;
        }
        VS2CopyBlockIntegration.register();
    }

    public static String getVS2Version() {
        if (!VS2IntegrationAPI.isVS2Available()) {
            return null;
        }
        try {
            return ModList.get().getModContainerById("valkyrienskies").map(mc -> mc.getModInfo().getVersion().toString()).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

