/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.block;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.blockentity.CopyBlockEntity;
import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopyBlockLayer
extends Block
implements EntityBlock,
ICopyBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty LAYERS = IntegerProperty.m_61631_((String)"layers", (int)1, (int)8);
    protected static final VoxelShape[][] SHAPES = new VoxelShape[6][9];
    private final float baseMultiplier;

    public CopyBlockLayer(BlockBehaviour.Properties properties) {
        this(properties, 0.125f);
    }

    public CopyBlockLayer(BlockBehaviour.Properties properties, float baseMultiplier) {
        super(properties);
        this.baseMultiplier = baseMultiplier;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public float getMassMultiplier() {
        return this.baseMultiplier;
    }

    public float getEffectiveMassMultiplier(BlockState state) {
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        return this.baseMultiplier * (float)layers;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        super.m_6402_(level, pos, state, placer, stack);
        if (!level.f_46443_ && (Integer)state.m_61143_((Property)LAYERS) == 1 && (be = level.m_7702_(pos)) instanceof CopyBlockEntity) {
            CopyBlockEntity copyBE = (CopyBlockEntity)be;
            copyBE.setCopiedBlock(Blocks.f_50016_.m_49966_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LAYERS});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopyBlockEntity(pos, state);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        CopyBlockEntity copyBE;
        BlockState copiedState;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CopyBlockEntity && !(copiedState = (copyBE = (CopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            float baseResistance = copiedState.m_60734_().m_7325_();
            return baseResistance * this.getEffectiveMassMultiplier(state);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        CopyBlockEntity copyBE;
        BlockState copiedState;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof CopyBlockEntity && !(copiedState = (copyBE = (CopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
            float baseProgress = copiedState.m_60625_(player, level, pos);
            return baseProgress / this.getEffectiveMassMultiplier(state);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.copyblock$getSoundType(state, level, pos, entity);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        return SHAPES[facing.ordinal()][layers];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, level, pos, context);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LAYERS) < 8 || state.m_61143_((Property)FACING) != Direction.UP;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.LAND && state.m_61143_((Property)FACING) == Direction.UP && (Integer)state.m_61143_((Property)LAYERS) < 5;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState existingState = context.m_43725_().m_8055_(pos);
        Direction clickedFace = context.m_43719_();
        if (existingState.m_60713_((Block)this)) {
            Direction existingFacing = (Direction)existingState.m_61143_((Property)FACING);
            int currentLayers = (Integer)existingState.m_61143_((Property)LAYERS);
            if (existingFacing == clickedFace && currentLayers < 8) {
                CopyBlockEntity copyBE;
                BlockState copiedState;
                BlockEntity be;
                if (!context.m_43725_().f_46443_ && (be = context.m_43725_().m_7702_(pos)) instanceof CopyBlockEntity && !(copiedState = (copyBE = (CopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
                    this.copyblock$playBlockSound(context.m_43725_(), pos, copiedState);
                }
                BlockState newState = (BlockState)existingState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, currentLayers + 1)));
                if (!context.m_43725_().f_46443_) {
                    VS2CopyBlockIntegration.onBlockStateChanged(context.m_43725_(), pos, existingState, newState);
                }
                return newState;
            }
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        Direction clickedFace;
        Direction stateFacing;
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return false;
        }
        if (context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)LAYERS) < 8 && (stateFacing = (Direction)state.m_61143_((Property)FACING)) == (clickedFace = context.m_43719_())) {
            return context.m_7058_();
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CopyBlockEntity)) {
            return InteractionResult.PASS;
        }
        CopyBlockEntity copyBlockEntity = (CopyBlockEntity)blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        BlockState currentCopied = copyBlockEntity.getCopiedBlock();
        if (player.m_6144_() && heldItem.m_41720_() == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && heldItem.m_41619_() && !currentCopied.m_60795_() && player.m_7500_()) {
            copyBlockEntity.setCopiedBlock(Blocks.f_50016_.m_49966_());
            state.m_60701_((LevelAccessor)level, pos, 3);
            level.m_46672_(pos, state.m_60734_());
            return InteractionResult.SUCCESS;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block targetBlock = blockItem.m_40614_();
            if (targetBlock instanceof ICopyBlock) {
                return InteractionResult.FAIL;
            }
            BlockState targetState = targetBlock.m_5573_(new BlockPlaceContext(level, player, hand, heldItem, hit));
            if (targetState == null) {
                targetState = targetBlock.m_49966_();
            }
            if (!targetState.m_60838_((BlockGetter)level, pos)) {
                return InteractionResult.FAIL;
            }
            if (!currentCopied.m_60795_()) {
                if (currentCopied.m_60734_() == targetBlock) {
                    copyBlockEntity.setCopiedBlock(targetState);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            copyBlockEntity.setCopiedBlock(targetState);
            this.copyblock$playBlockSound(level, pos, targetState);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack result = this.copyblock$getCloneItemStack(level, pos, state);
        return result.m_41619_() ? super.m_7397_(level, pos, state) : result;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.copyblock$onRemove(state, level, pos, newState, isMoving);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.copyblock$playerWillDestroy(level, pos, state, player);
        super.m_5707_(level, pos, state, player);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.copyblock$getLightEmission(state, level, pos);
    }

    static {
        CopyBlockLayer.SHAPES[0][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[0][1] = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][2] = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][3] = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][4] = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][5] = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][6] = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][7] = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[0][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[1][1] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][2] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][3] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][4] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][5] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][6] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][7] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
        CopyBlockLayer.SHAPES[1][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[2][1] = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][2] = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][3] = Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][4] = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][5] = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][6] = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][7] = Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[2][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[3][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[3][1] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        CopyBlockLayer.SHAPES[3][2] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        CopyBlockLayer.SHAPES[3][3] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0);
        CopyBlockLayer.SHAPES[3][4] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        CopyBlockLayer.SHAPES[3][5] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0);
        CopyBlockLayer.SHAPES[3][6] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
        CopyBlockLayer.SHAPES[3][7] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
        CopyBlockLayer.SHAPES[3][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[4][1] = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][2] = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][3] = Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][4] = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][5] = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][6] = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][7] = Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[4][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][0] = Shapes.m_83040_();
        CopyBlockLayer.SHAPES[5][1] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][2] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][3] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][4] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][5] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][6] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][7] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
        CopyBlockLayer.SHAPES[5][8] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

