/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.block;

import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.blockentity.CopyBlockEntity;
import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CopyBlockSlab
extends Block
implements EntityBlock,
ICopyBlock {
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public CopyBlockSlab(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.BOTTOM));
    }

    @Override
    public float getMassMultiplier() {
        return 0.5f;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.m_6864_(state, new BlockPlaceContext(player, hand, player.m_21120_(hand), hit))) {
            return InteractionResult.PASS;
        }
        return this.copyblock$use(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        if (!level.f_46443_ && (be = level.m_7702_(pos)) instanceof CopyBlockEntity) {
            CopyBlockEntity copyBE = (CopyBlockEntity)be;
            SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            if (type != SlabType.DOUBLE && copyBE.getCopiedBlock().m_60795_()) {
                copyBE.setCopiedBlock(Blocks.f_50016_.m_49966_());
            }
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CopyBlockEntity(pos, state);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.copyblock$getSoundType(state, level, pos, entity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61397_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        if (state.m_60713_((Block)this)) {
            CopyBlockEntity copyBE;
            BlockState copiedState;
            BlockEntity be;
            if (!context.m_43725_().f_46443_ && (be = context.m_43725_().m_7702_(pos)) instanceof CopyBlockEntity && !(copiedState = (copyBE = (CopyBlockEntity)be).getCopiedBlock()).m_60795_()) {
                this.playBlockSound(context.m_43725_(), pos, copiedState);
            }
            BlockState newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.DOUBLE);
            if (!context.m_43725_().f_46443_) {
                VS2CopyBlockIntegration.onBlockStateChanged(context.m_43725_(), pos, state, newState);
            }
            return newState;
        }
        Direction facing = context.m_43719_();
        if (facing == Direction.DOWN || facing != Direction.UP && context.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)SlabType.TOP);
        }
        return this.m_49966_();
    }

    protected void playBlockSound(Level level, BlockPos pos, BlockState copiedState) {
        if (!level.f_46443_ && !copiedState.m_60795_()) {
            SoundType soundType = copiedState.getSoundType((LevelReader)level, pos, null);
            level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity be;
        SlabType newType;
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!oldState.m_60713_(state.m_60734_())) {
            return;
        }
        SlabType oldType = oldState.m_61138_((Property)BlockStateProperties.f_61397_) ? (SlabType)oldState.m_61143_((Property)BlockStateProperties.f_61397_) : SlabType.BOTTOM;
        if (oldType != (newType = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)) && (be = level.m_7702_(pos)) instanceof CopyBlockEntity) {
            CopyBlockEntity copyBE = (CopyBlockEntity)be;
            if (level.f_46443_) {
                Minecraft.m_91087_().execute(() -> {
                    BlockEntity stillThere = level.m_7702_(pos);
                    if (stillThere instanceof CopyBlockEntity) {
                        CopyBlockEntity copyBE2 = (CopyBlockEntity)stillThere;
                        copyBE2.forceModelRefresh();
                    }
                });
            } else {
                level.m_7260_(pos, state, state, 2);
            }
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
        if (type != SlabType.DOUBLE && context.m_43722_().m_41720_() == this.m_5456_()) {
            if (context.m_7058_()) {
                boolean isTop = context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5;
                Direction facing = context.m_43719_();
                if (type == SlabType.BOTTOM) {
                    return facing == Direction.UP || facing != Direction.DOWN && isTop;
                }
                return facing == Direction.DOWN || facing != Direction.UP && !isTop;
            }
            return true;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
        return switch (type) {
            case SlabType.DOUBLE -> Shapes.m_83144_();
            case SlabType.TOP -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
        return switch (type) {
            case SlabType.DOUBLE -> Shapes.m_83144_();
            case SlabType.TOP -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.m_5939_(state, level, pos, context);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
        return type != SlabType.DOUBLE;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.DOUBLE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack result = this.copyblock$getCloneItemStack(level, pos, state);
        return result.m_41619_() ? super.m_7397_(level, pos, state) : result;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.copyblock$onRemove(state, level, pos, newState, isMoving);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.copyblock$playerWillDestroy(level, pos, state, player);
        super.m_5707_(level, pos, state, player);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.copyblock$getLightEmission(state, level, pos);
    }
}

