/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.blockentity;

import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import com.vibey.imitari.client.ClientEventsHandler;
import com.vibey.imitari.client.CopyBlockModel;
import com.vibey.imitari.compat.vs2.VS2CopyBlockIntegration;
import com.vibey.imitari.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyBlockEntity
extends BlockEntity
implements ICopyBlockEntity {
    private BlockState copiedBlock = Blocks.f_50016_.m_49966_();
    private int virtualRotation = 0;
    private boolean removedByCreative = false;

    public CopyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.COPY_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Override
    public BlockState getCopiedBlock() {
        return this.copiedBlock;
    }

    @Override
    public int getVirtualRotation() {
        return this.virtualRotation;
    }

    @Override
    public boolean wasRemovedByCreative() {
        return this.removedByCreative;
    }

    @Override
    public void setRemovedByCreative(boolean value) {
        this.removedByCreative = value;
    }

    @Override
    public boolean hasCopiedBlock() {
        return !this.copiedBlock.m_60795_();
    }

    @Override
    public void forceModelRefresh() {
        if (this.f_58857_ != null) {
            this.requestModelDataUpdate();
            if (this.f_58857_.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEventsHandler.queueBlockUpdate(this.f_58858_));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
            } else {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Override
    public void setCopiedBlock(BlockState newBlock) {
        BlockState oldCopiedBlock = this.copiedBlock;
        this.copiedBlock = newBlock;
        this.virtualRotation = 0;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VS2CopyBlockIntegration.updateCopyBlockMass(this.f_58857_, this.f_58858_, this.m_58900_(), oldCopiedBlock);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(CopyBlockModel.COPIED_STATE, (Object)this.copiedBlock).with(CopyBlockModel.VIRTUAL_ROTATION, (Object)this.virtualRotation).build();
    }

    public void m_142466_(CompoundTag tag) {
        block12: {
            super.m_142466_(tag);
            if (tag.m_128441_("CopiedBlockId")) {
                try {
                    String blockId = tag.m_128461_("CopiedBlockId");
                    ResourceLocation loc = new ResourceLocation(blockId);
                    this.copiedBlock = ((Block)BuiltInRegistries.f_256975_.m_7745_(loc)).m_49966_();
                    if (!tag.m_128441_("CopiedBlock")) break block12;
                    try {
                        this.copiedBlock = NbtUtils.m_247651_((HolderGetter)(this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : null), (CompoundTag)tag.m_128469_("CopiedBlock"));
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    this.copiedBlock = Blocks.f_50016_.m_49966_();
                }
            } else if (tag.m_128441_("CopiedBlock")) {
                try {
                    this.copiedBlock = NbtUtils.m_247651_((HolderGetter)(this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : null), (CompoundTag)tag.m_128469_("CopiedBlock"));
                }
                catch (Exception e) {
                    this.copiedBlock = Blocks.f_50016_.m_49966_();
                }
            } else {
                this.copiedBlock = Blocks.f_50016_.m_49966_();
            }
        }
        this.virtualRotation = tag.m_128451_("VirtualRotation");
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.copiedBlock.m_60795_()) {
            VS2CopyBlockIntegration.onBlockEntityDataLoaded(this.f_58857_, this.f_58858_, this.m_58900_(), this.copiedBlock);
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.requestModelDataUpdate();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEventsHandler.queueBlockUpdate(this.f_58858_));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.copiedBlock.m_60795_()) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)this.copiedBlock.m_60734_());
            tag.m_128359_("CopiedBlockId", blockId.toString());
            tag.m_128365_("CopiedBlock", (Tag)NbtUtils.m_129202_((BlockState)this.copiedBlock));
        }
        tag.m_128405_("VirtualRotation", this.virtualRotation);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.requestModelDataUpdate();
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEventsHandler.queueBlockUpdate(this.f_58858_));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

