/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.client;

import com.vibey.imitari.api.blockentity.ICopyBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyBlockModel
implements BakedModel {
    public static final ModelProperty<BlockState> COPIED_STATE = new ModelProperty();
    public static final ModelProperty<Integer> VIRTUAL_ROTATION = new ModelProperty();
    public static final ModelProperty<boolean[]> CULL_FACES = new ModelProperty();
    private final BakedModel baseModel;

    public CopyBlockModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.baseModel.m_213637_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BlockState copiedState = (BlockState)data.get(COPIED_STATE);
        boolean[] cullFaces = (boolean[])data.get(CULL_FACES);
        List baseQuads = this.baseModel.getQuads(state, side, rand, ModelData.EMPTY, renderType);
        if (copiedState == null || copiedState.m_60795_()) {
            return baseQuads;
        }
        if (cullFaces != null && side != null && cullFaces[side.ordinal()]) {
            return Collections.emptyList();
        }
        if (baseQuads.isEmpty()) {
            return baseQuads;
        }
        BakedModel copiedModel = Minecraft.m_91087_().m_91289_().m_110910_(copiedState);
        List<BakedQuad> copiedFaceQuads = this.getCopiedFaceQuads(copiedModel, copiedState, side, rand, renderType);
        if (copiedFaceQuads.isEmpty()) {
            TextureAtlasSprite fallbackSprite = copiedModel.getParticleIcon(ModelData.EMPTY);
            ArrayList<BakedQuad> remappedQuads = new ArrayList<BakedQuad>(baseQuads.size());
            for (BakedQuad quad : baseQuads) {
                try {
                    remappedQuads.add(this.remapQuadTexture(quad, fallbackSprite, quad.m_111305_()));
                }
                catch (Exception e) {
                    remappedQuads.add(quad);
                }
            }
            return remappedQuads;
        }
        ArrayList<BakedQuad> remappedQuads = new ArrayList<BakedQuad>();
        for (BakedQuad baseQuad : baseQuads) {
            Direction baseQuadDir = baseQuad.m_111306_();
            List<BakedQuad> matchingSourceQuads = this.findAllMatchingQuads(copiedFaceQuads, baseQuadDir);
            if (!matchingSourceQuads.isEmpty()) {
                for (BakedQuad sourceQuad : matchingSourceQuads) {
                    try {
                        remappedQuads.add(this.remapQuadTexture(baseQuad, sourceQuad.m_173410_(), sourceQuad.m_111305_()));
                    }
                    catch (Exception e) {
                        remappedQuads.add(baseQuad);
                    }
                }
                continue;
            }
            try {
                BakedQuad sourceQuad = copiedFaceQuads.get(0);
                remappedQuads.add(this.remapQuadTexture(baseQuad, sourceQuad.m_173410_(), sourceQuad.m_111305_()));
            }
            catch (Exception e) {
                remappedQuads.add(baseQuad);
            }
        }
        if (remappedQuads.isEmpty()) {
            return baseQuads;
        }
        return remappedQuads;
    }

    private List<BakedQuad> findAllMatchingQuads(List<BakedQuad> sourceQuads, Direction targetDir) {
        ArrayList<BakedQuad> matches = new ArrayList<BakedQuad>();
        for (BakedQuad quad : sourceQuads) {
            if (quad.m_111306_() != targetDir) continue;
            matches.add(quad);
        }
        return matches;
    }

    private List<BakedQuad> getCopiedFaceQuads(BakedModel copiedModel, BlockState copiedState, @Nullable Direction side, RandomSource rand, @Nullable RenderType renderType) {
        if (side == null) {
            ArrayList<BakedQuad> allQuads = new ArrayList<BakedQuad>();
            for (Direction dir : Direction.values()) {
                List faceQuads = copiedModel.getQuads(copiedState, dir, rand, ModelData.EMPTY, renderType);
                allQuads.addAll(faceQuads);
            }
            if (!allQuads.isEmpty()) {
                return allQuads;
            }
            return copiedModel.getQuads(copiedState, null, rand, ModelData.EMPTY, renderType);
        }
        List faceQuads = copiedModel.getQuads(copiedState, side, rand, ModelData.EMPTY, renderType);
        if (!faceQuads.isEmpty()) {
            return faceQuads;
        }
        List allQuads = copiedModel.getQuads(copiedState, null, rand, ModelData.EMPTY, renderType);
        if (allQuads.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> filtered = new ArrayList<BakedQuad>();
        for (BakedQuad quad : allQuads) {
            if (quad.m_111306_() != side) continue;
            filtered.add(quad);
        }
        return filtered;
    }

    private BakedQuad remapQuadTexture(BakedQuad originalQuad, TextureAtlasSprite newSprite, int tintIndex) {
        int[] vertexData = (int[])originalQuad.m_111303_().clone();
        TextureAtlasSprite oldSprite = originalQuad.m_173410_();
        for (int i = 0; i < 4; ++i) {
            int offset = i * 8;
            float u = Float.intBitsToFloat(vertexData[offset + 4]);
            float v = Float.intBitsToFloat(vertexData[offset + 5]);
            float relativeU = (u - oldSprite.m_118409_()) / (oldSprite.m_118410_() - oldSprite.m_118409_());
            float relativeV = (v - oldSprite.m_118411_()) / (oldSprite.m_118412_() - oldSprite.m_118411_());
            float newU = newSprite.m_118409_() + relativeU * (newSprite.m_118410_() - newSprite.m_118409_());
            float newV = newSprite.m_118411_() + relativeV * (newSprite.m_118412_() - newSprite.m_118411_());
            vertexData[offset + 4] = Float.floatToRawIntBits(newU);
            vertexData[offset + 5] = Float.floatToRawIntBits(newV);
        }
        return new BakedQuad(vertexData, tintIndex, originalQuad.m_111306_(), newSprite, originalQuad.m_111307_());
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof ICopyBlockEntity) {
            ICopyBlockEntity copyBE = (ICopyBlockEntity)be;
            BlockState copiedState = copyBE.getCopiedBlock();
            boolean[] cullFaces = new boolean[6];
            if (copiedState != null && !copiedState.m_60795_() && this.shouldCullMatchingFaces(copiedState)) {
                for (Direction dir : Direction.values()) {
                    BlockPos neighborPos = pos.m_121945_(dir);
                    BlockState neighborState = level.m_8055_(neighborPos);
                    BlockEntity neighborBE = level.m_7702_(neighborPos);
                    if (!this.doesNeighborCoverFace(state, neighborState, level, pos, neighborPos, dir)) continue;
                    if (neighborBE instanceof ICopyBlockEntity) {
                        ICopyBlockEntity neighborCopyBE = (ICopyBlockEntity)neighborBE;
                        BlockState neighborCopied = neighborCopyBE.getCopiedBlock();
                        if (neighborCopied == null || neighborCopied.m_60734_() != copiedState.m_60734_()) continue;
                        cullFaces[dir.ordinal()] = true;
                        continue;
                    }
                    if (neighborState.m_60734_() != copiedState.m_60734_()) continue;
                    cullFaces[dir.ordinal()] = true;
                }
            }
            return ModelData.builder().with(COPIED_STATE, (Object)(copiedState != null ? copiedState : Blocks.f_50016_.m_49966_())).with(VIRTUAL_ROTATION, (Object)0).with(CULL_FACES, (Object)cullFaces).build();
        }
        return ModelData.builder().with(COPIED_STATE, (Object)Blocks.f_50016_.m_49966_()).with(VIRTUAL_ROTATION, (Object)0).with(CULL_FACES, (Object)new boolean[6]).build();
    }

    private boolean doesNeighborCoverFace(BlockState ourState, BlockState neighborState, BlockAndTintGetter level, BlockPos ourPos, BlockPos neighborPos, Direction dir) {
        VoxelShape ourShape = ourState.m_60655_((BlockGetter)level, ourPos, dir);
        Direction opposite = dir.m_122424_();
        VoxelShape neighborShape = neighborState.m_60655_((BlockGetter)level, neighborPos, opposite);
        if (ourShape.m_83281_()) {
            return false;
        }
        if (neighborShape.m_83281_()) {
            return false;
        }
        return !Shapes.m_83157_((VoxelShape)ourShape, (VoxelShape)neighborShape, (BooleanOp)BooleanOp.f_82685_);
    }

    private boolean shouldCullMatchingFaces(BlockState state) {
        if (state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_152498_) || state.m_60734_().m_49954_().getString().toLowerCase().contains("glass")) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50126_) || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_)) {
            return true;
        }
        return state.m_60713_(Blocks.f_50374_) || state.m_60713_(Blocks.f_50719_);
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockState copiedState = (BlockState)data.get(COPIED_STATE);
        if (copiedState != null && !copiedState.m_60795_()) {
            BakedModel copiedModel = Minecraft.m_91087_().m_91289_().m_110910_(copiedState);
            return copiedModel.getParticleIcon(ModelData.EMPTY);
        }
        return this.baseModel.getParticleIcon(data);
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState copiedState = (BlockState)data.get(COPIED_STATE);
        if (copiedState != null && !copiedState.m_60795_()) {
            BakedModel copiedModel = Minecraft.m_91087_().m_91289_().m_110910_(copiedState);
            return copiedModel.getRenderTypes(copiedState, rand, ModelData.EMPTY);
        }
        return this.baseModel.getRenderTypes(state, rand, data);
    }
}

