/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.client;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.vibey.imitari.api.ICopyBlock;
import com.vibey.imitari.client.CopyBlockModel;
import com.vibey.imitari.client.CopyBlockMultiPartModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class CopyBlockModelProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<ResourceLocation> REGISTERED_BLOCKS = new HashSet<ResourceLocation>();

    public static void registerBlock(ResourceLocation blockId) {
        REGISTERED_BLOCKS.add(blockId);
    }

    public static void registerBlock(Block block) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (id != null) {
            CopyBlockModelProvider.registerBlock(id);
        }
    }

    public static void autoRegisterForMod(String modId) {
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            ICopyBlock copyBlock;
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            Block block = (Block)entry.getValue();
            if (!id.m_135827_().equals(modId) || !(block instanceof ICopyBlock) || !(copyBlock = (ICopyBlock)block).useDynamicModel()) continue;
            CopyBlockModelProvider.registerBlock(id);
        }
    }

    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        BakedModel existingModel;
        ResourceLocation modelId;
        LOGGER.info("[Imitari] Starting model wrapping...");
        Map modelRegistry = event.getModels();
        int wrappedCount = 0;
        ArrayList toWrap = new ArrayList();
        for (Map.Entry entry : modelRegistry.entrySet()) {
            Object blockName;
            modelId = (ResourceLocation)entry.getKey();
            existingModel = (BakedModel)entry.getValue();
            if (existingModel instanceof CopyBlockModel || existingModel instanceof CopyBlockMultiPartModel) continue;
            String path = modelId.m_135815_();
            String namespace = modelId.m_135827_();
            boolean shouldWrap = false;
            if (namespace.equals("imitari")) {
                Object object = blockName = path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
                if (((String)blockName).startsWith("copy_block") && !path.contains("item/") && !path.endsWith("_inventory")) {
                    shouldWrap = true;
                    LOGGER.debug("[Imitari] Found Imitari model: {}", (Object)modelId);
                }
            }
            if (!shouldWrap && !REGISTERED_BLOCKS.isEmpty()) {
                blockName = REGISTERED_BLOCKS.iterator();
                while (blockName.hasNext()) {
                    String modelName;
                    ResourceLocation blockId = (ResourceLocation)blockName.next();
                    if (!namespace.equals(blockId.m_135827_())) continue;
                    String blockName2 = blockId.m_135815_();
                    String string = modelName = path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
                    if (!modelName.equals(blockName2) && !modelName.startsWith(blockName2 + "_") || path.contains("item/") || path.endsWith("_inventory")) continue;
                    shouldWrap = true;
                    LOGGER.debug("[Imitari] Found registered block model: {}", (Object)modelId);
                    break;
                }
            }
            if (!shouldWrap) continue;
            toWrap.add(entry);
        }
        LOGGER.info("[Imitari] Found {} models to wrap", (Object)toWrap.size());
        for (Map.Entry entry : toWrap) {
            modelId = (ResourceLocation)entry.getKey();
            existingModel = (BakedModel)entry.getValue();
            try {
                Object wrappedModel;
                if (existingModel instanceof MultiPartBakedModel) {
                    MultiPartBakedModel multiPartModel = (MultiPartBakedModel)existingModel;
                    List<Pair<Predicate<BlockState>, BakedModel>> selectors = CopyBlockModelProvider.extractSelectors(multiPartModel);
                    if (selectors != null && !selectors.isEmpty()) {
                        ArrayList wrappedSelectors = Lists.newArrayList();
                        for (Pair<Predicate<BlockState>, BakedModel> pair : selectors) {
                            CopyBlockModel wrappedSubModel = new CopyBlockModel((BakedModel)pair.getRight());
                            wrappedSelectors.add(Pair.of((Object)((Predicate)pair.getLeft()), (Object)wrappedSubModel));
                        }
                        wrappedModel = new CopyBlockMultiPartModel((BakedModel)multiPartModel, wrappedSelectors);
                        LOGGER.debug("[Imitari] Wrapped multipart model: {}", (Object)modelId);
                    } else {
                        wrappedModel = new CopyBlockModel(existingModel);
                        LOGGER.debug("[Imitari] Wrapped as single model (multipart extraction failed): {}", (Object)modelId);
                    }
                } else {
                    wrappedModel = new CopyBlockModel(existingModel);
                    LOGGER.debug("[Imitari] Wrapped regular model: {}", (Object)modelId);
                }
                modelRegistry.put(modelId, wrappedModel);
                ++wrappedCount;
            }
            catch (Exception e) {
                LOGGER.error("[Imitari] Failed to wrap model: " + String.valueOf(modelId), (Throwable)e);
            }
        }
        LOGGER.info("[Imitari] Successfully wrapped {} CopyBlock models", (Object)wrappedCount);
    }

    private static List<Pair<Predicate<BlockState>, BakedModel>> extractSelectors(MultiPartBakedModel model) {
        try {
            Field selectorsField = null;
            try {
                selectorsField = MultiPartBakedModel.class.getDeclaredField("selectors");
            }
            catch (NoSuchFieldException e) {
                for (Field field : MultiPartBakedModel.class.getDeclaredFields()) {
                    if (!List.class.isAssignableFrom(field.getType())) continue;
                    selectorsField = field;
                    break;
                }
            }
            if (selectorsField == null) {
                LOGGER.warn("[Imitari] Could not find selectors field in MultiPartBakedModel");
                return null;
            }
            selectorsField.setAccessible(true);
            Object result = selectorsField.get(model);
            if (result instanceof List) {
                return (List)result;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("[Imitari] Failed to extract selectors from MultiPartBakedModel: " + e.getMessage());
            return null;
        }
    }

    public static Set<ResourceLocation> getRegisteredBlocks() {
        return new HashSet<ResourceLocation>(REGISTERED_BLOCKS);
    }

    public static void clearRegistrations() {
        REGISTERED_BLOCKS.clear();
    }
}

