/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.client;

import com.google.common.collect.Lists;
import com.vibey.imitari.client.CopyBlockModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyBlockMultiPartModel
implements BakedModel {
    private final BakedModel baseModel;
    private final List<Pair<Predicate<BlockState>, BakedModel>> selectors;

    public CopyBlockMultiPartModel(BakedModel baseModel, List<Pair<Predicate<BlockState>, BakedModel>> selectors) {
        this.baseModel = baseModel;
        this.selectors = selectors;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.baseModel.m_213637_(state, side, rand);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList quads = Lists.newArrayList();
        for (Pair<Predicate<BlockState>, BakedModel> pair : this.selectors) {
            if (!((Predicate)pair.getLeft()).test(state)) continue;
            BakedModel subModel = (BakedModel)pair.getRight();
            if (subModel instanceof CopyBlockModel) {
                quads.addAll(subModel.getQuads(state, side, rand, extraData, renderType));
                continue;
            }
            CopyBlockModel wrappedModel = new CopyBlockModel(subModel);
            quads.addAll(wrappedModel.getQuads(state, side, rand, extraData, renderType));
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BlockState copiedState = (BlockState)data.get(CopyBlockModel.COPIED_STATE);
        if (copiedState != null && !copiedState.m_60795_()) {
            BakedModel copiedModel = Minecraft.m_91087_().m_91289_().m_110910_(copiedState);
            return copiedModel.getParticleIcon(ModelData.EMPTY);
        }
        return this.baseModel.getParticleIcon(data);
    }

    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.baseModel.m_7343_();
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return new CopyBlockModel(this.baseModel).getModelData(level, pos, state, modelData);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState copiedState = (BlockState)data.get(CopyBlockModel.COPIED_STATE);
        if (copiedState != null && !copiedState.m_60795_()) {
            BakedModel copiedModel = Minecraft.m_91087_().m_91289_().m_110910_(copiedState);
            return copiedModel.getRenderTypes(copiedState, rand, ModelData.EMPTY);
        }
        return this.baseModel.getRenderTypes(state, rand, data);
    }
}

