/*
 * Decompiled with CFR 0.152.
 */
package com.vibey.imitari.compat.cbc;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Method;
import net.minecraftforge.fml.ModList;
import org.slf4j.Logger;

public class CBCIntegration {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean CBC_LOADED = false;
    private static boolean CHECKED = false;
    private static boolean INTEGRATION_FAILED = false;

    public static boolean isAvailable() {
        if (!CHECKED) {
            CBCIntegration.checkCBC();
        }
        return CBC_LOADED && !INTEGRATION_FAILED;
    }

    private static void checkCBC() {
        if (CHECKED) {
            return;
        }
        CBC_LOADED = ModList.get().isLoaded("createbigcannons");
        CHECKED = true;
        if (CBC_LOADED) {
            LOGGER.info("Create Big Cannons detected - enabling block armor integration");
        }
    }

    public static void register() {
        if (!CBCIntegration.isAvailable()) {
            return;
        }
        try {
            Class<?> implClass = Class.forName("com.vibey.imitari.compat.cbc.CBCIntegrationImpl");
            Method registerMethod = implClass.getMethod("register", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
            LOGGER.info("CBC block armor integration registered successfully");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register CBC integration", (Throwable)e);
            INTEGRATION_FAILED = true;
        }
    }
}

